<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSoldItemsPrice-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateSoldItemsPrice-Request
 * @subpackage Structs
 */
class UpdateSoldItemsPrice_Request extends ExtensibleDataContract
{
    /**
     * The DestinationTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DestinationTransactionGuid;
    /**
     * The DestinationTransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationTransactionSnapshotType;
    /**
     * The ItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfItemIdentityForReprice
     */
    public $ItemIds;
    /**
     * The ServiceSpecificItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfServiceSpecificItemIdentityForReprice
     */
    public $ServiceSpecificItemIds;
    /**
     * Constructor method for UpdateSoldItemsPrice-Request
     * @uses UpdateSoldItemsPrice_Request::setDestinationTransactionGuid()
     * @uses UpdateSoldItemsPrice_Request::setDestinationTransactionSnapshotType()
     * @uses UpdateSoldItemsPrice_Request::setItemIds()
     * @uses UpdateSoldItemsPrice_Request::setServiceSpecificItemIds()
     * @param string $destinationTransactionGuid
     * @param string $destinationTransactionSnapshotType
     * @param \patest\ArrayType\ArrayOfItemIdentityForReprice $itemIds
     * @param \patest\ArrayType\ArrayOfServiceSpecificItemIdentityForReprice $serviceSpecificItemIds
     */
    public function __construct($destinationTransactionGuid = null, $destinationTransactionSnapshotType = null, \patest\ArrayType\ArrayOfItemIdentityForReprice $itemIds = null, \patest\ArrayType\ArrayOfServiceSpecificItemIdentityForReprice $serviceSpecificItemIds = null)
    {
        $this
            ->setDestinationTransactionGuid($destinationTransactionGuid)
            ->setDestinationTransactionSnapshotType($destinationTransactionSnapshotType)
            ->setItemIds($itemIds)
            ->setServiceSpecificItemIds($serviceSpecificItemIds);
    }
    /**
     * Get DestinationTransactionGuid value
     * @return string|null
     */
    public function getDestinationTransactionGuid()
    {
        return $this->DestinationTransactionGuid;
    }
    /**
     * Set DestinationTransactionGuid value
     * @param string $destinationTransactionGuid
     * @return \patest\StructType\UpdateSoldItemsPrice_Request
     */
    public function setDestinationTransactionGuid($destinationTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($destinationTransactionGuid) && !is_string($destinationTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationTransactionGuid, true), gettype($destinationTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($destinationTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $destinationTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($destinationTransactionGuid, true)), __LINE__);
        }
        $this->DestinationTransactionGuid = $destinationTransactionGuid;
        return $this;
    }
    /**
     * Get DestinationTransactionSnapshotType value
     * @return string|null
     */
    public function getDestinationTransactionSnapshotType()
    {
        return $this->DestinationTransactionSnapshotType;
    }
    /**
     * Set DestinationTransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinationTransactionSnapshotType
     * @return \patest\StructType\UpdateSoldItemsPrice_Request
     */
    public function setDestinationTransactionSnapshotType($destinationTransactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($destinationTransactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($destinationTransactionSnapshotType) ? implode(', ', $destinationTransactionSnapshotType) : var_export($destinationTransactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->DestinationTransactionSnapshotType = $destinationTransactionSnapshotType;
        return $this;
    }
    /**
     * Get ItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfItemIdentityForReprice|null
     */
    public function getItemIds()
    {
        return isset($this->ItemIds) ? $this->ItemIds : null;
    }
    /**
     * Set ItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfItemIdentityForReprice $itemIds
     * @return \patest\StructType\UpdateSoldItemsPrice_Request
     */
    public function setItemIds(\patest\ArrayType\ArrayOfItemIdentityForReprice $itemIds = null)
    {
        if (is_null($itemIds) || (is_array($itemIds) && empty($itemIds))) {
            unset($this->ItemIds);
        } else {
            $this->ItemIds = $itemIds;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfServiceSpecificItemIdentityForReprice|null
     */
    public function getServiceSpecificItemIds()
    {
        return isset($this->ServiceSpecificItemIds) ? $this->ServiceSpecificItemIds : null;
    }
    /**
     * Set ServiceSpecificItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfServiceSpecificItemIdentityForReprice $serviceSpecificItemIds
     * @return \patest\StructType\UpdateSoldItemsPrice_Request
     */
    public function setServiceSpecificItemIds(\patest\ArrayType\ArrayOfServiceSpecificItemIdentityForReprice $serviceSpecificItemIds = null)
    {
        if (is_null($serviceSpecificItemIds) || (is_array($serviceSpecificItemIds) && empty($serviceSpecificItemIds))) {
            unset($this->ServiceSpecificItemIds);
        } else {
            $this->ServiceSpecificItemIds = $serviceSpecificItemIds;
        }
        return $this;
    }
}
