<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePresale-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdatePresale-Request
 * @subpackage Structs
 */
class UpdatePresale_Request extends ExtensibleDataContract
{
    /**
     * The Presale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PresaleUpdater
     */
    public $Presale;
    /**
     * The PresaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleId;
    /**
     * Constructor method for UpdatePresale-Request
     * @uses UpdatePresale_Request::setPresale()
     * @uses UpdatePresale_Request::setPresaleId()
     * @param \patest\StructType\PresaleUpdater $presale
     * @param string $presaleId
     */
    public function __construct(\patest\StructType\PresaleUpdater $presale = null, $presaleId = null)
    {
        $this
            ->setPresale($presale)
            ->setPresaleId($presaleId);
    }
    /**
     * Get Presale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PresaleUpdater|null
     */
    public function getPresale()
    {
        return isset($this->Presale) ? $this->Presale : null;
    }
    /**
     * Set Presale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PresaleUpdater $presale
     * @return \patest\StructType\UpdatePresale_Request
     */
    public function setPresale(\patest\StructType\PresaleUpdater $presale = null)
    {
        if (is_null($presale) || (is_array($presale) && empty($presale))) {
            unset($this->Presale);
        } else {
            $this->Presale = $presale;
        }
        return $this;
    }
    /**
     * Get PresaleId value
     * @return string|null
     */
    public function getPresaleId()
    {
        return $this->PresaleId;
    }
    /**
     * Set PresaleId value
     * @param string $presaleId
     * @return \patest\StructType\UpdatePresale_Request
     */
    public function setPresaleId($presaleId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleId) && !is_string($presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleId, true), gettype($presaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleId, true)), __LINE__);
        }
        $this->PresaleId = $presaleId;
        return $this;
    }
}
