<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateGlobalMonitorsRequestItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateGlobalMonitorsRequestItem
 * @subpackage Structs
 */
class UpdateGlobalMonitorsRequestItem extends AbstractStructBase
{
    /**
     * The Avg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Avg;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Count;
    /**
     * The ExceptionalCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ExceptionalCount;
    /**
     * The FailedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FailedCount;
    /**
     * The InstanceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\InstanceIdentifier
     */
    public $InstanceId;
    /**
     * The LastObserved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LastObserved;
    /**
     * The Max
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Max;
    /**
     * The Min
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Min;
    /**
     * The MonitorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MonitorName;
    /**
     * Constructor method for UpdateGlobalMonitorsRequestItem
     * @uses UpdateGlobalMonitorsRequestItem::setAvg()
     * @uses UpdateGlobalMonitorsRequestItem::setCount()
     * @uses UpdateGlobalMonitorsRequestItem::setExceptionalCount()
     * @uses UpdateGlobalMonitorsRequestItem::setFailedCount()
     * @uses UpdateGlobalMonitorsRequestItem::setInstanceId()
     * @uses UpdateGlobalMonitorsRequestItem::setLastObserved()
     * @uses UpdateGlobalMonitorsRequestItem::setMax()
     * @uses UpdateGlobalMonitorsRequestItem::setMin()
     * @uses UpdateGlobalMonitorsRequestItem::setMonitorName()
     * @param float $avg
     * @param int $count
     * @param int $exceptionalCount
     * @param int $failedCount
     * @param \patest\StructType\InstanceIdentifier $instanceId
     * @param int $lastObserved
     * @param int $max
     * @param int $min
     * @param string $monitorName
     */
    public function __construct($avg = null, $count = null, $exceptionalCount = null, $failedCount = null, \patest\StructType\InstanceIdentifier $instanceId = null, $lastObserved = null, $max = null, $min = null, $monitorName = null)
    {
        $this
            ->setAvg($avg)
            ->setCount($count)
            ->setExceptionalCount($exceptionalCount)
            ->setFailedCount($failedCount)
            ->setInstanceId($instanceId)
            ->setLastObserved($lastObserved)
            ->setMax($max)
            ->setMin($min)
            ->setMonitorName($monitorName);
    }
    /**
     * Get Avg value
     * @return float|null
     */
    public function getAvg()
    {
        return $this->Avg;
    }
    /**
     * Set Avg value
     * @param float $avg
     * @return \patest\StructType\UpdateGlobalMonitorsRequestItem
     */
    public function setAvg($avg = null)
    {
        // validation for constraint: float
        if (!is_null($avg) && !(is_float($avg) || is_numeric($avg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($avg, true), gettype($avg)), __LINE__);
        }
        $this->Avg = $avg;
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \patest\StructType\UpdateGlobalMonitorsRequestItem
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get ExceptionalCount value
     * @return int|null
     */
    public function getExceptionalCount()
    {
        return $this->ExceptionalCount;
    }
    /**
     * Set ExceptionalCount value
     * @param int $exceptionalCount
     * @return \patest\StructType\UpdateGlobalMonitorsRequestItem
     */
    public function setExceptionalCount($exceptionalCount = null)
    {
        // validation for constraint: int
        if (!is_null($exceptionalCount) && !(is_int($exceptionalCount) || ctype_digit($exceptionalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exceptionalCount, true), gettype($exceptionalCount)), __LINE__);
        }
        $this->ExceptionalCount = $exceptionalCount;
        return $this;
    }
    /**
     * Get FailedCount value
     * @return int|null
     */
    public function getFailedCount()
    {
        return $this->FailedCount;
    }
    /**
     * Set FailedCount value
     * @param int $failedCount
     * @return \patest\StructType\UpdateGlobalMonitorsRequestItem
     */
    public function setFailedCount($failedCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedCount) && !(is_int($failedCount) || ctype_digit($failedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedCount, true), gettype($failedCount)), __LINE__);
        }
        $this->FailedCount = $failedCount;
        return $this;
    }
    /**
     * Get InstanceId value
     * @return \patest\StructType\InstanceIdentifier|null
     */
    public function getInstanceId()
    {
        return $this->InstanceId;
    }
    /**
     * Set InstanceId value
     * @param \patest\StructType\InstanceIdentifier $instanceId
     * @return \patest\StructType\UpdateGlobalMonitorsRequestItem
     */
    public function setInstanceId(\patest\StructType\InstanceIdentifier $instanceId = null)
    {
        $this->InstanceId = $instanceId;
        return $this;
    }
    /**
     * Get LastObserved value
     * @return int|null
     */
    public function getLastObserved()
    {
        return $this->LastObserved;
    }
    /**
     * Set LastObserved value
     * @param int $lastObserved
     * @return \patest\StructType\UpdateGlobalMonitorsRequestItem
     */
    public function setLastObserved($lastObserved = null)
    {
        // validation for constraint: int
        if (!is_null($lastObserved) && !(is_int($lastObserved) || ctype_digit($lastObserved))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastObserved, true), gettype($lastObserved)), __LINE__);
        }
        $this->LastObserved = $lastObserved;
        return $this;
    }
    /**
     * Get Max value
     * @return int|null
     */
    public function getMax()
    {
        return $this->Max;
    }
    /**
     * Set Max value
     * @param int $max
     * @return \patest\StructType\UpdateGlobalMonitorsRequestItem
     */
    public function setMax($max = null)
    {
        // validation for constraint: int
        if (!is_null($max) && !(is_int($max) || ctype_digit($max))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($max, true), gettype($max)), __LINE__);
        }
        $this->Max = $max;
        return $this;
    }
    /**
     * Get Min value
     * @return int|null
     */
    public function getMin()
    {
        return $this->Min;
    }
    /**
     * Set Min value
     * @param int $min
     * @return \patest\StructType\UpdateGlobalMonitorsRequestItem
     */
    public function setMin($min = null)
    {
        // validation for constraint: int
        if (!is_null($min) && !(is_int($min) || ctype_digit($min))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($min, true), gettype($min)), __LINE__);
        }
        $this->Min = $min;
        return $this;
    }
    /**
     * Get MonitorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMonitorName()
    {
        return isset($this->MonitorName) ? $this->MonitorName : null;
    }
    /**
     * Set MonitorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $monitorName
     * @return \patest\StructType\UpdateGlobalMonitorsRequestItem
     */
    public function setMonitorName($monitorName = null)
    {
        // validation for constraint: string
        if (!is_null($monitorName) && !is_string($monitorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monitorName, true), gettype($monitorName)), __LINE__);
        }
        if (is_null($monitorName) || (is_array($monitorName) && empty($monitorName))) {
            unset($this->MonitorName);
        } else {
            $this->MonitorName = $monitorName;
        }
        return $this;
    }
}
