<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateExistingTicketProperties-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateExistingTicketProperties-Request
 * @subpackage Structs
 */
class UpdateExistingTicketProperties_Request extends ExtensibleDataContract
{
    /**
     * The AllowDowngrade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowDowngrade;
    /**
     * The ChangeSubsTicketAppliedPriceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ChangeSubsTicketAppliedPriceListType
     */
    public $ChangeSubsTicketAppliedPriceList;
    /**
     * The ItemsToUpdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfOverridableExistingTicketProperty
     */
    public $ItemsToUpdate;
    /**
     * The ThrowExceptionIfInvalid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ThrowExceptionIfInvalid;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for UpdateExistingTicketProperties-Request
     * @uses UpdateExistingTicketProperties_Request::setAllowDowngrade()
     * @uses UpdateExistingTicketProperties_Request::setChangeSubsTicketAppliedPriceList()
     * @uses UpdateExistingTicketProperties_Request::setItemsToUpdate()
     * @uses UpdateExistingTicketProperties_Request::setThrowExceptionIfInvalid()
     * @uses UpdateExistingTicketProperties_Request::setTransactionId()
     * @uses UpdateExistingTicketProperties_Request::setTransactionSnapshotType()
     * @param bool $allowDowngrade
     * @param \patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList
     * @param \patest\ArrayType\ArrayOfOverridableExistingTicketProperty $itemsToUpdate
     * @param bool $throwExceptionIfInvalid
     * @param string $transactionId
     * @param string $transactionSnapshotType
     */
    public function __construct($allowDowngrade = null, \patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList = null, \patest\ArrayType\ArrayOfOverridableExistingTicketProperty $itemsToUpdate = null, $throwExceptionIfInvalid = null, $transactionId = null, $transactionSnapshotType = null)
    {
        $this
            ->setAllowDowngrade($allowDowngrade)
            ->setChangeSubsTicketAppliedPriceList($changeSubsTicketAppliedPriceList)
            ->setItemsToUpdate($itemsToUpdate)
            ->setThrowExceptionIfInvalid($throwExceptionIfInvalid)
            ->setTransactionId($transactionId)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get AllowDowngrade value
     * @return bool|null
     */
    public function getAllowDowngrade()
    {
        return $this->AllowDowngrade;
    }
    /**
     * Set AllowDowngrade value
     * @param bool $allowDowngrade
     * @return \patest\StructType\UpdateExistingTicketProperties_Request
     */
    public function setAllowDowngrade($allowDowngrade = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowDowngrade) && !is_bool($allowDowngrade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowDowngrade, true), gettype($allowDowngrade)), __LINE__);
        }
        $this->AllowDowngrade = $allowDowngrade;
        return $this;
    }
    /**
     * Get ChangeSubsTicketAppliedPriceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ChangeSubsTicketAppliedPriceListType|null
     */
    public function getChangeSubsTicketAppliedPriceList()
    {
        return isset($this->ChangeSubsTicketAppliedPriceList) ? $this->ChangeSubsTicketAppliedPriceList : null;
    }
    /**
     * Set ChangeSubsTicketAppliedPriceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList
     * @return \patest\StructType\UpdateExistingTicketProperties_Request
     */
    public function setChangeSubsTicketAppliedPriceList(\patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList = null)
    {
        if (is_null($changeSubsTicketAppliedPriceList) || (is_array($changeSubsTicketAppliedPriceList) && empty($changeSubsTicketAppliedPriceList))) {
            unset($this->ChangeSubsTicketAppliedPriceList);
        } else {
            $this->ChangeSubsTicketAppliedPriceList = $changeSubsTicketAppliedPriceList;
        }
        return $this;
    }
    /**
     * Get ItemsToUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfOverridableExistingTicketProperty|null
     */
    public function getItemsToUpdate()
    {
        return isset($this->ItemsToUpdate) ? $this->ItemsToUpdate : null;
    }
    /**
     * Set ItemsToUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfOverridableExistingTicketProperty $itemsToUpdate
     * @return \patest\StructType\UpdateExistingTicketProperties_Request
     */
    public function setItemsToUpdate(\patest\ArrayType\ArrayOfOverridableExistingTicketProperty $itemsToUpdate = null)
    {
        if (is_null($itemsToUpdate) || (is_array($itemsToUpdate) && empty($itemsToUpdate))) {
            unset($this->ItemsToUpdate);
        } else {
            $this->ItemsToUpdate = $itemsToUpdate;
        }
        return $this;
    }
    /**
     * Get ThrowExceptionIfInvalid value
     * @return bool|null
     */
    public function getThrowExceptionIfInvalid()
    {
        return $this->ThrowExceptionIfInvalid;
    }
    /**
     * Set ThrowExceptionIfInvalid value
     * @param bool $throwExceptionIfInvalid
     * @return \patest\StructType\UpdateExistingTicketProperties_Request
     */
    public function setThrowExceptionIfInvalid($throwExceptionIfInvalid = null)
    {
        // validation for constraint: boolean
        if (!is_null($throwExceptionIfInvalid) && !is_bool($throwExceptionIfInvalid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($throwExceptionIfInvalid, true), gettype($throwExceptionIfInvalid)), __LINE__);
        }
        $this->ThrowExceptionIfInvalid = $throwExceptionIfInvalid;
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \patest\StructType\UpdateExistingTicketProperties_Request
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\UpdateExistingTicketProperties_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
