<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEventTicketViewConfiguration-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateEventTicketViewConfiguration-Request
 * @subpackage Structs
 */
class UpdateEventTicketViewConfiguration_Request extends ExtensibleDataContract
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The TicketViewConfigurationsEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TicketViewConfigurationsEnabled;
    /**
     * The TicketViewConfigurationsTesterClientType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketViewConfigurationsTesterClientType;
    /**
     * Constructor method for UpdateEventTicketViewConfiguration-Request
     * @uses UpdateEventTicketViewConfiguration_Request::setEventId()
     * @uses UpdateEventTicketViewConfiguration_Request::setTicketViewConfigurationsEnabled()
     * @uses UpdateEventTicketViewConfiguration_Request::setTicketViewConfigurationsTesterClientType()
     * @param string $eventId
     * @param bool $ticketViewConfigurationsEnabled
     * @param string $ticketViewConfigurationsTesterClientType
     */
    public function __construct($eventId = null, $ticketViewConfigurationsEnabled = null, $ticketViewConfigurationsTesterClientType = null)
    {
        $this
            ->setEventId($eventId)
            ->setTicketViewConfigurationsEnabled($ticketViewConfigurationsEnabled)
            ->setTicketViewConfigurationsTesterClientType($ticketViewConfigurationsTesterClientType);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\UpdateEventTicketViewConfiguration_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get TicketViewConfigurationsEnabled value
     * @return bool|null
     */
    public function getTicketViewConfigurationsEnabled()
    {
        return $this->TicketViewConfigurationsEnabled;
    }
    /**
     * Set TicketViewConfigurationsEnabled value
     * @param bool $ticketViewConfigurationsEnabled
     * @return \patest\StructType\UpdateEventTicketViewConfiguration_Request
     */
    public function setTicketViewConfigurationsEnabled($ticketViewConfigurationsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($ticketViewConfigurationsEnabled) && !is_bool($ticketViewConfigurationsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ticketViewConfigurationsEnabled, true), gettype($ticketViewConfigurationsEnabled)), __LINE__);
        }
        $this->TicketViewConfigurationsEnabled = $ticketViewConfigurationsEnabled;
        return $this;
    }
    /**
     * Get TicketViewConfigurationsTesterClientType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketViewConfigurationsTesterClientType()
    {
        return isset($this->TicketViewConfigurationsTesterClientType) ? $this->TicketViewConfigurationsTesterClientType : null;
    }
    /**
     * Set TicketViewConfigurationsTesterClientType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketViewConfigurationsTesterClientType
     * @return \patest\StructType\UpdateEventTicketViewConfiguration_Request
     */
    public function setTicketViewConfigurationsTesterClientType($ticketViewConfigurationsTesterClientType = null)
    {
        // validation for constraint: string
        if (!is_null($ticketViewConfigurationsTesterClientType) && !is_string($ticketViewConfigurationsTesterClientType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketViewConfigurationsTesterClientType, true), gettype($ticketViewConfigurationsTesterClientType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketViewConfigurationsTesterClientType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketViewConfigurationsTesterClientType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketViewConfigurationsTesterClientType, true)), __LINE__);
        }
        if (is_null($ticketViewConfigurationsTesterClientType) || (is_array($ticketViewConfigurationsTesterClientType) && empty($ticketViewConfigurationsTesterClientType))) {
            unset($this->TicketViewConfigurationsTesterClientType);
        } else {
            $this->TicketViewConfigurationsTesterClientType = $ticketViewConfigurationsTesterClientType;
        }
        return $this;
    }
}
