<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomSeatPricesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateCustomSeatPricesRequest
 * @subpackage Structs
 */
class UpdateCustomSeatPricesRequest extends CustomSeatPricesRequest
{
    /**
     * The CustomSeatPricesByArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfCustomSeatPricehpjoQDea
     */
    public $CustomSeatPricesByArea;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IgnoreInvalidSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IgnoreInvalidSeats;
    /**
     * Constructor method for UpdateCustomSeatPricesRequest
     * @uses UpdateCustomSeatPricesRequest::setCustomSeatPricesByArea()
     * @uses UpdateCustomSeatPricesRequest::setEventId()
     * @uses UpdateCustomSeatPricesRequest::setIgnoreInvalidSeats()
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfCustomSeatPricehpjoQDea $customSeatPricesByArea
     * @param string $eventId
     * @param bool $ignoreInvalidSeats
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfguidArrayOfCustomSeatPricehpjoQDea $customSeatPricesByArea = null, $eventId = null, $ignoreInvalidSeats = null)
    {
        $this
            ->setCustomSeatPricesByArea($customSeatPricesByArea)
            ->setEventId($eventId)
            ->setIgnoreInvalidSeats($ignoreInvalidSeats);
    }
    /**
     * Get CustomSeatPricesByArea value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfCustomSeatPricehpjoQDea|null
     */
    public function getCustomSeatPricesByArea()
    {
        return isset($this->CustomSeatPricesByArea) ? $this->CustomSeatPricesByArea : null;
    }
    /**
     * Set CustomSeatPricesByArea value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfCustomSeatPricehpjoQDea $customSeatPricesByArea
     * @return \patest\StructType\UpdateCustomSeatPricesRequest
     */
    public function setCustomSeatPricesByArea(\patest\ArrayType\ArrayOfKeyValueOfguidArrayOfCustomSeatPricehpjoQDea $customSeatPricesByArea = null)
    {
        if (is_null($customSeatPricesByArea) || (is_array($customSeatPricesByArea) && empty($customSeatPricesByArea))) {
            unset($this->CustomSeatPricesByArea);
        } else {
            $this->CustomSeatPricesByArea = $customSeatPricesByArea;
        }
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\UpdateCustomSeatPricesRequest
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get IgnoreInvalidSeats value
     * @return bool|null
     */
    public function getIgnoreInvalidSeats()
    {
        return $this->IgnoreInvalidSeats;
    }
    /**
     * Set IgnoreInvalidSeats value
     * @param bool $ignoreInvalidSeats
     * @return \patest\StructType\UpdateCustomSeatPricesRequest
     */
    public function setIgnoreInvalidSeats($ignoreInvalidSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreInvalidSeats) && !is_bool($ignoreInvalidSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreInvalidSeats, true), gettype($ignoreInvalidSeats)), __LINE__);
        }
        $this->IgnoreInvalidSeats = $ignoreInvalidSeats;
        return $this;
    }
}
