<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnionSubsidyPaymentDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UnionSubsidyPaymentDescription
 * @subpackage Structs
 */
class UnionSubsidyPaymentDescription extends AbstractPaymentDescription
{
    /**
     * The SubsidizingAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubsidizingAccountId;
    /**
     * Constructor method for UnionSubsidyPaymentDescription
     * @uses UnionSubsidyPaymentDescription::setSubsidizingAccountId()
     * @param string $subsidizingAccountId
     */
    public function __construct($subsidizingAccountId = null)
    {
        $this
            ->setSubsidizingAccountId($subsidizingAccountId);
    }
    /**
     * Get SubsidizingAccountId value
     * @return string|null
     */
    public function getSubsidizingAccountId()
    {
        return $this->SubsidizingAccountId;
    }
    /**
     * Set SubsidizingAccountId value
     * @param string $subsidizingAccountId
     * @return \patest\StructType\UnionSubsidyPaymentDescription
     */
    public function setSubsidizingAccountId($subsidizingAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizingAccountId) && !is_string($subsidizingAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizingAccountId, true), gettype($subsidizingAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subsidizingAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subsidizingAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subsidizingAccountId, true)), __LINE__);
        }
        $this->SubsidizingAccountId = $subsidizingAccountId;
        return $this;
    }
}
