<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TriggerFullEtlResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TriggerFullEtlResponse
 * @subpackage Structs
 */
class TriggerFullEtlResponse extends AbstractStructBase
{
    /**
     * The CurrentRunId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CurrentRunId;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorCode;
    /**
     * The EtlProcessId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EtlProcessId;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The StartedAtUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartedAtUtc;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Success;
    /**
     * Constructor method for TriggerFullEtlResponse
     * @uses TriggerFullEtlResponse::setCurrentRunId()
     * @uses TriggerFullEtlResponse::setErrorCode()
     * @uses TriggerFullEtlResponse::setEtlProcessId()
     * @uses TriggerFullEtlResponse::setMessage()
     * @uses TriggerFullEtlResponse::setStartedAtUtc()
     * @uses TriggerFullEtlResponse::setSuccess()
     * @param int $currentRunId
     * @param string $errorCode
     * @param string $etlProcessId
     * @param string $message
     * @param string $startedAtUtc
     * @param bool $success
     */
    public function __construct($currentRunId = null, $errorCode = null, $etlProcessId = null, $message = null, $startedAtUtc = null, $success = null)
    {
        $this
            ->setCurrentRunId($currentRunId)
            ->setErrorCode($errorCode)
            ->setEtlProcessId($etlProcessId)
            ->setMessage($message)
            ->setStartedAtUtc($startedAtUtc)
            ->setSuccess($success);
    }
    /**
     * Get CurrentRunId value
     * @return int|null
     */
    public function getCurrentRunId()
    {
        return $this->CurrentRunId;
    }
    /**
     * Set CurrentRunId value
     * @param int $currentRunId
     * @return \patest\StructType\TriggerFullEtlResponse
     */
    public function setCurrentRunId($currentRunId = null)
    {
        // validation for constraint: int
        if (!is_null($currentRunId) && !(is_int($currentRunId) || ctype_digit($currentRunId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentRunId, true), gettype($currentRunId)), __LINE__);
        }
        $this->CurrentRunId = $currentRunId;
        return $this;
    }
    /**
     * Get ErrorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorCode()
    {
        return isset($this->ErrorCode) ? $this->ErrorCode : null;
    }
    /**
     * Set ErrorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorCode
     * @return \patest\StructType\TriggerFullEtlResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        if (is_null($errorCode) || (is_array($errorCode) && empty($errorCode))) {
            unset($this->ErrorCode);
        } else {
            $this->ErrorCode = $errorCode;
        }
        return $this;
    }
    /**
     * Get EtlProcessId value
     * @return string|null
     */
    public function getEtlProcessId()
    {
        return $this->EtlProcessId;
    }
    /**
     * Set EtlProcessId value
     * @param string $etlProcessId
     * @return \patest\StructType\TriggerFullEtlResponse
     */
    public function setEtlProcessId($etlProcessId = null)
    {
        // validation for constraint: string
        if (!is_null($etlProcessId) && !is_string($etlProcessId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($etlProcessId, true), gettype($etlProcessId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($etlProcessId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $etlProcessId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($etlProcessId, true)), __LINE__);
        }
        $this->EtlProcessId = $etlProcessId;
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \patest\StructType\TriggerFullEtlResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get StartedAtUtc value
     * @return string|null
     */
    public function getStartedAtUtc()
    {
        return $this->StartedAtUtc;
    }
    /**
     * Set StartedAtUtc value
     * @param string $startedAtUtc
     * @return \patest\StructType\TriggerFullEtlResponse
     */
    public function setStartedAtUtc($startedAtUtc = null)
    {
        // validation for constraint: string
        if (!is_null($startedAtUtc) && !is_string($startedAtUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startedAtUtc, true), gettype($startedAtUtc)), __LINE__);
        }
        $this->StartedAtUtc = $startedAtUtc;
        return $this;
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \patest\StructType\TriggerFullEtlResponse
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
}
