<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionItem
 * @subpackage Structs
 */
class TransactionItem extends AbstractStructBase
{
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AbstractItem
     */
    public $Item;
    /**
     * The SourceItemIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ItemIdentity
     */
    public $SourceItemIdentity;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for TransactionItem
     * @uses TransactionItem::setItem()
     * @uses TransactionItem::setSourceItemIdentity()
     * @uses TransactionItem::setTransactionGuid()
     * @uses TransactionItem::setTransactionNumber()
     * @param \patest\StructType\AbstractItem $item
     * @param \patest\StructType\ItemIdentity $sourceItemIdentity
     * @param string $transactionGuid
     * @param int $transactionNumber
     */
    public function __construct(\patest\StructType\AbstractItem $item = null, \patest\StructType\ItemIdentity $sourceItemIdentity = null, $transactionGuid = null, $transactionNumber = null)
    {
        $this
            ->setItem($item)
            ->setSourceItemIdentity($sourceItemIdentity)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get Item value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AbstractItem|null
     */
    public function getItem()
    {
        return isset($this->Item) ? $this->Item : null;
    }
    /**
     * Set Item value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AbstractItem $item
     * @return \patest\StructType\TransactionItem
     */
    public function setItem(\patest\StructType\AbstractItem $item = null)
    {
        if (is_null($item) || (is_array($item) && empty($item))) {
            unset($this->Item);
        } else {
            $this->Item = $item;
        }
        return $this;
    }
    /**
     * Get SourceItemIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ItemIdentity|null
     */
    public function getSourceItemIdentity()
    {
        return isset($this->SourceItemIdentity) ? $this->SourceItemIdentity : null;
    }
    /**
     * Set SourceItemIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ItemIdentity $sourceItemIdentity
     * @return \patest\StructType\TransactionItem
     */
    public function setSourceItemIdentity(\patest\StructType\ItemIdentity $sourceItemIdentity = null)
    {
        if (is_null($sourceItemIdentity) || (is_array($sourceItemIdentity) && empty($sourceItemIdentity))) {
            unset($this->SourceItemIdentity);
        } else {
            $this->SourceItemIdentity = $sourceItemIdentity;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\TransactionItem
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionNumber value
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return $this->TransactionNumber;
    }
    /**
     * Set TransactionNumber value
     * @param int $transactionNumber
     * @return \patest\StructType\TransactionItem
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        $this->TransactionNumber = $transactionNumber;
        return $this;
    }
}
