<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionClient StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionClient
 * @subpackage Structs
 */
class TransactionClient extends AbstractStructBase
{
    /**
     * The ClientDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_Client
     */
    public $ClientDetails;
    /**
     * The IsNewClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsNewClient;
    /**
     * Constructor method for TransactionClient
     * @uses TransactionClient::setClientDetails()
     * @uses TransactionClient::setIsNewClient()
     * @param \patest\StructType\Crm_Client $clientDetails
     * @param bool $isNewClient
     */
    public function __construct(\patest\StructType\Crm_Client $clientDetails = null, $isNewClient = null)
    {
        $this
            ->setClientDetails($clientDetails)
            ->setIsNewClient($isNewClient);
    }
    /**
     * Get ClientDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_Client|null
     */
    public function getClientDetails()
    {
        return isset($this->ClientDetails) ? $this->ClientDetails : null;
    }
    /**
     * Set ClientDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_Client $clientDetails
     * @return \patest\StructType\TransactionClient
     */
    public function setClientDetails(\patest\StructType\Crm_Client $clientDetails = null)
    {
        if (is_null($clientDetails) || (is_array($clientDetails) && empty($clientDetails))) {
            unset($this->ClientDetails);
        } else {
            $this->ClientDetails = $clientDetails;
        }
        return $this;
    }
    /**
     * Get IsNewClient value
     * @return bool|null
     */
    public function getIsNewClient()
    {
        return $this->IsNewClient;
    }
    /**
     * Set IsNewClient value
     * @param bool $isNewClient
     * @return \patest\StructType\TransactionClient
     */
    public function setIsNewClient($isNewClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNewClient) && !is_bool($isNewClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNewClient, true), gettype($isNewClient)), __LINE__);
        }
        $this->IsNewClient = $isNewClient;
        return $this;
    }
}
