<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TraceFilterItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TraceFilterItem
 * @subpackage Structs
 */
class TraceFilterItem extends AbstractStructBase
{
    /**
     * The ContextId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextId;
    /**
     * The HitCategoryContains
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $HitCategoryContains;
    /**
     * The IsExcludeExceptionalHits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExcludeExceptionalHits;
    /**
     * The IsExcludeFailedHits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExcludeFailedHits;
    /**
     * The IsExcludeHitsWithErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExcludeHitsWithErrors;
    /**
     * The IsExcludeOtherHits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExcludeOtherHits;
    /**
     * The IsExcludeSuspiciousHits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExcludeSuspiciousHits;
    /**
     * The IsIncludeNonApiHits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsIncludeNonApiHits;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemName;
    /**
     * The MinCpuTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinCpuTime;
    /**
     * The MinDbTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinDbTime;
    /**
     * The MinDuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinDuration;
    /**
     * Constructor method for TraceFilterItem
     * @uses TraceFilterItem::setContextId()
     * @uses TraceFilterItem::setHitCategoryContains()
     * @uses TraceFilterItem::setIsExcludeExceptionalHits()
     * @uses TraceFilterItem::setIsExcludeFailedHits()
     * @uses TraceFilterItem::setIsExcludeHitsWithErrors()
     * @uses TraceFilterItem::setIsExcludeOtherHits()
     * @uses TraceFilterItem::setIsExcludeSuspiciousHits()
     * @uses TraceFilterItem::setIsIncludeNonApiHits()
     * @uses TraceFilterItem::setItemName()
     * @uses TraceFilterItem::setMinCpuTime()
     * @uses TraceFilterItem::setMinDbTime()
     * @uses TraceFilterItem::setMinDuration()
     * @param string $contextId
     * @param \patest\ArrayType\ArrayOfstring $hitCategoryContains
     * @param bool $isExcludeExceptionalHits
     * @param bool $isExcludeFailedHits
     * @param bool $isExcludeHitsWithErrors
     * @param bool $isExcludeOtherHits
     * @param bool $isExcludeSuspiciousHits
     * @param bool $isIncludeNonApiHits
     * @param string $itemName
     * @param int $minCpuTime
     * @param int $minDbTime
     * @param int $minDuration
     */
    public function __construct($contextId = null, \patest\ArrayType\ArrayOfstring $hitCategoryContains = null, $isExcludeExceptionalHits = null, $isExcludeFailedHits = null, $isExcludeHitsWithErrors = null, $isExcludeOtherHits = null, $isExcludeSuspiciousHits = null, $isIncludeNonApiHits = null, $itemName = null, $minCpuTime = null, $minDbTime = null, $minDuration = null)
    {
        $this
            ->setContextId($contextId)
            ->setHitCategoryContains($hitCategoryContains)
            ->setIsExcludeExceptionalHits($isExcludeExceptionalHits)
            ->setIsExcludeFailedHits($isExcludeFailedHits)
            ->setIsExcludeHitsWithErrors($isExcludeHitsWithErrors)
            ->setIsExcludeOtherHits($isExcludeOtherHits)
            ->setIsExcludeSuspiciousHits($isExcludeSuspiciousHits)
            ->setIsIncludeNonApiHits($isIncludeNonApiHits)
            ->setItemName($itemName)
            ->setMinCpuTime($minCpuTime)
            ->setMinDbTime($minDbTime)
            ->setMinDuration($minDuration);
    }
    /**
     * Get ContextId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextId()
    {
        return isset($this->ContextId) ? $this->ContextId : null;
    }
    /**
     * Set ContextId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextId
     * @return \patest\StructType\TraceFilterItem
     */
    public function setContextId($contextId = null)
    {
        // validation for constraint: string
        if (!is_null($contextId) && !is_string($contextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextId, true), gettype($contextId)), __LINE__);
        }
        if (is_null($contextId) || (is_array($contextId) && empty($contextId))) {
            unset($this->ContextId);
        } else {
            $this->ContextId = $contextId;
        }
        return $this;
    }
    /**
     * Get HitCategoryContains value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getHitCategoryContains()
    {
        return isset($this->HitCategoryContains) ? $this->HitCategoryContains : null;
    }
    /**
     * Set HitCategoryContains value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $hitCategoryContains
     * @return \patest\StructType\TraceFilterItem
     */
    public function setHitCategoryContains(\patest\ArrayType\ArrayOfstring $hitCategoryContains = null)
    {
        if (is_null($hitCategoryContains) || (is_array($hitCategoryContains) && empty($hitCategoryContains))) {
            unset($this->HitCategoryContains);
        } else {
            $this->HitCategoryContains = $hitCategoryContains;
        }
        return $this;
    }
    /**
     * Get IsExcludeExceptionalHits value
     * @return bool|null
     */
    public function getIsExcludeExceptionalHits()
    {
        return $this->IsExcludeExceptionalHits;
    }
    /**
     * Set IsExcludeExceptionalHits value
     * @param bool $isExcludeExceptionalHits
     * @return \patest\StructType\TraceFilterItem
     */
    public function setIsExcludeExceptionalHits($isExcludeExceptionalHits = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExcludeExceptionalHits) && !is_bool($isExcludeExceptionalHits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExcludeExceptionalHits, true), gettype($isExcludeExceptionalHits)), __LINE__);
        }
        $this->IsExcludeExceptionalHits = $isExcludeExceptionalHits;
        return $this;
    }
    /**
     * Get IsExcludeFailedHits value
     * @return bool|null
     */
    public function getIsExcludeFailedHits()
    {
        return $this->IsExcludeFailedHits;
    }
    /**
     * Set IsExcludeFailedHits value
     * @param bool $isExcludeFailedHits
     * @return \patest\StructType\TraceFilterItem
     */
    public function setIsExcludeFailedHits($isExcludeFailedHits = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExcludeFailedHits) && !is_bool($isExcludeFailedHits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExcludeFailedHits, true), gettype($isExcludeFailedHits)), __LINE__);
        }
        $this->IsExcludeFailedHits = $isExcludeFailedHits;
        return $this;
    }
    /**
     * Get IsExcludeHitsWithErrors value
     * @return bool|null
     */
    public function getIsExcludeHitsWithErrors()
    {
        return $this->IsExcludeHitsWithErrors;
    }
    /**
     * Set IsExcludeHitsWithErrors value
     * @param bool $isExcludeHitsWithErrors
     * @return \patest\StructType\TraceFilterItem
     */
    public function setIsExcludeHitsWithErrors($isExcludeHitsWithErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExcludeHitsWithErrors) && !is_bool($isExcludeHitsWithErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExcludeHitsWithErrors, true), gettype($isExcludeHitsWithErrors)), __LINE__);
        }
        $this->IsExcludeHitsWithErrors = $isExcludeHitsWithErrors;
        return $this;
    }
    /**
     * Get IsExcludeOtherHits value
     * @return bool|null
     */
    public function getIsExcludeOtherHits()
    {
        return $this->IsExcludeOtherHits;
    }
    /**
     * Set IsExcludeOtherHits value
     * @param bool $isExcludeOtherHits
     * @return \patest\StructType\TraceFilterItem
     */
    public function setIsExcludeOtherHits($isExcludeOtherHits = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExcludeOtherHits) && !is_bool($isExcludeOtherHits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExcludeOtherHits, true), gettype($isExcludeOtherHits)), __LINE__);
        }
        $this->IsExcludeOtherHits = $isExcludeOtherHits;
        return $this;
    }
    /**
     * Get IsExcludeSuspiciousHits value
     * @return bool|null
     */
    public function getIsExcludeSuspiciousHits()
    {
        return $this->IsExcludeSuspiciousHits;
    }
    /**
     * Set IsExcludeSuspiciousHits value
     * @param bool $isExcludeSuspiciousHits
     * @return \patest\StructType\TraceFilterItem
     */
    public function setIsExcludeSuspiciousHits($isExcludeSuspiciousHits = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExcludeSuspiciousHits) && !is_bool($isExcludeSuspiciousHits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExcludeSuspiciousHits, true), gettype($isExcludeSuspiciousHits)), __LINE__);
        }
        $this->IsExcludeSuspiciousHits = $isExcludeSuspiciousHits;
        return $this;
    }
    /**
     * Get IsIncludeNonApiHits value
     * @return bool|null
     */
    public function getIsIncludeNonApiHits()
    {
        return $this->IsIncludeNonApiHits;
    }
    /**
     * Set IsIncludeNonApiHits value
     * @param bool $isIncludeNonApiHits
     * @return \patest\StructType\TraceFilterItem
     */
    public function setIsIncludeNonApiHits($isIncludeNonApiHits = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncludeNonApiHits) && !is_bool($isIncludeNonApiHits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncludeNonApiHits, true), gettype($isIncludeNonApiHits)), __LINE__);
        }
        $this->IsIncludeNonApiHits = $isIncludeNonApiHits;
        return $this;
    }
    /**
     * Get ItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemName()
    {
        return isset($this->ItemName) ? $this->ItemName : null;
    }
    /**
     * Set ItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemName
     * @return \patest\StructType\TraceFilterItem
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        if (is_null($itemName) || (is_array($itemName) && empty($itemName))) {
            unset($this->ItemName);
        } else {
            $this->ItemName = $itemName;
        }
        return $this;
    }
    /**
     * Get MinCpuTime value
     * @return int|null
     */
    public function getMinCpuTime()
    {
        return $this->MinCpuTime;
    }
    /**
     * Set MinCpuTime value
     * @param int $minCpuTime
     * @return \patest\StructType\TraceFilterItem
     */
    public function setMinCpuTime($minCpuTime = null)
    {
        // validation for constraint: int
        if (!is_null($minCpuTime) && !(is_int($minCpuTime) || ctype_digit($minCpuTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minCpuTime, true), gettype($minCpuTime)), __LINE__);
        }
        $this->MinCpuTime = $minCpuTime;
        return $this;
    }
    /**
     * Get MinDbTime value
     * @return int|null
     */
    public function getMinDbTime()
    {
        return $this->MinDbTime;
    }
    /**
     * Set MinDbTime value
     * @param int $minDbTime
     * @return \patest\StructType\TraceFilterItem
     */
    public function setMinDbTime($minDbTime = null)
    {
        // validation for constraint: int
        if (!is_null($minDbTime) && !(is_int($minDbTime) || ctype_digit($minDbTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minDbTime, true), gettype($minDbTime)), __LINE__);
        }
        $this->MinDbTime = $minDbTime;
        return $this;
    }
    /**
     * Get MinDuration value
     * @return int|null
     */
    public function getMinDuration()
    {
        return $this->MinDuration;
    }
    /**
     * Set MinDuration value
     * @param int $minDuration
     * @return \patest\StructType\TraceFilterItem
     */
    public function setMinDuration($minDuration = null)
    {
        // validation for constraint: int
        if (!is_null($minDuration) && !(is_int($minDuration) || ctype_digit($minDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minDuration, true), gettype($minDuration)), __LINE__);
        }
        $this->MinDuration = $minDuration;
        return $this;
    }
}
