<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.UpdateSeatAttributes.Criteria StructType
 * @subpackage Structs
 */
class Ticketing_UpdateSeatAttributes_Criteria extends AnyEntity
{
    /**
     * The DaysOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DaysOfWeek;
    /**
     * The EventType1Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType1Id;
    /**
     * The EventType2Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType2Id;
    /**
     * The EventType3Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType3Id;
    /**
     * The EventType4Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType4Id;
    /**
     * The EventType5Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType5Id;
    /**
     * The EventTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventTypeId;
    /**
     * The FromEventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromEventDate;
    /**
     * The FromEventTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromEventTime;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The IsExceptForDaysOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExceptForDaysOfWeek;
    /**
     * The SaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $SaleStatus;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The ToEventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToEventDate;
    /**
     * The ToEventTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToEventTime;
    /**
     * Constructor method for Ticketing.UpdateSeatAttributes.Criteria
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setDaysOfWeek()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setEventType1Id()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setEventType2Id()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setEventType3Id()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setEventType4Id()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setEventType5Id()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setEventTypeId()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setFromEventDate()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setFromEventTime()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setHallId()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setIsExceptForDaysOfWeek()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setSaleStatus()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setShowId()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setToEventDate()
     * @uses Ticketing_UpdateSeatAttributes_Criteria::setToEventTime()
     * @param string $daysOfWeek
     * @param string $eventType1Id
     * @param string $eventType2Id
     * @param string $eventType3Id
     * @param string $eventType4Id
     * @param string $eventType5Id
     * @param string $eventTypeId
     * @param string $fromEventDate
     * @param string $fromEventTime
     * @param string $hallId
     * @param bool $isExceptForDaysOfWeek
     * @param string[] $saleStatus
     * @param string $showId
     * @param string $toEventDate
     * @param string $toEventTime
     */
    public function __construct($daysOfWeek = null, $eventType1Id = null, $eventType2Id = null, $eventType3Id = null, $eventType4Id = null, $eventType5Id = null, $eventTypeId = null, $fromEventDate = null, $fromEventTime = null, $hallId = null, $isExceptForDaysOfWeek = null, array $saleStatus = array(), $showId = null, $toEventDate = null, $toEventTime = null)
    {
        $this
            ->setDaysOfWeek($daysOfWeek)
            ->setEventType1Id($eventType1Id)
            ->setEventType2Id($eventType2Id)
            ->setEventType3Id($eventType3Id)
            ->setEventType4Id($eventType4Id)
            ->setEventType5Id($eventType5Id)
            ->setEventTypeId($eventTypeId)
            ->setFromEventDate($fromEventDate)
            ->setFromEventTime($fromEventTime)
            ->setHallId($hallId)
            ->setIsExceptForDaysOfWeek($isExceptForDaysOfWeek)
            ->setSaleStatus($saleStatus)
            ->setShowId($showId)
            ->setToEventDate($toEventDate)
            ->setToEventTime($toEventTime);
    }
    /**
     * Get DaysOfWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDaysOfWeek()
    {
        return isset($this->DaysOfWeek) ? $this->DaysOfWeek : null;
    }
    /**
     * Set DaysOfWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $daysOfWeek
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setDaysOfWeek($daysOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($daysOfWeek) && !is_string($daysOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($daysOfWeek, true), gettype($daysOfWeek)), __LINE__);
        }
        if (is_null($daysOfWeek) || (is_array($daysOfWeek) && empty($daysOfWeek))) {
            unset($this->DaysOfWeek);
        } else {
            $this->DaysOfWeek = $daysOfWeek;
        }
        return $this;
    }
    /**
     * Get EventType1Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType1Id()
    {
        return isset($this->EventType1Id) ? $this->EventType1Id : null;
    }
    /**
     * Set EventType1Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType1Id
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setEventType1Id($eventType1Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType1Id) && !is_string($eventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType1Id, true), gettype($eventType1Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType1Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType1Id, true)), __LINE__);
        }
        if (is_null($eventType1Id) || (is_array($eventType1Id) && empty($eventType1Id))) {
            unset($this->EventType1Id);
        } else {
            $this->EventType1Id = $eventType1Id;
        }
        return $this;
    }
    /**
     * Get EventType2Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType2Id()
    {
        return isset($this->EventType2Id) ? $this->EventType2Id : null;
    }
    /**
     * Set EventType2Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType2Id
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setEventType2Id($eventType2Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType2Id) && !is_string($eventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType2Id, true), gettype($eventType2Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType2Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType2Id, true)), __LINE__);
        }
        if (is_null($eventType2Id) || (is_array($eventType2Id) && empty($eventType2Id))) {
            unset($this->EventType2Id);
        } else {
            $this->EventType2Id = $eventType2Id;
        }
        return $this;
    }
    /**
     * Get EventType3Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType3Id()
    {
        return isset($this->EventType3Id) ? $this->EventType3Id : null;
    }
    /**
     * Set EventType3Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType3Id
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setEventType3Id($eventType3Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType3Id) && !is_string($eventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType3Id, true), gettype($eventType3Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType3Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType3Id, true)), __LINE__);
        }
        if (is_null($eventType3Id) || (is_array($eventType3Id) && empty($eventType3Id))) {
            unset($this->EventType3Id);
        } else {
            $this->EventType3Id = $eventType3Id;
        }
        return $this;
    }
    /**
     * Get EventType4Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType4Id()
    {
        return isset($this->EventType4Id) ? $this->EventType4Id : null;
    }
    /**
     * Set EventType4Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType4Id
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setEventType4Id($eventType4Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType4Id) && !is_string($eventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType4Id, true), gettype($eventType4Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType4Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType4Id, true)), __LINE__);
        }
        if (is_null($eventType4Id) || (is_array($eventType4Id) && empty($eventType4Id))) {
            unset($this->EventType4Id);
        } else {
            $this->EventType4Id = $eventType4Id;
        }
        return $this;
    }
    /**
     * Get EventType5Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType5Id()
    {
        return isset($this->EventType5Id) ? $this->EventType5Id : null;
    }
    /**
     * Set EventType5Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType5Id
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setEventType5Id($eventType5Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType5Id) && !is_string($eventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType5Id, true), gettype($eventType5Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType5Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType5Id, true)), __LINE__);
        }
        if (is_null($eventType5Id) || (is_array($eventType5Id) && empty($eventType5Id))) {
            unset($this->EventType5Id);
        } else {
            $this->EventType5Id = $eventType5Id;
        }
        return $this;
    }
    /**
     * Get EventTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTypeId()
    {
        return isset($this->EventTypeId) ? $this->EventTypeId : null;
    }
    /**
     * Set EventTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTypeId
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setEventTypeId($eventTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($eventTypeId) && !is_string($eventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTypeId, true), gettype($eventTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventTypeId, true)), __LINE__);
        }
        if (is_null($eventTypeId) || (is_array($eventTypeId) && empty($eventTypeId))) {
            unset($this->EventTypeId);
        } else {
            $this->EventTypeId = $eventTypeId;
        }
        return $this;
    }
    /**
     * Get FromEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromEventDate()
    {
        return isset($this->FromEventDate) ? $this->FromEventDate : null;
    }
    /**
     * Set FromEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromEventDate
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setFromEventDate($fromEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromEventDate) && !is_string($fromEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEventDate, true), gettype($fromEventDate)), __LINE__);
        }
        if (is_null($fromEventDate) || (is_array($fromEventDate) && empty($fromEventDate))) {
            unset($this->FromEventDate);
        } else {
            $this->FromEventDate = $fromEventDate;
        }
        return $this;
    }
    /**
     * Get FromEventTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromEventTime()
    {
        return isset($this->FromEventTime) ? $this->FromEventTime : null;
    }
    /**
     * Set FromEventTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromEventTime
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setFromEventTime($fromEventTime = null)
    {
        // validation for constraint: string
        if (!is_null($fromEventTime) && !is_string($fromEventTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEventTime, true), gettype($fromEventTime)), __LINE__);
        }
        if (is_null($fromEventTime) || (is_array($fromEventTime) && empty($fromEventTime))) {
            unset($this->FromEventTime);
        } else {
            $this->FromEventTime = $fromEventTime;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get IsExceptForDaysOfWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExceptForDaysOfWeek()
    {
        return isset($this->IsExceptForDaysOfWeek) ? $this->IsExceptForDaysOfWeek : null;
    }
    /**
     * Set IsExceptForDaysOfWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExceptForDaysOfWeek
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setIsExceptForDaysOfWeek($isExceptForDaysOfWeek = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExceptForDaysOfWeek) && !is_bool($isExceptForDaysOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExceptForDaysOfWeek, true), gettype($isExceptForDaysOfWeek)), __LINE__);
        }
        if (is_null($isExceptForDaysOfWeek) || (is_array($isExceptForDaysOfWeek) && empty($isExceptForDaysOfWeek))) {
            unset($this->IsExceptForDaysOfWeek);
        } else {
            $this->IsExceptForDaysOfWeek = $isExceptForDaysOfWeek;
        }
        return $this;
    }
    /**
     * Get SaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSaleStatus()
    {
        return isset($this->SaleStatus) ? $this->SaleStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSaleStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSaleStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaleStatusForArrayConstraintsFromSetSaleStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketing_UpdateSeatAttributes_CriteriaSaleStatusItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EventSaleStatus::valueIsValid($ticketing_UpdateSeatAttributes_CriteriaSaleStatusItem)) {
                $invalidValues[] = is_object($ticketing_UpdateSeatAttributes_CriteriaSaleStatusItem) ? get_class($ticketing_UpdateSeatAttributes_CriteriaSaleStatusItem) : sprintf('%s(%s)', gettype($ticketing_UpdateSeatAttributes_CriteriaSaleStatusItem), var_export($ticketing_UpdateSeatAttributes_CriteriaSaleStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventSaleStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EventSaleStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventSaleStatus::valueIsValid()
     * @uses \patest\EnumType\EventSaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $saleStatus
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setSaleStatus(array $saleStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($saleStatusArrayErrorMessage = self::validateSaleStatusForArrayConstraintsFromSetSaleStatus($saleStatus))) {
            throw new \InvalidArgumentException($saleStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($saleStatus) || (is_array($saleStatus) && empty($saleStatus))) {
            unset($this->SaleStatus);
        } else {
            $this->SaleStatus = is_array($saleStatus) ? implode(' ', $saleStatus) : null;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get ToEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToEventDate()
    {
        return isset($this->ToEventDate) ? $this->ToEventDate : null;
    }
    /**
     * Set ToEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toEventDate
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setToEventDate($toEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($toEventDate) && !is_string($toEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toEventDate, true), gettype($toEventDate)), __LINE__);
        }
        if (is_null($toEventDate) || (is_array($toEventDate) && empty($toEventDate))) {
            unset($this->ToEventDate);
        } else {
            $this->ToEventDate = $toEventDate;
        }
        return $this;
    }
    /**
     * Get ToEventTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToEventTime()
    {
        return isset($this->ToEventTime) ? $this->ToEventTime : null;
    }
    /**
     * Set ToEventTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toEventTime
     * @return \patest\StructType\Ticketing_UpdateSeatAttributes_Criteria
     */
    public function setToEventTime($toEventTime = null)
    {
        // validation for constraint: string
        if (!is_null($toEventTime) && !is_string($toEventTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toEventTime, true), gettype($toEventTime)), __LINE__);
        }
        if (is_null($toEventTime) || (is_array($toEventTime) && empty($toEventTime))) {
            unset($this->ToEventTime);
        } else {
            $this->ToEventTime = $toEventTime;
        }
        return $this;
    }
}
