<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TravelGroupTicketAllotmentRow StructType
 * @subpackage Structs
 */
class Ticketing_TravelGroupTicketAllotmentRow extends AnyEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The Row
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Row;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for Ticketing.TravelGroupTicketAllotmentRow
     * @uses Ticketing_TravelGroupTicketAllotmentRow::setAreaId()
     * @uses Ticketing_TravelGroupTicketAllotmentRow::setAreaName()
     * @uses Ticketing_TravelGroupTicketAllotmentRow::setClientId()
     * @uses Ticketing_TravelGroupTicketAllotmentRow::setCrmId()
     * @uses Ticketing_TravelGroupTicketAllotmentRow::setEventId()
     * @uses Ticketing_TravelGroupTicketAllotmentRow::setOwnerName()
     * @uses Ticketing_TravelGroupTicketAllotmentRow::setPriceTypeName()
     * @uses Ticketing_TravelGroupTicketAllotmentRow::setRow()
     * @uses Ticketing_TravelGroupTicketAllotmentRow::setSeat()
     * @uses Ticketing_TravelGroupTicketAllotmentRow::setTicketId()
     * @param string $areaId
     * @param string $areaName
     * @param string $clientId
     * @param string $crmId
     * @param string $eventId
     * @param string $ownerName
     * @param string $priceTypeName
     * @param string $row
     * @param string $seat
     * @param string $ticketId
     */
    public function __construct($areaId = null, $areaName = null, $clientId = null, $crmId = null, $eventId = null, $ownerName = null, $priceTypeName = null, $row = null, $seat = null, $ticketId = null)
    {
        $this
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setClientId($clientId)
            ->setCrmId($crmId)
            ->setEventId($eventId)
            ->setOwnerName($ownerName)
            ->setPriceTypeName($priceTypeName)
            ->setRow($row)
            ->setSeat($seat)
            ->setTicketId($ticketId);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_TravelGroupTicketAllotmentRow
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Ticketing_TravelGroupTicketAllotmentRow
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_TravelGroupTicketAllotmentRow
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Ticketing_TravelGroupTicketAllotmentRow
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_TravelGroupTicketAllotmentRow
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\Ticketing_TravelGroupTicketAllotmentRow
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\Ticketing_TravelGroupTicketAllotmentRow
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get Row value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRow()
    {
        return isset($this->Row) ? $this->Row : null;
    }
    /**
     * Set Row value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $row
     * @return \patest\StructType\Ticketing_TravelGroupTicketAllotmentRow
     */
    public function setRow($row = null)
    {
        // validation for constraint: string
        if (!is_null($row) && !is_string($row)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($row, true), gettype($row)), __LINE__);
        }
        if (is_null($row) || (is_array($row) && empty($row))) {
            unset($this->Row);
        } else {
            $this->Row = $row;
        }
        return $this;
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seat
     * @return \patest\StructType\Ticketing_TravelGroupTicketAllotmentRow
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\Ticketing_TravelGroupTicketAllotmentRow
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
}
