<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketVersion StructType
 * @subpackage Structs
 */
class Ticketing_TicketVersion extends DistributableEntity
{
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The CreationReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationReason;
    /**
     * The IsForResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForResale;
    /**
     * The IsPrinting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinting;
    /**
     * The LastStatusDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastStatusDate;
    /**
     * The LastTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastTransactionGuid;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The OriginatorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginatorId;
    /**
     * The OwnerClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerClientId;
    /**
     * The PreviousVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PreviousVersionId;
    /**
     * The PricingVariationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PricingVariationId;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for Ticketing.TicketVersion
     * @uses Ticketing_TicketVersion::setCreationDate()
     * @uses Ticketing_TicketVersion::setCreationReason()
     * @uses Ticketing_TicketVersion::setIsForResale()
     * @uses Ticketing_TicketVersion::setIsPrinting()
     * @uses Ticketing_TicketVersion::setLastStatusDate()
     * @uses Ticketing_TicketVersion::setLastTransactionGuid()
     * @uses Ticketing_TicketVersion::setNotes()
     * @uses Ticketing_TicketVersion::setOriginatorId()
     * @uses Ticketing_TicketVersion::setOwnerClientId()
     * @uses Ticketing_TicketVersion::setPreviousVersionId()
     * @uses Ticketing_TicketVersion::setPricingVariationId()
     * @uses Ticketing_TicketVersion::setPrintCount()
     * @uses Ticketing_TicketVersion::setStatus()
     * @uses Ticketing_TicketVersion::setTicketId()
     * @param string $creationDate
     * @param string $creationReason
     * @param bool $isForResale
     * @param bool $isPrinting
     * @param string $lastStatusDate
     * @param string $lastTransactionGuid
     * @param string $notes
     * @param string $originatorId
     * @param string $ownerClientId
     * @param string $previousVersionId
     * @param int $pricingVariationId
     * @param int $printCount
     * @param string $status
     * @param string $ticketId
     */
    public function __construct($creationDate = null, $creationReason = null, $isForResale = null, $isPrinting = null, $lastStatusDate = null, $lastTransactionGuid = null, $notes = null, $originatorId = null, $ownerClientId = null, $previousVersionId = null, $pricingVariationId = null, $printCount = null, $status = null, $ticketId = null)
    {
        $this
            ->setCreationDate($creationDate)
            ->setCreationReason($creationReason)
            ->setIsForResale($isForResale)
            ->setIsPrinting($isPrinting)
            ->setLastStatusDate($lastStatusDate)
            ->setLastTransactionGuid($lastTransactionGuid)
            ->setNotes($notes)
            ->setOriginatorId($originatorId)
            ->setOwnerClientId($ownerClientId)
            ->setPreviousVersionId($previousVersionId)
            ->setPricingVariationId($pricingVariationId)
            ->setPrintCount($printCount)
            ->setStatus($status)
            ->setTicketId($ticketId);
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get CreationReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationReason()
    {
        return isset($this->CreationReason) ? $this->CreationReason : null;
    }
    /**
     * Set CreationReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationReason
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setCreationReason($creationReason = null)
    {
        // validation for constraint: string
        if (!is_null($creationReason) && !is_string($creationReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationReason, true), gettype($creationReason)), __LINE__);
        }
        if (is_null($creationReason) || (is_array($creationReason) && empty($creationReason))) {
            unset($this->CreationReason);
        } else {
            $this->CreationReason = $creationReason;
        }
        return $this;
    }
    /**
     * Get IsForResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForResale()
    {
        return isset($this->IsForResale) ? $this->IsForResale : null;
    }
    /**
     * Set IsForResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForResale
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setIsForResale($isForResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForResale) && !is_bool($isForResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForResale, true), gettype($isForResale)), __LINE__);
        }
        if (is_null($isForResale) || (is_array($isForResale) && empty($isForResale))) {
            unset($this->IsForResale);
        } else {
            $this->IsForResale = $isForResale;
        }
        return $this;
    }
    /**
     * Get IsPrinting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinting()
    {
        return isset($this->IsPrinting) ? $this->IsPrinting : null;
    }
    /**
     * Set IsPrinting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinting
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setIsPrinting($isPrinting = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinting) && !is_bool($isPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinting, true), gettype($isPrinting)), __LINE__);
        }
        if (is_null($isPrinting) || (is_array($isPrinting) && empty($isPrinting))) {
            unset($this->IsPrinting);
        } else {
            $this->IsPrinting = $isPrinting;
        }
        return $this;
    }
    /**
     * Get LastStatusDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastStatusDate()
    {
        return isset($this->LastStatusDate) ? $this->LastStatusDate : null;
    }
    /**
     * Set LastStatusDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastStatusDate
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setLastStatusDate($lastStatusDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastStatusDate) && !is_string($lastStatusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastStatusDate, true), gettype($lastStatusDate)), __LINE__);
        }
        if (is_null($lastStatusDate) || (is_array($lastStatusDate) && empty($lastStatusDate))) {
            unset($this->LastStatusDate);
        } else {
            $this->LastStatusDate = $lastStatusDate;
        }
        return $this;
    }
    /**
     * Get LastTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastTransactionGuid()
    {
        return isset($this->LastTransactionGuid) ? $this->LastTransactionGuid : null;
    }
    /**
     * Set LastTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastTransactionGuid
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setLastTransactionGuid($lastTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($lastTransactionGuid) && !is_string($lastTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastTransactionGuid, true), gettype($lastTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastTransactionGuid, true)), __LINE__);
        }
        if (is_null($lastTransactionGuid) || (is_array($lastTransactionGuid) && empty($lastTransactionGuid))) {
            unset($this->LastTransactionGuid);
        } else {
            $this->LastTransactionGuid = $lastTransactionGuid;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get OriginatorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginatorId()
    {
        return isset($this->OriginatorId) ? $this->OriginatorId : null;
    }
    /**
     * Set OriginatorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originatorId
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setOriginatorId($originatorId = null)
    {
        // validation for constraint: string
        if (!is_null($originatorId) && !is_string($originatorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originatorId, true), gettype($originatorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originatorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originatorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originatorId, true)), __LINE__);
        }
        if (is_null($originatorId) || (is_array($originatorId) && empty($originatorId))) {
            unset($this->OriginatorId);
        } else {
            $this->OriginatorId = $originatorId;
        }
        return $this;
    }
    /**
     * Get OwnerClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerClientId()
    {
        return isset($this->OwnerClientId) ? $this->OwnerClientId : null;
    }
    /**
     * Set OwnerClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerClientId
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setOwnerClientId($ownerClientId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerClientId) && !is_string($ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerClientId, true), gettype($ownerClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerClientId, true)), __LINE__);
        }
        if (is_null($ownerClientId) || (is_array($ownerClientId) && empty($ownerClientId))) {
            unset($this->OwnerClientId);
        } else {
            $this->OwnerClientId = $ownerClientId;
        }
        return $this;
    }
    /**
     * Get PreviousVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviousVersionId()
    {
        return isset($this->PreviousVersionId) ? $this->PreviousVersionId : null;
    }
    /**
     * Set PreviousVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previousVersionId
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setPreviousVersionId($previousVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($previousVersionId) && !is_string($previousVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousVersionId, true), gettype($previousVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($previousVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $previousVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($previousVersionId, true)), __LINE__);
        }
        if (is_null($previousVersionId) || (is_array($previousVersionId) && empty($previousVersionId))) {
            unset($this->PreviousVersionId);
        } else {
            $this->PreviousVersionId = $previousVersionId;
        }
        return $this;
    }
    /**
     * Get PricingVariationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPricingVariationId()
    {
        return isset($this->PricingVariationId) ? $this->PricingVariationId : null;
    }
    /**
     * Set PricingVariationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pricingVariationId
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setPricingVariationId($pricingVariationId = null)
    {
        // validation for constraint: int
        if (!is_null($pricingVariationId) && !(is_int($pricingVariationId) || ctype_digit($pricingVariationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingVariationId, true), gettype($pricingVariationId)), __LINE__);
        }
        if (is_null($pricingVariationId) || (is_array($pricingVariationId) && empty($pricingVariationId))) {
            unset($this->PricingVariationId);
        } else {
            $this->PricingVariationId = $pricingVariationId;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketVersionStatus::valueIsValid()
     * @uses \patest\EnumType\TicketVersionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketVersionStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketVersionStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\TicketVersionStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\Ticketing_TicketVersion
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
}
