<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketInAction StructType
 * @subpackage Structs
 */
class Ticketing_TicketInAction extends Ticketing_TicketWithVersions
{
    /**
     * The DisplayedTicketNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DisplayedTicketNumber;
    /**
     * The IsSelected
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSelected;
    /**
     * Constructor method for Ticketing.TicketInAction
     * @uses Ticketing_TicketInAction::setDisplayedTicketNumber()
     * @uses Ticketing_TicketInAction::setIsSelected()
     * @param int $displayedTicketNumber
     * @param bool $isSelected
     */
    public function __construct($displayedTicketNumber = null, $isSelected = null)
    {
        $this
            ->setDisplayedTicketNumber($displayedTicketNumber)
            ->setIsSelected($isSelected);
    }
    /**
     * Get DisplayedTicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDisplayedTicketNumber()
    {
        return isset($this->DisplayedTicketNumber) ? $this->DisplayedTicketNumber : null;
    }
    /**
     * Set DisplayedTicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $displayedTicketNumber
     * @return \patest\StructType\Ticketing_TicketInAction
     */
    public function setDisplayedTicketNumber($displayedTicketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($displayedTicketNumber) && !(is_int($displayedTicketNumber) || ctype_digit($displayedTicketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayedTicketNumber, true), gettype($displayedTicketNumber)), __LINE__);
        }
        if (is_null($displayedTicketNumber) || (is_array($displayedTicketNumber) && empty($displayedTicketNumber))) {
            unset($this->DisplayedTicketNumber);
        } else {
            $this->DisplayedTicketNumber = $displayedTicketNumber;
        }
        return $this;
    }
    /**
     * Get IsSelected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSelected()
    {
        return isset($this->IsSelected) ? $this->IsSelected : null;
    }
    /**
     * Set IsSelected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSelected
     * @return \patest\StructType\Ticketing_TicketInAction
     */
    public function setIsSelected($isSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelected) && !is_bool($isSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelected, true), gettype($isSelected)), __LINE__);
        }
        if (is_null($isSelected) || (is_array($isSelected) && empty($isSelected))) {
            unset($this->IsSelected);
        } else {
            $this->IsSelected = $isSelected;
        }
        return $this;
    }
}
