<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketDistributionJournal StructType
 * @subpackage Structs
 */
class Ticketing_TicketDistributionJournal extends PersistableEntity
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentType;
    /**
     * The DocumentTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DocumentTypeName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The OriginalAccessCardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalAccessCardId;
    /**
     * The OriginalBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalBarcode;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for Ticketing.TicketDistributionJournal
     * @uses Ticketing_TicketDistributionJournal::setAction()
     * @uses Ticketing_TicketDistributionJournal::setCreationDate()
     * @uses Ticketing_TicketDistributionJournal::setDocumentType()
     * @uses Ticketing_TicketDistributionJournal::setDocumentTypeName()
     * @uses Ticketing_TicketDistributionJournal::setEmail()
     * @uses Ticketing_TicketDistributionJournal::setFirstName()
     * @uses Ticketing_TicketDistributionJournal::setLastName()
     * @uses Ticketing_TicketDistributionJournal::setOriginalAccessCardId()
     * @uses Ticketing_TicketDistributionJournal::setOriginalBarcode()
     * @uses Ticketing_TicketDistributionJournal::setStatus()
     * @uses Ticketing_TicketDistributionJournal::setTicketId()
     * @param string $action
     * @param string $creationDate
     * @param string $documentType
     * @param \patest\StructType\GlobalString $documentTypeName
     * @param string $email
     * @param string $firstName
     * @param string $lastName
     * @param string $originalAccessCardId
     * @param string $originalBarcode
     * @param string $status
     * @param string $ticketId
     */
    public function __construct($action = null, $creationDate = null, $documentType = null, \patest\StructType\GlobalString $documentTypeName = null, $email = null, $firstName = null, $lastName = null, $originalAccessCardId = null, $originalBarcode = null, $status = null, $ticketId = null)
    {
        $this
            ->setAction($action)
            ->setCreationDate($creationDate)
            ->setDocumentType($documentType)
            ->setDocumentTypeName($documentTypeName)
            ->setEmail($email)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setOriginalAccessCardId($originalAccessCardId)
            ->setOriginalBarcode($originalBarcode)
            ->setStatus($status)
            ->setTicketId($ticketId);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketDistributionAction::valueIsValid()
     * @uses \patest\EnumType\TicketDistributionAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketDistributionAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketDistributionAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\TicketDistributionAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get DocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentType()
    {
        return isset($this->DocumentType) ? $this->DocumentType : null;
    }
    /**
     * Set DocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentType
     * @return \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        if (is_null($documentType) || (is_array($documentType) && empty($documentType))) {
            unset($this->DocumentType);
        } else {
            $this->DocumentType = $documentType;
        }
        return $this;
    }
    /**
     * Get DocumentTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDocumentTypeName()
    {
        return isset($this->DocumentTypeName) ? $this->DocumentTypeName : null;
    }
    /**
     * Set DocumentTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $documentTypeName
     * @return \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public function setDocumentTypeName(\patest\StructType\GlobalString $documentTypeName = null)
    {
        if (is_null($documentTypeName) || (is_array($documentTypeName) && empty($documentTypeName))) {
            unset($this->DocumentTypeName);
        } else {
            $this->DocumentTypeName = $documentTypeName;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get OriginalAccessCardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalAccessCardId()
    {
        return isset($this->OriginalAccessCardId) ? $this->OriginalAccessCardId : null;
    }
    /**
     * Set OriginalAccessCardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalAccessCardId
     * @return \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public function setOriginalAccessCardId($originalAccessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($originalAccessCardId) && !is_string($originalAccessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalAccessCardId, true), gettype($originalAccessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalAccessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalAccessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalAccessCardId, true)), __LINE__);
        }
        if (is_null($originalAccessCardId) || (is_array($originalAccessCardId) && empty($originalAccessCardId))) {
            unset($this->OriginalAccessCardId);
        } else {
            $this->OriginalAccessCardId = $originalAccessCardId;
        }
        return $this;
    }
    /**
     * Get OriginalBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalBarcode()
    {
        return isset($this->OriginalBarcode) ? $this->OriginalBarcode : null;
    }
    /**
     * Set OriginalBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalBarcode
     * @return \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public function setOriginalBarcode($originalBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($originalBarcode) && !is_string($originalBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalBarcode, true), gettype($originalBarcode)), __LINE__);
        }
        if (is_null($originalBarcode) || (is_array($originalBarcode) && empty($originalBarcode))) {
            unset($this->OriginalBarcode);
        } else {
            $this->OriginalBarcode = $originalBarcode;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketDistributionStatus::valueIsValid()
     * @uses \patest\EnumType\TicketDistributionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketDistributionStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketDistributionStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\TicketDistributionStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
}
