<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Taxonomy StructType
 * @subpackage Structs
 */
class Ticketing_Taxonomy extends PersistableEntity
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SgoTaxonomyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SgoTaxonomyId;
    /**
     * Constructor method for Ticketing.Taxonomy
     * @uses Ticketing_Taxonomy::setName()
     * @uses Ticketing_Taxonomy::setSgoTaxonomyId()
     * @param string $name
     * @param int $sgoTaxonomyId
     */
    public function __construct($name = null, $sgoTaxonomyId = null)
    {
        $this
            ->setName($name)
            ->setSgoTaxonomyId($sgoTaxonomyId);
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Ticketing_Taxonomy
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SgoTaxonomyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSgoTaxonomyId()
    {
        return isset($this->SgoTaxonomyId) ? $this->SgoTaxonomyId : null;
    }
    /**
     * Set SgoTaxonomyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sgoTaxonomyId
     * @return \patest\StructType\Ticketing_Taxonomy
     */
    public function setSgoTaxonomyId($sgoTaxonomyId = null)
    {
        // validation for constraint: int
        if (!is_null($sgoTaxonomyId) && !(is_int($sgoTaxonomyId) || ctype_digit($sgoTaxonomyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sgoTaxonomyId, true), gettype($sgoTaxonomyId)), __LINE__);
        }
        if (is_null($sgoTaxonomyId) || (is_array($sgoTaxonomyId) && empty($sgoTaxonomyId))) {
            unset($this->SgoTaxonomyId);
        } else {
            $this->SgoTaxonomyId = $sgoTaxonomyId;
        }
        return $this;
    }
}
