<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SubscriptionProductDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.SubscriptionProductDescription
 * @subpackage Structs
 */
class Ticketing_SubscriptionProductDescription extends AnyEntity
{
    /**
     * The BucketsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_BucketsInfo
     */
    public $BucketsInfo;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The DurationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurationType;
    /**
     * The EventsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_SubscriptionEventInfo
     */
    public $EventsInfo;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The HospitalityMedia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Subscription_Media
     */
    public $HospitalityMedia;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsAssignAllEventsOnSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAssignAllEventsOnSale;
    /**
     * The IsPartialEventBased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPartialEventBased;
    /**
     * The IsPrepaiedWaitingListAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrepaiedWaitingListAllowed;
    /**
     * The IsPricingPerSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPricingPerSeries;
    /**
     * The IsSeriesAllocated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSeriesAllocated;
    /**
     * The IsSeriesGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSeriesGroup;
    /**
     * The IsWaitingListAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsWaitingListAllowed;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Subscription_Media
     */
    public $Media;
    /**
     * The MinQuantityOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinQuantityOfEvents;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NumberOfBonusEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfBonusEvents;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The QuantityOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityOfEvents;
    /**
     * The Seasonality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seasonality;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeasonName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SeasonName;
    /**
     * The SeriesGroupSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_SubscriptionProductDescription
     */
    public $SeriesGroupSeries;
    /**
     * Constructor method for Ticketing.SubscriptionProductDescription
     * @uses Ticketing_SubscriptionProductDescription::setBucketsInfo()
     * @uses Ticketing_SubscriptionProductDescription::setDescription()
     * @uses Ticketing_SubscriptionProductDescription::setDurationType()
     * @uses Ticketing_SubscriptionProductDescription::setEventsInfo()
     * @uses Ticketing_SubscriptionProductDescription::setHallId()
     * @uses Ticketing_SubscriptionProductDescription::setHallName()
     * @uses Ticketing_SubscriptionProductDescription::setHospitalityMedia()
     * @uses Ticketing_SubscriptionProductDescription::setId()
     * @uses Ticketing_SubscriptionProductDescription::setIsAssignAllEventsOnSale()
     * @uses Ticketing_SubscriptionProductDescription::setIsPartialEventBased()
     * @uses Ticketing_SubscriptionProductDescription::setIsPrepaiedWaitingListAllowed()
     * @uses Ticketing_SubscriptionProductDescription::setIsPricingPerSeries()
     * @uses Ticketing_SubscriptionProductDescription::setIsSeriesAllocated()
     * @uses Ticketing_SubscriptionProductDescription::setIsSeriesGroup()
     * @uses Ticketing_SubscriptionProductDescription::setIsWaitingListAllowed()
     * @uses Ticketing_SubscriptionProductDescription::setMedia()
     * @uses Ticketing_SubscriptionProductDescription::setMinQuantityOfEvents()
     * @uses Ticketing_SubscriptionProductDescription::setName()
     * @uses Ticketing_SubscriptionProductDescription::setNumberOfBonusEvents()
     * @uses Ticketing_SubscriptionProductDescription::setOrganizationUnitId()
     * @uses Ticketing_SubscriptionProductDescription::setQuantityOfEvents()
     * @uses Ticketing_SubscriptionProductDescription::setSeasonality()
     * @uses Ticketing_SubscriptionProductDescription::setSeasonId()
     * @uses Ticketing_SubscriptionProductDescription::setSeasonName()
     * @uses Ticketing_SubscriptionProductDescription::setSeriesGroupSeries()
     * @param \patest\StructType\Ticketing_BucketsInfo $bucketsInfo
     * @param \patest\StructType\GlobalString $description
     * @param string $durationType
     * @param \patest\StructType\RecordSetOfTicketing_SubscriptionEventInfo $eventsInfo
     * @param string $hallId
     * @param \patest\StructType\GlobalString $hallName
     * @param \patest\StructType\Subscription_Media $hospitalityMedia
     * @param string $id
     * @param bool $isAssignAllEventsOnSale
     * @param bool $isPartialEventBased
     * @param bool $isPrepaiedWaitingListAllowed
     * @param bool $isPricingPerSeries
     * @param bool $isSeriesAllocated
     * @param bool $isSeriesGroup
     * @param bool $isWaitingListAllowed
     * @param \patest\StructType\Subscription_Media $media
     * @param int $minQuantityOfEvents
     * @param \patest\StructType\GlobalString $name
     * @param int $numberOfBonusEvents
     * @param string $organizationUnitId
     * @param int $quantityOfEvents
     * @param string $seasonality
     * @param string $seasonId
     * @param \patest\StructType\GlobalString $seasonName
     * @param \patest\StructType\RecordSetOfTicketing_SubscriptionProductDescription $seriesGroupSeries
     */
    public function __construct(\patest\StructType\Ticketing_BucketsInfo $bucketsInfo = null, \patest\StructType\GlobalString $description = null, $durationType = null, \patest\StructType\RecordSetOfTicketing_SubscriptionEventInfo $eventsInfo = null, $hallId = null, \patest\StructType\GlobalString $hallName = null, \patest\StructType\Subscription_Media $hospitalityMedia = null, $id = null, $isAssignAllEventsOnSale = null, $isPartialEventBased = null, $isPrepaiedWaitingListAllowed = null, $isPricingPerSeries = null, $isSeriesAllocated = null, $isSeriesGroup = null, $isWaitingListAllowed = null, \patest\StructType\Subscription_Media $media = null, $minQuantityOfEvents = null, \patest\StructType\GlobalString $name = null, $numberOfBonusEvents = null, $organizationUnitId = null, $quantityOfEvents = null, $seasonality = null, $seasonId = null, \patest\StructType\GlobalString $seasonName = null, \patest\StructType\RecordSetOfTicketing_SubscriptionProductDescription $seriesGroupSeries = null)
    {
        $this
            ->setBucketsInfo($bucketsInfo)
            ->setDescription($description)
            ->setDurationType($durationType)
            ->setEventsInfo($eventsInfo)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setHospitalityMedia($hospitalityMedia)
            ->setId($id)
            ->setIsAssignAllEventsOnSale($isAssignAllEventsOnSale)
            ->setIsPartialEventBased($isPartialEventBased)
            ->setIsPrepaiedWaitingListAllowed($isPrepaiedWaitingListAllowed)
            ->setIsPricingPerSeries($isPricingPerSeries)
            ->setIsSeriesAllocated($isSeriesAllocated)
            ->setIsSeriesGroup($isSeriesGroup)
            ->setIsWaitingListAllowed($isWaitingListAllowed)
            ->setMedia($media)
            ->setMinQuantityOfEvents($minQuantityOfEvents)
            ->setName($name)
            ->setNumberOfBonusEvents($numberOfBonusEvents)
            ->setOrganizationUnitId($organizationUnitId)
            ->setQuantityOfEvents($quantityOfEvents)
            ->setSeasonality($seasonality)
            ->setSeasonId($seasonId)
            ->setSeasonName($seasonName)
            ->setSeriesGroupSeries($seriesGroupSeries);
    }
    /**
     * Get BucketsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_BucketsInfo|null
     */
    public function getBucketsInfo()
    {
        return isset($this->BucketsInfo) ? $this->BucketsInfo : null;
    }
    /**
     * Set BucketsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_BucketsInfo $bucketsInfo
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setBucketsInfo(\patest\StructType\Ticketing_BucketsInfo $bucketsInfo = null)
    {
        if (is_null($bucketsInfo) || (is_array($bucketsInfo) && empty($bucketsInfo))) {
            unset($this->BucketsInfo);
        } else {
            $this->BucketsInfo = $bucketsInfo;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DurationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurationType()
    {
        return isset($this->DurationType) ? $this->DurationType : null;
    }
    /**
     * Set DurationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesDurationType::valueIsValid()
     * @uses \patest\EnumType\SeriesDurationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $durationType
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setDurationType($durationType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesDurationType::valueIsValid($durationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesDurationType', is_array($durationType) ? implode(', ', $durationType) : var_export($durationType, true), implode(', ', \patest\EnumType\SeriesDurationType::getValidValues())), __LINE__);
        }
        if (is_null($durationType) || (is_array($durationType) && empty($durationType))) {
            unset($this->DurationType);
        } else {
            $this->DurationType = $durationType;
        }
        return $this;
    }
    /**
     * Get EventsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_SubscriptionEventInfo|null
     */
    public function getEventsInfo()
    {
        return isset($this->EventsInfo) ? $this->EventsInfo : null;
    }
    /**
     * Set EventsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_SubscriptionEventInfo $eventsInfo
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setEventsInfo(\patest\StructType\RecordSetOfTicketing_SubscriptionEventInfo $eventsInfo = null)
    {
        if (is_null($eventsInfo) || (is_array($eventsInfo) && empty($eventsInfo))) {
            unset($this->EventsInfo);
        } else {
            $this->EventsInfo = $eventsInfo;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get HospitalityMedia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Subscription_Media|null
     */
    public function getHospitalityMedia()
    {
        return isset($this->HospitalityMedia) ? $this->HospitalityMedia : null;
    }
    /**
     * Set HospitalityMedia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Subscription_Media $hospitalityMedia
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setHospitalityMedia(\patest\StructType\Subscription_Media $hospitalityMedia = null)
    {
        if (is_null($hospitalityMedia) || (is_array($hospitalityMedia) && empty($hospitalityMedia))) {
            unset($this->HospitalityMedia);
        } else {
            $this->HospitalityMedia = $hospitalityMedia;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsAssignAllEventsOnSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAssignAllEventsOnSale()
    {
        return isset($this->IsAssignAllEventsOnSale) ? $this->IsAssignAllEventsOnSale : null;
    }
    /**
     * Set IsAssignAllEventsOnSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAssignAllEventsOnSale
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setIsAssignAllEventsOnSale($isAssignAllEventsOnSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAssignAllEventsOnSale) && !is_bool($isAssignAllEventsOnSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAssignAllEventsOnSale, true), gettype($isAssignAllEventsOnSale)), __LINE__);
        }
        if (is_null($isAssignAllEventsOnSale) || (is_array($isAssignAllEventsOnSale) && empty($isAssignAllEventsOnSale))) {
            unset($this->IsAssignAllEventsOnSale);
        } else {
            $this->IsAssignAllEventsOnSale = $isAssignAllEventsOnSale;
        }
        return $this;
    }
    /**
     * Get IsPartialEventBased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPartialEventBased()
    {
        return isset($this->IsPartialEventBased) ? $this->IsPartialEventBased : null;
    }
    /**
     * Set IsPartialEventBased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPartialEventBased
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setIsPartialEventBased($isPartialEventBased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartialEventBased) && !is_bool($isPartialEventBased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartialEventBased, true), gettype($isPartialEventBased)), __LINE__);
        }
        if (is_null($isPartialEventBased) || (is_array($isPartialEventBased) && empty($isPartialEventBased))) {
            unset($this->IsPartialEventBased);
        } else {
            $this->IsPartialEventBased = $isPartialEventBased;
        }
        return $this;
    }
    /**
     * Get IsPrepaiedWaitingListAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrepaiedWaitingListAllowed()
    {
        return isset($this->IsPrepaiedWaitingListAllowed) ? $this->IsPrepaiedWaitingListAllowed : null;
    }
    /**
     * Set IsPrepaiedWaitingListAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrepaiedWaitingListAllowed
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setIsPrepaiedWaitingListAllowed($isPrepaiedWaitingListAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrepaiedWaitingListAllowed) && !is_bool($isPrepaiedWaitingListAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrepaiedWaitingListAllowed, true), gettype($isPrepaiedWaitingListAllowed)), __LINE__);
        }
        if (is_null($isPrepaiedWaitingListAllowed) || (is_array($isPrepaiedWaitingListAllowed) && empty($isPrepaiedWaitingListAllowed))) {
            unset($this->IsPrepaiedWaitingListAllowed);
        } else {
            $this->IsPrepaiedWaitingListAllowed = $isPrepaiedWaitingListAllowed;
        }
        return $this;
    }
    /**
     * Get IsPricingPerSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPricingPerSeries()
    {
        return isset($this->IsPricingPerSeries) ? $this->IsPricingPerSeries : null;
    }
    /**
     * Set IsPricingPerSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPricingPerSeries
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setIsPricingPerSeries($isPricingPerSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPricingPerSeries) && !is_bool($isPricingPerSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPricingPerSeries, true), gettype($isPricingPerSeries)), __LINE__);
        }
        if (is_null($isPricingPerSeries) || (is_array($isPricingPerSeries) && empty($isPricingPerSeries))) {
            unset($this->IsPricingPerSeries);
        } else {
            $this->IsPricingPerSeries = $isPricingPerSeries;
        }
        return $this;
    }
    /**
     * Get IsSeriesAllocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSeriesAllocated()
    {
        return isset($this->IsSeriesAllocated) ? $this->IsSeriesAllocated : null;
    }
    /**
     * Set IsSeriesAllocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSeriesAllocated
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setIsSeriesAllocated($isSeriesAllocated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeriesAllocated) && !is_bool($isSeriesAllocated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSeriesAllocated, true), gettype($isSeriesAllocated)), __LINE__);
        }
        if (is_null($isSeriesAllocated) || (is_array($isSeriesAllocated) && empty($isSeriesAllocated))) {
            unset($this->IsSeriesAllocated);
        } else {
            $this->IsSeriesAllocated = $isSeriesAllocated;
        }
        return $this;
    }
    /**
     * Get IsSeriesGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSeriesGroup()
    {
        return isset($this->IsSeriesGroup) ? $this->IsSeriesGroup : null;
    }
    /**
     * Set IsSeriesGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSeriesGroup
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setIsSeriesGroup($isSeriesGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeriesGroup) && !is_bool($isSeriesGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSeriesGroup, true), gettype($isSeriesGroup)), __LINE__);
        }
        if (is_null($isSeriesGroup) || (is_array($isSeriesGroup) && empty($isSeriesGroup))) {
            unset($this->IsSeriesGroup);
        } else {
            $this->IsSeriesGroup = $isSeriesGroup;
        }
        return $this;
    }
    /**
     * Get IsWaitingListAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsWaitingListAllowed()
    {
        return isset($this->IsWaitingListAllowed) ? $this->IsWaitingListAllowed : null;
    }
    /**
     * Set IsWaitingListAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isWaitingListAllowed
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setIsWaitingListAllowed($isWaitingListAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWaitingListAllowed) && !is_bool($isWaitingListAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWaitingListAllowed, true), gettype($isWaitingListAllowed)), __LINE__);
        }
        if (is_null($isWaitingListAllowed) || (is_array($isWaitingListAllowed) && empty($isWaitingListAllowed))) {
            unset($this->IsWaitingListAllowed);
        } else {
            $this->IsWaitingListAllowed = $isWaitingListAllowed;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Subscription_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Subscription_Media $media
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setMedia(\patest\StructType\Subscription_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get MinQuantityOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinQuantityOfEvents()
    {
        return isset($this->MinQuantityOfEvents) ? $this->MinQuantityOfEvents : null;
    }
    /**
     * Set MinQuantityOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minQuantityOfEvents
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setMinQuantityOfEvents($minQuantityOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($minQuantityOfEvents) && !(is_int($minQuantityOfEvents) || ctype_digit($minQuantityOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minQuantityOfEvents, true), gettype($minQuantityOfEvents)), __LINE__);
        }
        if (is_null($minQuantityOfEvents) || (is_array($minQuantityOfEvents) && empty($minQuantityOfEvents))) {
            unset($this->MinQuantityOfEvents);
        } else {
            $this->MinQuantityOfEvents = $minQuantityOfEvents;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumberOfBonusEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfBonusEvents()
    {
        return isset($this->NumberOfBonusEvents) ? $this->NumberOfBonusEvents : null;
    }
    /**
     * Set NumberOfBonusEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfBonusEvents
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setNumberOfBonusEvents($numberOfBonusEvents = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBonusEvents) && !(is_int($numberOfBonusEvents) || ctype_digit($numberOfBonusEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfBonusEvents, true), gettype($numberOfBonusEvents)), __LINE__);
        }
        if (is_null($numberOfBonusEvents) || (is_array($numberOfBonusEvents) && empty($numberOfBonusEvents))) {
            unset($this->NumberOfBonusEvents);
        } else {
            $this->NumberOfBonusEvents = $numberOfBonusEvents;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get QuantityOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityOfEvents()
    {
        return isset($this->QuantityOfEvents) ? $this->QuantityOfEvents : null;
    }
    /**
     * Set QuantityOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityOfEvents
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setQuantityOfEvents($quantityOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($quantityOfEvents) && !(is_int($quantityOfEvents) || ctype_digit($quantityOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityOfEvents, true), gettype($quantityOfEvents)), __LINE__);
        }
        if (is_null($quantityOfEvents) || (is_array($quantityOfEvents) && empty($quantityOfEvents))) {
            unset($this->QuantityOfEvents);
        } else {
            $this->QuantityOfEvents = $quantityOfEvents;
        }
        return $this;
    }
    /**
     * Get Seasonality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonality()
    {
        return isset($this->Seasonality) ? $this->Seasonality : null;
    }
    /**
     * Set Seasonality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesSeasonality::valueIsValid()
     * @uses \patest\EnumType\SeriesSeasonality::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seasonality
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setSeasonality($seasonality = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesSeasonality::valueIsValid($seasonality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesSeasonality', is_array($seasonality) ? implode(', ', $seasonality) : var_export($seasonality, true), implode(', ', \patest\EnumType\SeriesSeasonality::getValidValues())), __LINE__);
        }
        if (is_null($seasonality) || (is_array($seasonality) && empty($seasonality))) {
            unset($this->Seasonality);
        } else {
            $this->Seasonality = $seasonality;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeasonName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSeasonName()
    {
        return isset($this->SeasonName) ? $this->SeasonName : null;
    }
    /**
     * Set SeasonName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $seasonName
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setSeasonName(\patest\StructType\GlobalString $seasonName = null)
    {
        if (is_null($seasonName) || (is_array($seasonName) && empty($seasonName))) {
            unset($this->SeasonName);
        } else {
            $this->SeasonName = $seasonName;
        }
        return $this;
    }
    /**
     * Get SeriesGroupSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_SubscriptionProductDescription|null
     */
    public function getSeriesGroupSeries()
    {
        return isset($this->SeriesGroupSeries) ? $this->SeriesGroupSeries : null;
    }
    /**
     * Set SeriesGroupSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_SubscriptionProductDescription $seriesGroupSeries
     * @return \patest\StructType\Ticketing_SubscriptionProductDescription
     */
    public function setSeriesGroupSeries(\patest\StructType\RecordSetOfTicketing_SubscriptionProductDescription $seriesGroupSeries = null)
    {
        if (is_null($seriesGroupSeries) || (is_array($seriesGroupSeries) && empty($seriesGroupSeries))) {
            unset($this->SeriesGroupSeries);
        } else {
            $this->SeriesGroupSeries = $seriesGroupSeries;
        }
        return $this;
    }
}
