<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SubscriptionInstanceRenewDetail StructType
 * @subpackage Structs
 */
class Ticketing_SubscriptionInstanceRenewDetail extends PersistableEntity
{
    /**
     * The NewAreaGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewAreaGuid;
    /**
     * The NewPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceTypeId;
    /**
     * The NewSeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewSeatIdInAreaMap;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * Constructor method for Ticketing.SubscriptionInstanceRenewDetail
     * @uses Ticketing_SubscriptionInstanceRenewDetail::setNewAreaGuid()
     * @uses Ticketing_SubscriptionInstanceRenewDetail::setNewPriceTypeId()
     * @uses Ticketing_SubscriptionInstanceRenewDetail::setNewSeatIdInAreaMap()
     * @uses Ticketing_SubscriptionInstanceRenewDetail::setSeriesId()
     * @uses Ticketing_SubscriptionInstanceRenewDetail::setSubscriptionInstanceId()
     * @param string $newAreaGuid
     * @param string $newPriceTypeId
     * @param int $newSeatIdInAreaMap
     * @param string $seriesId
     * @param string $subscriptionInstanceId
     */
    public function __construct($newAreaGuid = null, $newPriceTypeId = null, $newSeatIdInAreaMap = null, $seriesId = null, $subscriptionInstanceId = null)
    {
        $this
            ->setNewAreaGuid($newAreaGuid)
            ->setNewPriceTypeId($newPriceTypeId)
            ->setNewSeatIdInAreaMap($newSeatIdInAreaMap)
            ->setSeriesId($seriesId)
            ->setSubscriptionInstanceId($subscriptionInstanceId);
    }
    /**
     * Get NewAreaGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewAreaGuid()
    {
        return isset($this->NewAreaGuid) ? $this->NewAreaGuid : null;
    }
    /**
     * Set NewAreaGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newAreaGuid
     * @return \patest\StructType\Ticketing_SubscriptionInstanceRenewDetail
     */
    public function setNewAreaGuid($newAreaGuid = null)
    {
        // validation for constraint: string
        if (!is_null($newAreaGuid) && !is_string($newAreaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newAreaGuid, true), gettype($newAreaGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newAreaGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newAreaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newAreaGuid, true)), __LINE__);
        }
        if (is_null($newAreaGuid) || (is_array($newAreaGuid) && empty($newAreaGuid))) {
            unset($this->NewAreaGuid);
        } else {
            $this->NewAreaGuid = $newAreaGuid;
        }
        return $this;
    }
    /**
     * Get NewPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPriceTypeId()
    {
        return isset($this->NewPriceTypeId) ? $this->NewPriceTypeId : null;
    }
    /**
     * Set NewPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPriceTypeId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceRenewDetail
     */
    public function setNewPriceTypeId($newPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceTypeId) && !is_string($newPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceTypeId, true), gettype($newPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceTypeId, true)), __LINE__);
        }
        if (is_null($newPriceTypeId) || (is_array($newPriceTypeId) && empty($newPriceTypeId))) {
            unset($this->NewPriceTypeId);
        } else {
            $this->NewPriceTypeId = $newPriceTypeId;
        }
        return $this;
    }
    /**
     * Get NewSeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewSeatIdInAreaMap()
    {
        return isset($this->NewSeatIdInAreaMap) ? $this->NewSeatIdInAreaMap : null;
    }
    /**
     * Set NewSeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newSeatIdInAreaMap
     * @return \patest\StructType\Ticketing_SubscriptionInstanceRenewDetail
     */
    public function setNewSeatIdInAreaMap($newSeatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($newSeatIdInAreaMap) && !(is_int($newSeatIdInAreaMap) || ctype_digit($newSeatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newSeatIdInAreaMap, true), gettype($newSeatIdInAreaMap)), __LINE__);
        }
        if (is_null($newSeatIdInAreaMap) || (is_array($newSeatIdInAreaMap) && empty($newSeatIdInAreaMap))) {
            unset($this->NewSeatIdInAreaMap);
        } else {
            $this->NewSeatIdInAreaMap = $newSeatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceRenewDetail
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceRenewDetail
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
}
