<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SubscriptionInstanceExtendedFilter StructType
 * @subpackage Structs
 */
class Ticketing_SubscriptionInstanceExtendedFilter extends FilterEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The ClientSubscriptionSaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientSubscriptionSaleStatus;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The OBOAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OBOAccountId;
    /**
     * The PackageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PackageId;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceLevelTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelTypeId
     */
    public $PriceLevelTypeId;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypeIds
     */
    public $PriceTypeIds;
    /**
     * The PrintedStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedStatus;
    /**
     * The RenewStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenewStatus;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The ScanStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScanStatus;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeatAllocationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatAllocationId
     */
    public $SeatAllocationId;
    /**
     * The SeatLockId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatLockId
     */
    public $SeatLockId;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorName;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The StandId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\StandId
     */
    public $StandId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The TransactionDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDateFrom;
    /**
     * The TransactionDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDateTo;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Ticketing.SubscriptionInstanceExtendedFilter
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setAreaId()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setAreaIds()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setBarcode()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setClientSubscriptionSaleStatus()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setHallId()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setOBOAccountId()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setPackageId()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setPriceLevelId()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setPriceLevelTypeId()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setPriceTypeIds()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setPrintedStatus()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setRenewStatus()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setRowName()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setScanStatus()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setSeasonId()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setSeatAllocationId()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setSeatLockId()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setSeatName()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setSectorName()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setSeriesId()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setStandId()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setSubscriptionNumber()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setTransactionDateFrom()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setTransactionDateTo()
     * @uses Ticketing_SubscriptionInstanceExtendedFilter::setTransactionNumber()
     * @param string $areaId
     * @param \patest\StructType\AreaIds $areaIds
     * @param string $barcode
     * @param string $clientSubscriptionSaleStatus
     * @param string $hallId
     * @param string $oBOAccountId
     * @param string $packageId
     * @param string $priceLevelId
     * @param \patest\StructType\PriceLevelTypeId $priceLevelTypeId
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @param string $printedStatus
     * @param string $renewStatus
     * @param string $rowName
     * @param string $scanStatus
     * @param string $seasonId
     * @param \patest\StructType\SeatAllocationId $seatAllocationId
     * @param \patest\StructType\SeatLockId $seatLockId
     * @param string $seatName
     * @param \patest\StructType\GlobalString $sectorName
     * @param string $seriesId
     * @param \patest\StructType\StandId $standId
     * @param string $subscriptionNumber
     * @param string $transactionDateFrom
     * @param string $transactionDateTo
     * @param int $transactionNumber
     */
    public function __construct($areaId = null, \patest\StructType\AreaIds $areaIds = null, $barcode = null, $clientSubscriptionSaleStatus = null, $hallId = null, $oBOAccountId = null, $packageId = null, $priceLevelId = null, \patest\StructType\PriceLevelTypeId $priceLevelTypeId = null, \patest\StructType\PriceTypeIds $priceTypeIds = null, $printedStatus = null, $renewStatus = null, $rowName = null, $scanStatus = null, $seasonId = null, \patest\StructType\SeatAllocationId $seatAllocationId = null, \patest\StructType\SeatLockId $seatLockId = null, $seatName = null, \patest\StructType\GlobalString $sectorName = null, $seriesId = null, \patest\StructType\StandId $standId = null, $subscriptionNumber = null, $transactionDateFrom = null, $transactionDateTo = null, $transactionNumber = null)
    {
        $this
            ->setAreaId($areaId)
            ->setAreaIds($areaIds)
            ->setBarcode($barcode)
            ->setClientSubscriptionSaleStatus($clientSubscriptionSaleStatus)
            ->setHallId($hallId)
            ->setOBOAccountId($oBOAccountId)
            ->setPackageId($packageId)
            ->setPriceLevelId($priceLevelId)
            ->setPriceLevelTypeId($priceLevelTypeId)
            ->setPriceTypeIds($priceTypeIds)
            ->setPrintedStatus($printedStatus)
            ->setRenewStatus($renewStatus)
            ->setRowName($rowName)
            ->setScanStatus($scanStatus)
            ->setSeasonId($seasonId)
            ->setSeatAllocationId($seatAllocationId)
            ->setSeatLockId($seatLockId)
            ->setSeatName($seatName)
            ->setSectorName($sectorName)
            ->setSeriesId($seriesId)
            ->setStandId($standId)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setTransactionDateFrom($transactionDateFrom)
            ->setTransactionDateTo($transactionDateTo)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get ClientSubscriptionSaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientSubscriptionSaleStatus()
    {
        return isset($this->ClientSubscriptionSaleStatus) ? $this->ClientSubscriptionSaleStatus : null;
    }
    /**
     * Set ClientSubscriptionSaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriptionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientSubscriptionSaleStatus
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setClientSubscriptionSaleStatus($clientSubscriptionSaleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionStatus::valueIsValid($clientSubscriptionSaleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionStatus', is_array($clientSubscriptionSaleStatus) ? implode(', ', $clientSubscriptionSaleStatus) : var_export($clientSubscriptionSaleStatus, true), implode(', ', \patest\EnumType\SubscriptionStatus::getValidValues())), __LINE__);
        }
        if (is_null($clientSubscriptionSaleStatus) || (is_array($clientSubscriptionSaleStatus) && empty($clientSubscriptionSaleStatus))) {
            unset($this->ClientSubscriptionSaleStatus);
        } else {
            $this->ClientSubscriptionSaleStatus = $clientSubscriptionSaleStatus;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get OBOAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOBOAccountId()
    {
        return isset($this->OBOAccountId) ? $this->OBOAccountId : null;
    }
    /**
     * Set OBOAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oBOAccountId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setOBOAccountId($oBOAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($oBOAccountId) && !is_string($oBOAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oBOAccountId, true), gettype($oBOAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($oBOAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $oBOAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($oBOAccountId, true)), __LINE__);
        }
        if (is_null($oBOAccountId) || (is_array($oBOAccountId) && empty($oBOAccountId))) {
            unset($this->OBOAccountId);
        } else {
            $this->OBOAccountId = $oBOAccountId;
        }
        return $this;
    }
    /**
     * Get PackageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageId()
    {
        return isset($this->PackageId) ? $this->PackageId : null;
    }
    /**
     * Set PackageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: string
        if (!is_null($packageId) && !is_string($packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($packageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($packageId, true)), __LINE__);
        }
        if (is_null($packageId) || (is_array($packageId) && empty($packageId))) {
            unset($this->PackageId);
        } else {
            $this->PackageId = $packageId;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceLevelTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelTypeId|null
     */
    public function getPriceLevelTypeId()
    {
        return isset($this->PriceLevelTypeId) ? $this->PriceLevelTypeId : null;
    }
    /**
     * Set PriceLevelTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelTypeId $priceLevelTypeId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setPriceLevelTypeId(\patest\StructType\PriceLevelTypeId $priceLevelTypeId = null)
    {
        if (is_null($priceLevelTypeId) || (is_array($priceLevelTypeId) && empty($priceLevelTypeId))) {
            unset($this->PriceLevelTypeId);
        } else {
            $this->PriceLevelTypeId = $priceLevelTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypeIds|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setPriceTypeIds(\patest\StructType\PriceTypeIds $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
    /**
     * Get PrintedStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedStatus()
    {
        return isset($this->PrintedStatus) ? $this->PrintedStatus : null;
    }
    /**
     * Set PrintedStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PrintStatus::valueIsValid()
     * @uses \patest\EnumType\PrintStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printedStatus
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setPrintedStatus($printedStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PrintStatus::valueIsValid($printedStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PrintStatus', is_array($printedStatus) ? implode(', ', $printedStatus) : var_export($printedStatus, true), implode(', ', \patest\EnumType\PrintStatus::getValidValues())), __LINE__);
        }
        if (is_null($printedStatus) || (is_array($printedStatus) && empty($printedStatus))) {
            unset($this->PrintedStatus);
        } else {
            $this->PrintedStatus = $printedStatus;
        }
        return $this;
    }
    /**
     * Get RenewStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewStatus()
    {
        return isset($this->RenewStatus) ? $this->RenewStatus : null;
    }
    /**
     * Set RenewStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionRenewStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriptionRenewStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $renewStatus
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setRenewStatus($renewStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionRenewStatus::valueIsValid($renewStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionRenewStatus', is_array($renewStatus) ? implode(', ', $renewStatus) : var_export($renewStatus, true), implode(', ', \patest\EnumType\SubscriptionRenewStatus::getValidValues())), __LINE__);
        }
        if (is_null($renewStatus) || (is_array($renewStatus) && empty($renewStatus))) {
            unset($this->RenewStatus);
        } else {
            $this->RenewStatus = $renewStatus;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get ScanStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScanStatus()
    {
        return isset($this->ScanStatus) ? $this->ScanStatus : null;
    }
    /**
     * Set ScanStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ScanStatus::valueIsValid()
     * @uses \patest\EnumType\ScanStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scanStatus
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setScanStatus($scanStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ScanStatus::valueIsValid($scanStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ScanStatus', is_array($scanStatus) ? implode(', ', $scanStatus) : var_export($scanStatus, true), implode(', ', \patest\EnumType\ScanStatus::getValidValues())), __LINE__);
        }
        if (is_null($scanStatus) || (is_array($scanStatus) && empty($scanStatus))) {
            unset($this->ScanStatus);
        } else {
            $this->ScanStatus = $scanStatus;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeatAllocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatAllocationId|null
     */
    public function getSeatAllocationId()
    {
        return isset($this->SeatAllocationId) ? $this->SeatAllocationId : null;
    }
    /**
     * Set SeatAllocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatAllocationId $seatAllocationId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setSeatAllocationId(\patest\StructType\SeatAllocationId $seatAllocationId = null)
    {
        if (is_null($seatAllocationId) || (is_array($seatAllocationId) && empty($seatAllocationId))) {
            unset($this->SeatAllocationId);
        } else {
            $this->SeatAllocationId = $seatAllocationId;
        }
        return $this;
    }
    /**
     * Get SeatLockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatLockId|null
     */
    public function getSeatLockId()
    {
        return isset($this->SeatLockId) ? $this->SeatLockId : null;
    }
    /**
     * Set SeatLockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatLockId $seatLockId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setSeatLockId(\patest\StructType\SeatLockId $seatLockId = null)
    {
        if (is_null($seatLockId) || (is_array($seatLockId) && empty($seatLockId))) {
            unset($this->SeatLockId);
        } else {
            $this->SeatLockId = $seatLockId;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorName
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setSectorName(\patest\StructType\GlobalString $sectorName = null)
    {
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get StandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\StandId|null
     */
    public function getStandId()
    {
        return isset($this->StandId) ? $this->StandId : null;
    }
    /**
     * Set StandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\StandId $standId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setStandId(\patest\StructType\StandId $standId = null)
    {
        if (is_null($standId) || (is_array($standId) && empty($standId))) {
            unset($this->StandId);
        } else {
            $this->StandId = $standId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDateFrom()
    {
        return isset($this->TransactionDateFrom) ? $this->TransactionDateFrom : null;
    }
    /**
     * Set TransactionDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDateFrom
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setTransactionDateFrom($transactionDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateFrom) && !is_string($transactionDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDateFrom, true), gettype($transactionDateFrom)), __LINE__);
        }
        if (is_null($transactionDateFrom) || (is_array($transactionDateFrom) && empty($transactionDateFrom))) {
            unset($this->TransactionDateFrom);
        } else {
            $this->TransactionDateFrom = $transactionDateFrom;
        }
        return $this;
    }
    /**
     * Get TransactionDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDateTo()
    {
        return isset($this->TransactionDateTo) ? $this->TransactionDateTo : null;
    }
    /**
     * Set TransactionDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDateTo
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setTransactionDateTo($transactionDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateTo) && !is_string($transactionDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDateTo, true), gettype($transactionDateTo)), __LINE__);
        }
        if (is_null($transactionDateTo) || (is_array($transactionDateTo) && empty($transactionDateTo))) {
            unset($this->TransactionDateTo);
        } else {
            $this->TransactionDateTo = $transactionDateTo;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtendedFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
