<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SubscriptionInstance StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.SubscriptionInstance
 * @subpackage Structs
 */
class Ticketing_SubscriptionInstance extends PersistableEntity
{
    /**
     * The AlsoDeliveredAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlsoDeliveredAs;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AreaName;
    /**
     * The BonusEventCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BonusEventCount;
    /**
     * The BonusTicketsRemainder
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BonusTicketsRemainder;
    /**
     * The BonusTicketsUtilization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BonusTicketsUtilization;
    /**
     * The BucketsInfoAtPurchase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BucketsInfoAtPurchase;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardStatus;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The EndDateOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDateOverride;
    /**
     * The EntityVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityVersion;
    /**
     * The EssentialSeatData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_EssentialSeriesSeatData
     */
    public $EssentialSeatData;
    /**
     * The ExtensionOfInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtensionOfInstanceId;
    /**
     * The GateIds
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GateIds;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The HasIrregularTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasIrregularTickets;
    /**
     * The HasRenewDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasRenewDetails;
    /**
     * The IsBonusTicketPriceable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBonusTicketPriceable;
    /**
     * The IsGift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGift;
    /**
     * The IsHospitality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHospitality;
    /**
     * The IsPartialEventBased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPartialEventBased;
    /**
     * The IsPricedPerSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPricedPerSeries;
    /**
     * The IsPrinting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinting;
    /**
     * The MasterInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MasterInstanceId;
    /**
     * The MaxAllowedFullStackExchanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxAllowedFullStackExchanges;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NewAreaGuidForRenew
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewAreaGuidForRenew;
    /**
     * The NewPriceTypeIdToRenew
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceTypeIdToRenew;
    /**
     * The NewSeatIdForRenew
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewSeatIdForRenew;
    /**
     * The NormalizedRowName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NormalizedRowName;
    /**
     * The NormalizedSeatName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NormalizedSeatName;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PeriodDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PeriodDescription;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PricingVariationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PricingVariationId;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The PrintedNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintedNumber;
    /**
     * The PurchaserClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserClientId;
    /**
     * The RegularTicketsRemainder
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RegularTicketsRemainder;
    /**
     * The RegularTicketsUtilization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RegularTicketsUtilization;
    /**
     * The RenewOfInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewOfInstanceId;
    /**
     * The RenewStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenewStatus;
    /**
     * The RestrictionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RestrictionId;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatInfo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_SeatInfo
     */
    public $SeatInfo;
    /**
     * The SeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatingType;
    /**
     * The SeatLocationDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatLocationDescription;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorGlobalName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorGlobalName;
    /**
     * The SeriesEventCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeriesEventCount;
    /**
     * The SeriesGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesGroupId;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SeriesName;
    /**
     * The SeriesSchemeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesSchemeId;
    /**
     * The SingleEventPricingDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SingleEventPricingDetails;
    /**
     * The SoldInRegularTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SoldInRegularTransaction;
    /**
     * The StandName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $StandName;
    /**
     * The StartDateOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDateOverride;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SubscriptionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The SubscriptionTransactionItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionTransactionItemId;
    /**
     * The SubsidizedByAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubsidizedByAccountId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TurnstileIds
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TurnstileIds;
    /**
     * The UpdateInstanceIdChain
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UpdateInstanceIdChain;
    /**
     * The UpdateOfInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UpdateOfInstanceId;
    /**
     * The UsedFullStackExchanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UsedFullStackExchanges;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * The WaitMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WaitMode;
    /**
     * Constructor method for Ticketing.SubscriptionInstance
     * @uses Ticketing_SubscriptionInstance::setAlsoDeliveredAs()
     * @uses Ticketing_SubscriptionInstance::setApplicationChannel()
     * @uses Ticketing_SubscriptionInstance::setAreaId()
     * @uses Ticketing_SubscriptionInstance::setAreaName()
     * @uses Ticketing_SubscriptionInstance::setBonusEventCount()
     * @uses Ticketing_SubscriptionInstance::setBonusTicketsRemainder()
     * @uses Ticketing_SubscriptionInstance::setBonusTicketsUtilization()
     * @uses Ticketing_SubscriptionInstance::setBucketsInfoAtPurchase()
     * @uses Ticketing_SubscriptionInstance::setCardNumber()
     * @uses Ticketing_SubscriptionInstance::setCardStatus()
     * @uses Ticketing_SubscriptionInstance::setClientId()
     * @uses Ticketing_SubscriptionInstance::setCreationDate()
     * @uses Ticketing_SubscriptionInstance::setDisplayName()
     * @uses Ticketing_SubscriptionInstance::setEndDateOverride()
     * @uses Ticketing_SubscriptionInstance::setEntityVersion()
     * @uses Ticketing_SubscriptionInstance::setEssentialSeatData()
     * @uses Ticketing_SubscriptionInstance::setExtensionOfInstanceId()
     * @uses Ticketing_SubscriptionInstance::setGateIds()
     * @uses Ticketing_SubscriptionInstance::setHallId()
     * @uses Ticketing_SubscriptionInstance::setHallName()
     * @uses Ticketing_SubscriptionInstance::setHasIrregularTickets()
     * @uses Ticketing_SubscriptionInstance::setHasRenewDetails()
     * @uses Ticketing_SubscriptionInstance::setIsBonusTicketPriceable()
     * @uses Ticketing_SubscriptionInstance::setIsGift()
     * @uses Ticketing_SubscriptionInstance::setIsHospitality()
     * @uses Ticketing_SubscriptionInstance::setIsPartialEventBased()
     * @uses Ticketing_SubscriptionInstance::setIsPricedPerSeries()
     * @uses Ticketing_SubscriptionInstance::setIsPrinting()
     * @uses Ticketing_SubscriptionInstance::setMasterInstanceId()
     * @uses Ticketing_SubscriptionInstance::setMaxAllowedFullStackExchanges()
     * @uses Ticketing_SubscriptionInstance::setName()
     * @uses Ticketing_SubscriptionInstance::setNewAreaGuidForRenew()
     * @uses Ticketing_SubscriptionInstance::setNewPriceTypeIdToRenew()
     * @uses Ticketing_SubscriptionInstance::setNewSeatIdForRenew()
     * @uses Ticketing_SubscriptionInstance::setNormalizedRowName()
     * @uses Ticketing_SubscriptionInstance::setNormalizedSeatName()
     * @uses Ticketing_SubscriptionInstance::setNotes()
     * @uses Ticketing_SubscriptionInstance::setOrganizationUnitId()
     * @uses Ticketing_SubscriptionInstance::setPeriodDescription()
     * @uses Ticketing_SubscriptionInstance::setPriceLevelId()
     * @uses Ticketing_SubscriptionInstance::setPriceTypeId()
     * @uses Ticketing_SubscriptionInstance::setPricingVariationId()
     * @uses Ticketing_SubscriptionInstance::setPrintCount()
     * @uses Ticketing_SubscriptionInstance::setPrintedNumber()
     * @uses Ticketing_SubscriptionInstance::setPurchaserClientId()
     * @uses Ticketing_SubscriptionInstance::setRegularTicketsRemainder()
     * @uses Ticketing_SubscriptionInstance::setRegularTicketsUtilization()
     * @uses Ticketing_SubscriptionInstance::setRenewOfInstanceId()
     * @uses Ticketing_SubscriptionInstance::setRenewStatus()
     * @uses Ticketing_SubscriptionInstance::setRestrictionId()
     * @uses Ticketing_SubscriptionInstance::setRowName()
     * @uses Ticketing_SubscriptionInstance::setSeasonId()
     * @uses Ticketing_SubscriptionInstance::setSeatIdInAreaMap()
     * @uses Ticketing_SubscriptionInstance::setSeatInfo()
     * @uses Ticketing_SubscriptionInstance::setSeatingType()
     * @uses Ticketing_SubscriptionInstance::setSeatLocationDescription()
     * @uses Ticketing_SubscriptionInstance::setSeatName()
     * @uses Ticketing_SubscriptionInstance::setSectorGlobalName()
     * @uses Ticketing_SubscriptionInstance::setSeriesEventCount()
     * @uses Ticketing_SubscriptionInstance::setSeriesGroupId()
     * @uses Ticketing_SubscriptionInstance::setSeriesId()
     * @uses Ticketing_SubscriptionInstance::setSeriesName()
     * @uses Ticketing_SubscriptionInstance::setSeriesSchemeId()
     * @uses Ticketing_SubscriptionInstance::setSingleEventPricingDetails()
     * @uses Ticketing_SubscriptionInstance::setSoldInRegularTransaction()
     * @uses Ticketing_SubscriptionInstance::setStandName()
     * @uses Ticketing_SubscriptionInstance::setStartDateOverride()
     * @uses Ticketing_SubscriptionInstance::setStatus()
     * @uses Ticketing_SubscriptionInstance::setSubscriptionId()
     * @uses Ticketing_SubscriptionInstance::setSubscriptionNumber()
     * @uses Ticketing_SubscriptionInstance::setSubscriptionTransactionItemId()
     * @uses Ticketing_SubscriptionInstance::setSubsidizedByAccountId()
     * @uses Ticketing_SubscriptionInstance::setTransactionGuid()
     * @uses Ticketing_SubscriptionInstance::setTurnstileIds()
     * @uses Ticketing_SubscriptionInstance::setUpdateInstanceIdChain()
     * @uses Ticketing_SubscriptionInstance::setUpdateOfInstanceId()
     * @uses Ticketing_SubscriptionInstance::setUsedFullStackExchanges()
     * @uses Ticketing_SubscriptionInstance::setVisibleBySubordinates()
     * @uses Ticketing_SubscriptionInstance::setWaitMode()
     * @param string $alsoDeliveredAs
     * @param string $applicationChannel
     * @param string $areaId
     * @param \patest\StructType\GlobalString $areaName
     * @param int $bonusEventCount
     * @param int $bonusTicketsRemainder
     * @param int $bonusTicketsUtilization
     * @param string $bucketsInfoAtPurchase
     * @param string $cardNumber
     * @param string $cardStatus
     * @param string $clientId
     * @param string $creationDate
     * @param string $displayName
     * @param string $endDateOverride
     * @param string $entityVersion
     * @param \patest\StructType\Ticketing_EssentialSeriesSeatData $essentialSeatData
     * @param string $extensionOfInstanceId
     * @param string $gateIds
     * @param string $hallId
     * @param \patest\StructType\GlobalString $hallName
     * @param bool $hasIrregularTickets
     * @param bool $hasRenewDetails
     * @param bool $isBonusTicketPriceable
     * @param bool $isGift
     * @param bool $isHospitality
     * @param bool $isPartialEventBased
     * @param bool $isPricedPerSeries
     * @param bool $isPrinting
     * @param string $masterInstanceId
     * @param int $maxAllowedFullStackExchanges
     * @param \patest\StructType\GlobalString $name
     * @param string $newAreaGuidForRenew
     * @param string $newPriceTypeIdToRenew
     * @param int $newSeatIdForRenew
     * @param string $normalizedRowName
     * @param string $normalizedSeatName
     * @param string $notes
     * @param string $organizationUnitId
     * @param string $periodDescription
     * @param string $priceLevelId
     * @param string $priceTypeId
     * @param int $pricingVariationId
     * @param int $printCount
     * @param int $printedNumber
     * @param string $purchaserClientId
     * @param int $regularTicketsRemainder
     * @param int $regularTicketsUtilization
     * @param string $renewOfInstanceId
     * @param string $renewStatus
     * @param string $restrictionId
     * @param string $rowName
     * @param string $seasonId
     * @param int $seatIdInAreaMap
     * @param \patest\StructType\Ticketing_SeatInfo $seatInfo
     * @param string $seatingType
     * @param string $seatLocationDescription
     * @param string $seatName
     * @param \patest\StructType\GlobalString $sectorGlobalName
     * @param int $seriesEventCount
     * @param string $seriesGroupId
     * @param string $seriesId
     * @param \patest\StructType\GlobalString $seriesName
     * @param string $seriesSchemeId
     * @param string $singleEventPricingDetails
     * @param bool $soldInRegularTransaction
     * @param \patest\StructType\GlobalString $standName
     * @param string $startDateOverride
     * @param string $status
     * @param string $subscriptionId
     * @param string $subscriptionNumber
     * @param string $subscriptionTransactionItemId
     * @param string $subsidizedByAccountId
     * @param string $transactionGuid
     * @param string $turnstileIds
     * @param string $updateInstanceIdChain
     * @param string $updateOfInstanceId
     * @param int $usedFullStackExchanges
     * @param bool $visibleBySubordinates
     * @param string $waitMode
     */
    public function __construct($alsoDeliveredAs = null, $applicationChannel = null, $areaId = null, \patest\StructType\GlobalString $areaName = null, $bonusEventCount = null, $bonusTicketsRemainder = null, $bonusTicketsUtilization = null, $bucketsInfoAtPurchase = null, $cardNumber = null, $cardStatus = null, $clientId = null, $creationDate = null, $displayName = null, $endDateOverride = null, $entityVersion = null, \patest\StructType\Ticketing_EssentialSeriesSeatData $essentialSeatData = null, $extensionOfInstanceId = null, $gateIds = null, $hallId = null, \patest\StructType\GlobalString $hallName = null, $hasIrregularTickets = null, $hasRenewDetails = null, $isBonusTicketPriceable = null, $isGift = null, $isHospitality = null, $isPartialEventBased = null, $isPricedPerSeries = null, $isPrinting = null, $masterInstanceId = null, $maxAllowedFullStackExchanges = null, \patest\StructType\GlobalString $name = null, $newAreaGuidForRenew = null, $newPriceTypeIdToRenew = null, $newSeatIdForRenew = null, $normalizedRowName = null, $normalizedSeatName = null, $notes = null, $organizationUnitId = null, $periodDescription = null, $priceLevelId = null, $priceTypeId = null, $pricingVariationId = null, $printCount = null, $printedNumber = null, $purchaserClientId = null, $regularTicketsRemainder = null, $regularTicketsUtilization = null, $renewOfInstanceId = null, $renewStatus = null, $restrictionId = null, $rowName = null, $seasonId = null, $seatIdInAreaMap = null, \patest\StructType\Ticketing_SeatInfo $seatInfo = null, $seatingType = null, $seatLocationDescription = null, $seatName = null, \patest\StructType\GlobalString $sectorGlobalName = null, $seriesEventCount = null, $seriesGroupId = null, $seriesId = null, \patest\StructType\GlobalString $seriesName = null, $seriesSchemeId = null, $singleEventPricingDetails = null, $soldInRegularTransaction = null, \patest\StructType\GlobalString $standName = null, $startDateOverride = null, $status = null, $subscriptionId = null, $subscriptionNumber = null, $subscriptionTransactionItemId = null, $subsidizedByAccountId = null, $transactionGuid = null, $turnstileIds = null, $updateInstanceIdChain = null, $updateOfInstanceId = null, $usedFullStackExchanges = null, $visibleBySubordinates = null, $waitMode = null)
    {
        $this
            ->setAlsoDeliveredAs($alsoDeliveredAs)
            ->setApplicationChannel($applicationChannel)
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setBonusEventCount($bonusEventCount)
            ->setBonusTicketsRemainder($bonusTicketsRemainder)
            ->setBonusTicketsUtilization($bonusTicketsUtilization)
            ->setBucketsInfoAtPurchase($bucketsInfoAtPurchase)
            ->setCardNumber($cardNumber)
            ->setCardStatus($cardStatus)
            ->setClientId($clientId)
            ->setCreationDate($creationDate)
            ->setDisplayName($displayName)
            ->setEndDateOverride($endDateOverride)
            ->setEntityVersion($entityVersion)
            ->setEssentialSeatData($essentialSeatData)
            ->setExtensionOfInstanceId($extensionOfInstanceId)
            ->setGateIds($gateIds)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setHasIrregularTickets($hasIrregularTickets)
            ->setHasRenewDetails($hasRenewDetails)
            ->setIsBonusTicketPriceable($isBonusTicketPriceable)
            ->setIsGift($isGift)
            ->setIsHospitality($isHospitality)
            ->setIsPartialEventBased($isPartialEventBased)
            ->setIsPricedPerSeries($isPricedPerSeries)
            ->setIsPrinting($isPrinting)
            ->setMasterInstanceId($masterInstanceId)
            ->setMaxAllowedFullStackExchanges($maxAllowedFullStackExchanges)
            ->setName($name)
            ->setNewAreaGuidForRenew($newAreaGuidForRenew)
            ->setNewPriceTypeIdToRenew($newPriceTypeIdToRenew)
            ->setNewSeatIdForRenew($newSeatIdForRenew)
            ->setNormalizedRowName($normalizedRowName)
            ->setNormalizedSeatName($normalizedSeatName)
            ->setNotes($notes)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPeriodDescription($periodDescription)
            ->setPriceLevelId($priceLevelId)
            ->setPriceTypeId($priceTypeId)
            ->setPricingVariationId($pricingVariationId)
            ->setPrintCount($printCount)
            ->setPrintedNumber($printedNumber)
            ->setPurchaserClientId($purchaserClientId)
            ->setRegularTicketsRemainder($regularTicketsRemainder)
            ->setRegularTicketsUtilization($regularTicketsUtilization)
            ->setRenewOfInstanceId($renewOfInstanceId)
            ->setRenewStatus($renewStatus)
            ->setRestrictionId($restrictionId)
            ->setRowName($rowName)
            ->setSeasonId($seasonId)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatInfo($seatInfo)
            ->setSeatingType($seatingType)
            ->setSeatLocationDescription($seatLocationDescription)
            ->setSeatName($seatName)
            ->setSectorGlobalName($sectorGlobalName)
            ->setSeriesEventCount($seriesEventCount)
            ->setSeriesGroupId($seriesGroupId)
            ->setSeriesId($seriesId)
            ->setSeriesName($seriesName)
            ->setSeriesSchemeId($seriesSchemeId)
            ->setSingleEventPricingDetails($singleEventPricingDetails)
            ->setSoldInRegularTransaction($soldInRegularTransaction)
            ->setStandName($standName)
            ->setStartDateOverride($startDateOverride)
            ->setStatus($status)
            ->setSubscriptionId($subscriptionId)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setSubscriptionTransactionItemId($subscriptionTransactionItemId)
            ->setSubsidizedByAccountId($subsidizedByAccountId)
            ->setTransactionGuid($transactionGuid)
            ->setTurnstileIds($turnstileIds)
            ->setUpdateInstanceIdChain($updateInstanceIdChain)
            ->setUpdateOfInstanceId($updateOfInstanceId)
            ->setUsedFullStackExchanges($usedFullStackExchanges)
            ->setVisibleBySubordinates($visibleBySubordinates)
            ->setWaitMode($waitMode);
    }
    /**
     * Get AlsoDeliveredAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlsoDeliveredAs()
    {
        return isset($this->AlsoDeliveredAs) ? $this->AlsoDeliveredAs : null;
    }
    /**
     * Set AlsoDeliveredAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alsoDeliveredAs
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setAlsoDeliveredAs($alsoDeliveredAs = null)
    {
        // validation for constraint: string
        if (!is_null($alsoDeliveredAs) && !is_string($alsoDeliveredAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alsoDeliveredAs, true), gettype($alsoDeliveredAs)), __LINE__);
        }
        if (is_null($alsoDeliveredAs) || (is_array($alsoDeliveredAs) && empty($alsoDeliveredAs))) {
            unset($this->AlsoDeliveredAs);
        } else {
            $this->AlsoDeliveredAs = $alsoDeliveredAs;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $areaName
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setAreaName(\patest\StructType\GlobalString $areaName = null)
    {
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get BonusEventCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBonusEventCount()
    {
        return isset($this->BonusEventCount) ? $this->BonusEventCount : null;
    }
    /**
     * Set BonusEventCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bonusEventCount
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setBonusEventCount($bonusEventCount = null)
    {
        // validation for constraint: int
        if (!is_null($bonusEventCount) && !(is_int($bonusEventCount) || ctype_digit($bonusEventCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bonusEventCount, true), gettype($bonusEventCount)), __LINE__);
        }
        if (is_null($bonusEventCount) || (is_array($bonusEventCount) && empty($bonusEventCount))) {
            unset($this->BonusEventCount);
        } else {
            $this->BonusEventCount = $bonusEventCount;
        }
        return $this;
    }
    /**
     * Get BonusTicketsRemainder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBonusTicketsRemainder()
    {
        return isset($this->BonusTicketsRemainder) ? $this->BonusTicketsRemainder : null;
    }
    /**
     * Set BonusTicketsRemainder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bonusTicketsRemainder
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setBonusTicketsRemainder($bonusTicketsRemainder = null)
    {
        // validation for constraint: int
        if (!is_null($bonusTicketsRemainder) && !(is_int($bonusTicketsRemainder) || ctype_digit($bonusTicketsRemainder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bonusTicketsRemainder, true), gettype($bonusTicketsRemainder)), __LINE__);
        }
        if (is_null($bonusTicketsRemainder) || (is_array($bonusTicketsRemainder) && empty($bonusTicketsRemainder))) {
            unset($this->BonusTicketsRemainder);
        } else {
            $this->BonusTicketsRemainder = $bonusTicketsRemainder;
        }
        return $this;
    }
    /**
     * Get BonusTicketsUtilization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBonusTicketsUtilization()
    {
        return isset($this->BonusTicketsUtilization) ? $this->BonusTicketsUtilization : null;
    }
    /**
     * Set BonusTicketsUtilization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bonusTicketsUtilization
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setBonusTicketsUtilization($bonusTicketsUtilization = null)
    {
        // validation for constraint: int
        if (!is_null($bonusTicketsUtilization) && !(is_int($bonusTicketsUtilization) || ctype_digit($bonusTicketsUtilization))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bonusTicketsUtilization, true), gettype($bonusTicketsUtilization)), __LINE__);
        }
        if (is_null($bonusTicketsUtilization) || (is_array($bonusTicketsUtilization) && empty($bonusTicketsUtilization))) {
            unset($this->BonusTicketsUtilization);
        } else {
            $this->BonusTicketsUtilization = $bonusTicketsUtilization;
        }
        return $this;
    }
    /**
     * Get BucketsInfoAtPurchase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBucketsInfoAtPurchase()
    {
        return isset($this->BucketsInfoAtPurchase) ? $this->BucketsInfoAtPurchase : null;
    }
    /**
     * Set BucketsInfoAtPurchase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bucketsInfoAtPurchase
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setBucketsInfoAtPurchase($bucketsInfoAtPurchase = null)
    {
        // validation for constraint: string
        if (!is_null($bucketsInfoAtPurchase) && !is_string($bucketsInfoAtPurchase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bucketsInfoAtPurchase, true), gettype($bucketsInfoAtPurchase)), __LINE__);
        }
        if (is_null($bucketsInfoAtPurchase) || (is_array($bucketsInfoAtPurchase) && empty($bucketsInfoAtPurchase))) {
            unset($this->BucketsInfoAtPurchase);
        } else {
            $this->BucketsInfoAtPurchase = $bucketsInfoAtPurchase;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardStatus()
    {
        return isset($this->CardStatus) ? $this->CardStatus : null;
    }
    /**
     * Set CardStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessCardStatus::valueIsValid()
     * @uses \patest\EnumType\AccessCardStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardStatus
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setCardStatus($cardStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccessCardStatus::valueIsValid($cardStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessCardStatus', is_array($cardStatus) ? implode(', ', $cardStatus) : var_export($cardStatus, true), implode(', ', \patest\EnumType\AccessCardStatus::getValidValues())), __LINE__);
        }
        if (is_null($cardStatus) || (is_array($cardStatus) && empty($cardStatus))) {
            unset($this->CardStatus);
        } else {
            $this->CardStatus = $cardStatus;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get EndDateOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDateOverride()
    {
        return isset($this->EndDateOverride) ? $this->EndDateOverride : null;
    }
    /**
     * Set EndDateOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDateOverride
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setEndDateOverride($endDateOverride = null)
    {
        // validation for constraint: string
        if (!is_null($endDateOverride) && !is_string($endDateOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateOverride, true), gettype($endDateOverride)), __LINE__);
        }
        if (is_null($endDateOverride) || (is_array($endDateOverride) && empty($endDateOverride))) {
            unset($this->EndDateOverride);
        } else {
            $this->EndDateOverride = $endDateOverride;
        }
        return $this;
    }
    /**
     * Get EntityVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityVersion()
    {
        return isset($this->EntityVersion) ? $this->EntityVersion : null;
    }
    /**
     * Set EntityVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityVersion
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setEntityVersion($entityVersion = null)
    {
        // validation for constraint: string
        if (!is_null($entityVersion) && !is_string($entityVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityVersion, true), gettype($entityVersion)), __LINE__);
        }
        if (is_null($entityVersion) || (is_array($entityVersion) && empty($entityVersion))) {
            unset($this->EntityVersion);
        } else {
            $this->EntityVersion = $entityVersion;
        }
        return $this;
    }
    /**
     * Get EssentialSeatData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_EssentialSeriesSeatData|null
     */
    public function getEssentialSeatData()
    {
        return isset($this->EssentialSeatData) ? $this->EssentialSeatData : null;
    }
    /**
     * Set EssentialSeatData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_EssentialSeriesSeatData $essentialSeatData
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setEssentialSeatData(\patest\StructType\Ticketing_EssentialSeriesSeatData $essentialSeatData = null)
    {
        if (is_null($essentialSeatData) || (is_array($essentialSeatData) && empty($essentialSeatData))) {
            unset($this->EssentialSeatData);
        } else {
            $this->EssentialSeatData = $essentialSeatData;
        }
        return $this;
    }
    /**
     * Get ExtensionOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtensionOfInstanceId()
    {
        return isset($this->ExtensionOfInstanceId) ? $this->ExtensionOfInstanceId : null;
    }
    /**
     * Set ExtensionOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extensionOfInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setExtensionOfInstanceId($extensionOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($extensionOfInstanceId) && !is_string($extensionOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extensionOfInstanceId, true), gettype($extensionOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extensionOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extensionOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extensionOfInstanceId, true)), __LINE__);
        }
        if (is_null($extensionOfInstanceId) || (is_array($extensionOfInstanceId) && empty($extensionOfInstanceId))) {
            unset($this->ExtensionOfInstanceId);
        } else {
            $this->ExtensionOfInstanceId = $extensionOfInstanceId;
        }
        return $this;
    }
    /**
     * Get GateIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGateIds()
    {
        return isset($this->GateIds) ? $this->GateIds : null;
    }
    /**
     * Set GateIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gateIds
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setGateIds($gateIds = null)
    {
        // validation for constraint: string
        if (!is_null($gateIds) && !is_string($gateIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gateIds, true), gettype($gateIds)), __LINE__);
        }
        if (is_null($gateIds) || (is_array($gateIds) && empty($gateIds))) {
            unset($this->GateIds);
        } else {
            $this->GateIds = $gateIds;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get HasIrregularTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasIrregularTickets()
    {
        return isset($this->HasIrregularTickets) ? $this->HasIrregularTickets : null;
    }
    /**
     * Set HasIrregularTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasIrregularTickets
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setHasIrregularTickets($hasIrregularTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasIrregularTickets) && !is_bool($hasIrregularTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasIrregularTickets, true), gettype($hasIrregularTickets)), __LINE__);
        }
        if (is_null($hasIrregularTickets) || (is_array($hasIrregularTickets) && empty($hasIrregularTickets))) {
            unset($this->HasIrregularTickets);
        } else {
            $this->HasIrregularTickets = $hasIrregularTickets;
        }
        return $this;
    }
    /**
     * Get HasRenewDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasRenewDetails()
    {
        return isset($this->HasRenewDetails) ? $this->HasRenewDetails : null;
    }
    /**
     * Set HasRenewDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasRenewDetails
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setHasRenewDetails($hasRenewDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasRenewDetails) && !is_bool($hasRenewDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasRenewDetails, true), gettype($hasRenewDetails)), __LINE__);
        }
        if (is_null($hasRenewDetails) || (is_array($hasRenewDetails) && empty($hasRenewDetails))) {
            unset($this->HasRenewDetails);
        } else {
            $this->HasRenewDetails = $hasRenewDetails;
        }
        return $this;
    }
    /**
     * Get IsBonusTicketPriceable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBonusTicketPriceable()
    {
        return isset($this->IsBonusTicketPriceable) ? $this->IsBonusTicketPriceable : null;
    }
    /**
     * Set IsBonusTicketPriceable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBonusTicketPriceable
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setIsBonusTicketPriceable($isBonusTicketPriceable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBonusTicketPriceable) && !is_bool($isBonusTicketPriceable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBonusTicketPriceable, true), gettype($isBonusTicketPriceable)), __LINE__);
        }
        if (is_null($isBonusTicketPriceable) || (is_array($isBonusTicketPriceable) && empty($isBonusTicketPriceable))) {
            unset($this->IsBonusTicketPriceable);
        } else {
            $this->IsBonusTicketPriceable = $isBonusTicketPriceable;
        }
        return $this;
    }
    /**
     * Get IsGift value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGift()
    {
        return isset($this->IsGift) ? $this->IsGift : null;
    }
    /**
     * Set IsGift value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGift
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setIsGift($isGift = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGift) && !is_bool($isGift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGift, true), gettype($isGift)), __LINE__);
        }
        if (is_null($isGift) || (is_array($isGift) && empty($isGift))) {
            unset($this->IsGift);
        } else {
            $this->IsGift = $isGift;
        }
        return $this;
    }
    /**
     * Get IsHospitality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHospitality()
    {
        return isset($this->IsHospitality) ? $this->IsHospitality : null;
    }
    /**
     * Set IsHospitality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHospitality
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setIsHospitality($isHospitality = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHospitality) && !is_bool($isHospitality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHospitality, true), gettype($isHospitality)), __LINE__);
        }
        if (is_null($isHospitality) || (is_array($isHospitality) && empty($isHospitality))) {
            unset($this->IsHospitality);
        } else {
            $this->IsHospitality = $isHospitality;
        }
        return $this;
    }
    /**
     * Get IsPartialEventBased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPartialEventBased()
    {
        return isset($this->IsPartialEventBased) ? $this->IsPartialEventBased : null;
    }
    /**
     * Set IsPartialEventBased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPartialEventBased
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setIsPartialEventBased($isPartialEventBased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartialEventBased) && !is_bool($isPartialEventBased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartialEventBased, true), gettype($isPartialEventBased)), __LINE__);
        }
        if (is_null($isPartialEventBased) || (is_array($isPartialEventBased) && empty($isPartialEventBased))) {
            unset($this->IsPartialEventBased);
        } else {
            $this->IsPartialEventBased = $isPartialEventBased;
        }
        return $this;
    }
    /**
     * Get IsPricedPerSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPricedPerSeries()
    {
        return isset($this->IsPricedPerSeries) ? $this->IsPricedPerSeries : null;
    }
    /**
     * Set IsPricedPerSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPricedPerSeries
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setIsPricedPerSeries($isPricedPerSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPricedPerSeries) && !is_bool($isPricedPerSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPricedPerSeries, true), gettype($isPricedPerSeries)), __LINE__);
        }
        if (is_null($isPricedPerSeries) || (is_array($isPricedPerSeries) && empty($isPricedPerSeries))) {
            unset($this->IsPricedPerSeries);
        } else {
            $this->IsPricedPerSeries = $isPricedPerSeries;
        }
        return $this;
    }
    /**
     * Get IsPrinting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinting()
    {
        return isset($this->IsPrinting) ? $this->IsPrinting : null;
    }
    /**
     * Set IsPrinting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinting
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setIsPrinting($isPrinting = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinting) && !is_bool($isPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinting, true), gettype($isPrinting)), __LINE__);
        }
        if (is_null($isPrinting) || (is_array($isPrinting) && empty($isPrinting))) {
            unset($this->IsPrinting);
        } else {
            $this->IsPrinting = $isPrinting;
        }
        return $this;
    }
    /**
     * Get MasterInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterInstanceId()
    {
        return isset($this->MasterInstanceId) ? $this->MasterInstanceId : null;
    }
    /**
     * Set MasterInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setMasterInstanceId($masterInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($masterInstanceId) && !is_string($masterInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterInstanceId, true), gettype($masterInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($masterInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $masterInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($masterInstanceId, true)), __LINE__);
        }
        if (is_null($masterInstanceId) || (is_array($masterInstanceId) && empty($masterInstanceId))) {
            unset($this->MasterInstanceId);
        } else {
            $this->MasterInstanceId = $masterInstanceId;
        }
        return $this;
    }
    /**
     * Get MaxAllowedFullStackExchanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxAllowedFullStackExchanges()
    {
        return isset($this->MaxAllowedFullStackExchanges) ? $this->MaxAllowedFullStackExchanges : null;
    }
    /**
     * Set MaxAllowedFullStackExchanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxAllowedFullStackExchanges
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setMaxAllowedFullStackExchanges($maxAllowedFullStackExchanges = null)
    {
        // validation for constraint: int
        if (!is_null($maxAllowedFullStackExchanges) && !(is_int($maxAllowedFullStackExchanges) || ctype_digit($maxAllowedFullStackExchanges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAllowedFullStackExchanges, true), gettype($maxAllowedFullStackExchanges)), __LINE__);
        }
        if (is_null($maxAllowedFullStackExchanges) || (is_array($maxAllowedFullStackExchanges) && empty($maxAllowedFullStackExchanges))) {
            unset($this->MaxAllowedFullStackExchanges);
        } else {
            $this->MaxAllowedFullStackExchanges = $maxAllowedFullStackExchanges;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NewAreaGuidForRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewAreaGuidForRenew()
    {
        return isset($this->NewAreaGuidForRenew) ? $this->NewAreaGuidForRenew : null;
    }
    /**
     * Set NewAreaGuidForRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newAreaGuidForRenew
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setNewAreaGuidForRenew($newAreaGuidForRenew = null)
    {
        // validation for constraint: string
        if (!is_null($newAreaGuidForRenew) && !is_string($newAreaGuidForRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newAreaGuidForRenew, true), gettype($newAreaGuidForRenew)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newAreaGuidForRenew) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newAreaGuidForRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newAreaGuidForRenew, true)), __LINE__);
        }
        if (is_null($newAreaGuidForRenew) || (is_array($newAreaGuidForRenew) && empty($newAreaGuidForRenew))) {
            unset($this->NewAreaGuidForRenew);
        } else {
            $this->NewAreaGuidForRenew = $newAreaGuidForRenew;
        }
        return $this;
    }
    /**
     * Get NewPriceTypeIdToRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPriceTypeIdToRenew()
    {
        return isset($this->NewPriceTypeIdToRenew) ? $this->NewPriceTypeIdToRenew : null;
    }
    /**
     * Set NewPriceTypeIdToRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPriceTypeIdToRenew
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setNewPriceTypeIdToRenew($newPriceTypeIdToRenew = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceTypeIdToRenew) && !is_string($newPriceTypeIdToRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceTypeIdToRenew, true), gettype($newPriceTypeIdToRenew)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceTypeIdToRenew) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceTypeIdToRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceTypeIdToRenew, true)), __LINE__);
        }
        if (is_null($newPriceTypeIdToRenew) || (is_array($newPriceTypeIdToRenew) && empty($newPriceTypeIdToRenew))) {
            unset($this->NewPriceTypeIdToRenew);
        } else {
            $this->NewPriceTypeIdToRenew = $newPriceTypeIdToRenew;
        }
        return $this;
    }
    /**
     * Get NewSeatIdForRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewSeatIdForRenew()
    {
        return isset($this->NewSeatIdForRenew) ? $this->NewSeatIdForRenew : null;
    }
    /**
     * Set NewSeatIdForRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newSeatIdForRenew
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setNewSeatIdForRenew($newSeatIdForRenew = null)
    {
        // validation for constraint: int
        if (!is_null($newSeatIdForRenew) && !(is_int($newSeatIdForRenew) || ctype_digit($newSeatIdForRenew))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newSeatIdForRenew, true), gettype($newSeatIdForRenew)), __LINE__);
        }
        if (is_null($newSeatIdForRenew) || (is_array($newSeatIdForRenew) && empty($newSeatIdForRenew))) {
            unset($this->NewSeatIdForRenew);
        } else {
            $this->NewSeatIdForRenew = $newSeatIdForRenew;
        }
        return $this;
    }
    /**
     * Get NormalizedRowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNormalizedRowName()
    {
        return isset($this->NormalizedRowName) ? $this->NormalizedRowName : null;
    }
    /**
     * Set NormalizedRowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $normalizedRowName
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setNormalizedRowName($normalizedRowName = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedRowName) && !is_string($normalizedRowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedRowName, true), gettype($normalizedRowName)), __LINE__);
        }
        if (is_null($normalizedRowName) || (is_array($normalizedRowName) && empty($normalizedRowName))) {
            unset($this->NormalizedRowName);
        } else {
            $this->NormalizedRowName = $normalizedRowName;
        }
        return $this;
    }
    /**
     * Get NormalizedSeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNormalizedSeatName()
    {
        return isset($this->NormalizedSeatName) ? $this->NormalizedSeatName : null;
    }
    /**
     * Set NormalizedSeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $normalizedSeatName
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setNormalizedSeatName($normalizedSeatName = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedSeatName) && !is_string($normalizedSeatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedSeatName, true), gettype($normalizedSeatName)), __LINE__);
        }
        if (is_null($normalizedSeatName) || (is_array($normalizedSeatName) && empty($normalizedSeatName))) {
            unset($this->NormalizedSeatName);
        } else {
            $this->NormalizedSeatName = $normalizedSeatName;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PeriodDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodDescription()
    {
        return isset($this->PeriodDescription) ? $this->PeriodDescription : null;
    }
    /**
     * Set PeriodDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodDescription
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setPeriodDescription($periodDescription = null)
    {
        // validation for constraint: string
        if (!is_null($periodDescription) && !is_string($periodDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodDescription, true), gettype($periodDescription)), __LINE__);
        }
        if (is_null($periodDescription) || (is_array($periodDescription) && empty($periodDescription))) {
            unset($this->PeriodDescription);
        } else {
            $this->PeriodDescription = $periodDescription;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PricingVariationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPricingVariationId()
    {
        return isset($this->PricingVariationId) ? $this->PricingVariationId : null;
    }
    /**
     * Set PricingVariationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pricingVariationId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setPricingVariationId($pricingVariationId = null)
    {
        // validation for constraint: int
        if (!is_null($pricingVariationId) && !(is_int($pricingVariationId) || ctype_digit($pricingVariationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingVariationId, true), gettype($pricingVariationId)), __LINE__);
        }
        if (is_null($pricingVariationId) || (is_array($pricingVariationId) && empty($pricingVariationId))) {
            unset($this->PricingVariationId);
        } else {
            $this->PricingVariationId = $pricingVariationId;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get PrintedNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintedNumber()
    {
        return isset($this->PrintedNumber) ? $this->PrintedNumber : null;
    }
    /**
     * Set PrintedNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printedNumber
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setPrintedNumber($printedNumber = null)
    {
        // validation for constraint: int
        if (!is_null($printedNumber) && !(is_int($printedNumber) || ctype_digit($printedNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printedNumber, true), gettype($printedNumber)), __LINE__);
        }
        if (is_null($printedNumber) || (is_array($printedNumber) && empty($printedNumber))) {
            unset($this->PrintedNumber);
        } else {
            $this->PrintedNumber = $printedNumber;
        }
        return $this;
    }
    /**
     * Get PurchaserClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserClientId()
    {
        return isset($this->PurchaserClientId) ? $this->PurchaserClientId : null;
    }
    /**
     * Set PurchaserClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserClientId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setPurchaserClientId($purchaserClientId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserClientId) && !is_string($purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserClientId, true), gettype($purchaserClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserClientId, true)), __LINE__);
        }
        if (is_null($purchaserClientId) || (is_array($purchaserClientId) && empty($purchaserClientId))) {
            unset($this->PurchaserClientId);
        } else {
            $this->PurchaserClientId = $purchaserClientId;
        }
        return $this;
    }
    /**
     * Get RegularTicketsRemainder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRegularTicketsRemainder()
    {
        return isset($this->RegularTicketsRemainder) ? $this->RegularTicketsRemainder : null;
    }
    /**
     * Set RegularTicketsRemainder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $regularTicketsRemainder
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setRegularTicketsRemainder($regularTicketsRemainder = null)
    {
        // validation for constraint: int
        if (!is_null($regularTicketsRemainder) && !(is_int($regularTicketsRemainder) || ctype_digit($regularTicketsRemainder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regularTicketsRemainder, true), gettype($regularTicketsRemainder)), __LINE__);
        }
        if (is_null($regularTicketsRemainder) || (is_array($regularTicketsRemainder) && empty($regularTicketsRemainder))) {
            unset($this->RegularTicketsRemainder);
        } else {
            $this->RegularTicketsRemainder = $regularTicketsRemainder;
        }
        return $this;
    }
    /**
     * Get RegularTicketsUtilization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRegularTicketsUtilization()
    {
        return isset($this->RegularTicketsUtilization) ? $this->RegularTicketsUtilization : null;
    }
    /**
     * Set RegularTicketsUtilization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $regularTicketsUtilization
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setRegularTicketsUtilization($regularTicketsUtilization = null)
    {
        // validation for constraint: int
        if (!is_null($regularTicketsUtilization) && !(is_int($regularTicketsUtilization) || ctype_digit($regularTicketsUtilization))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regularTicketsUtilization, true), gettype($regularTicketsUtilization)), __LINE__);
        }
        if (is_null($regularTicketsUtilization) || (is_array($regularTicketsUtilization) && empty($regularTicketsUtilization))) {
            unset($this->RegularTicketsUtilization);
        } else {
            $this->RegularTicketsUtilization = $regularTicketsUtilization;
        }
        return $this;
    }
    /**
     * Get RenewOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewOfInstanceId()
    {
        return isset($this->RenewOfInstanceId) ? $this->RenewOfInstanceId : null;
    }
    /**
     * Set RenewOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewOfInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setRenewOfInstanceId($renewOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($renewOfInstanceId) && !is_string($renewOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewOfInstanceId, true), gettype($renewOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewOfInstanceId, true)), __LINE__);
        }
        if (is_null($renewOfInstanceId) || (is_array($renewOfInstanceId) && empty($renewOfInstanceId))) {
            unset($this->RenewOfInstanceId);
        } else {
            $this->RenewOfInstanceId = $renewOfInstanceId;
        }
        return $this;
    }
    /**
     * Get RenewStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewStatus()
    {
        return isset($this->RenewStatus) ? $this->RenewStatus : null;
    }
    /**
     * Set RenewStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionRenewStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriptionRenewStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $renewStatus
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setRenewStatus($renewStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionRenewStatus::valueIsValid($renewStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionRenewStatus', is_array($renewStatus) ? implode(', ', $renewStatus) : var_export($renewStatus, true), implode(', ', \patest\EnumType\SubscriptionRenewStatus::getValidValues())), __LINE__);
        }
        if (is_null($renewStatus) || (is_array($renewStatus) && empty($renewStatus))) {
            unset($this->RenewStatus);
        } else {
            $this->RenewStatus = $renewStatus;
        }
        return $this;
    }
    /**
     * Get RestrictionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionId()
    {
        return isset($this->RestrictionId) ? $this->RestrictionId : null;
    }
    /**
     * Set RestrictionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setRestrictionId($restrictionId = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionId) && !is_string($restrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionId, true), gettype($restrictionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($restrictionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $restrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($restrictionId, true)), __LINE__);
        }
        if (is_null($restrictionId) || (is_array($restrictionId) && empty($restrictionId))) {
            unset($this->RestrictionId);
        } else {
            $this->RestrictionId = $restrictionId;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeatInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_SeatInfo|null
     */
    public function getSeatInfo()
    {
        return isset($this->SeatInfo) ? $this->SeatInfo : null;
    }
    /**
     * Set SeatInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_SeatInfo $seatInfo
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSeatInfo(\patest\StructType\Ticketing_SeatInfo $seatInfo = null)
    {
        if (is_null($seatInfo) || (is_array($seatInfo) && empty($seatInfo))) {
            unset($this->SeatInfo);
        } else {
            $this->SeatInfo = $seatInfo;
        }
        return $this;
    }
    /**
     * Get SeatingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingType()
    {
        return isset($this->SeatingType) ? $this->SeatingType : null;
    }
    /**
     * Set SeatingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatingType
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSeatingType($seatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($seatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($seatingType) ? implode(', ', $seatingType) : var_export($seatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        if (is_null($seatingType) || (is_array($seatingType) && empty($seatingType))) {
            unset($this->SeatingType);
        } else {
            $this->SeatingType = $seatingType;
        }
        return $this;
    }
    /**
     * Get SeatLocationDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatLocationDescription()
    {
        return isset($this->SeatLocationDescription) ? $this->SeatLocationDescription : null;
    }
    /**
     * Set SeatLocationDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatLocationDescription
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSeatLocationDescription($seatLocationDescription = null)
    {
        // validation for constraint: string
        if (!is_null($seatLocationDescription) && !is_string($seatLocationDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatLocationDescription, true), gettype($seatLocationDescription)), __LINE__);
        }
        if (is_null($seatLocationDescription) || (is_array($seatLocationDescription) && empty($seatLocationDescription))) {
            unset($this->SeatLocationDescription);
        } else {
            $this->SeatLocationDescription = $seatLocationDescription;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorGlobalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorGlobalName()
    {
        return isset($this->SectorGlobalName) ? $this->SectorGlobalName : null;
    }
    /**
     * Set SectorGlobalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorGlobalName
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSectorGlobalName(\patest\StructType\GlobalString $sectorGlobalName = null)
    {
        if (is_null($sectorGlobalName) || (is_array($sectorGlobalName) && empty($sectorGlobalName))) {
            unset($this->SectorGlobalName);
        } else {
            $this->SectorGlobalName = $sectorGlobalName;
        }
        return $this;
    }
    /**
     * Get SeriesEventCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeriesEventCount()
    {
        return isset($this->SeriesEventCount) ? $this->SeriesEventCount : null;
    }
    /**
     * Set SeriesEventCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seriesEventCount
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSeriesEventCount($seriesEventCount = null)
    {
        // validation for constraint: int
        if (!is_null($seriesEventCount) && !(is_int($seriesEventCount) || ctype_digit($seriesEventCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seriesEventCount, true), gettype($seriesEventCount)), __LINE__);
        }
        if (is_null($seriesEventCount) || (is_array($seriesEventCount) && empty($seriesEventCount))) {
            unset($this->SeriesEventCount);
        } else {
            $this->SeriesEventCount = $seriesEventCount;
        }
        return $this;
    }
    /**
     * Get SeriesGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesGroupId()
    {
        return isset($this->SeriesGroupId) ? $this->SeriesGroupId : null;
    }
    /**
     * Set SeriesGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesGroupId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSeriesGroupId($seriesGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesGroupId) && !is_string($seriesGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesGroupId, true), gettype($seriesGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesGroupId, true)), __LINE__);
        }
        if (is_null($seriesGroupId) || (is_array($seriesGroupId) && empty($seriesGroupId))) {
            unset($this->SeriesGroupId);
        } else {
            $this->SeriesGroupId = $seriesGroupId;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $seriesName
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSeriesName(\patest\StructType\GlobalString $seriesName = null)
    {
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get SeriesSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesSchemeId()
    {
        return isset($this->SeriesSchemeId) ? $this->SeriesSchemeId : null;
    }
    /**
     * Set SeriesSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesSchemeId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSeriesSchemeId($seriesSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesSchemeId) && !is_string($seriesSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesSchemeId, true), gettype($seriesSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesSchemeId, true)), __LINE__);
        }
        if (is_null($seriesSchemeId) || (is_array($seriesSchemeId) && empty($seriesSchemeId))) {
            unset($this->SeriesSchemeId);
        } else {
            $this->SeriesSchemeId = $seriesSchemeId;
        }
        return $this;
    }
    /**
     * Get SingleEventPricingDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSingleEventPricingDetails()
    {
        return isset($this->SingleEventPricingDetails) ? $this->SingleEventPricingDetails : null;
    }
    /**
     * Set SingleEventPricingDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $singleEventPricingDetails
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSingleEventPricingDetails($singleEventPricingDetails = null)
    {
        // validation for constraint: string
        if (!is_null($singleEventPricingDetails) && !is_string($singleEventPricingDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleEventPricingDetails, true), gettype($singleEventPricingDetails)), __LINE__);
        }
        if (is_null($singleEventPricingDetails) || (is_array($singleEventPricingDetails) && empty($singleEventPricingDetails))) {
            unset($this->SingleEventPricingDetails);
        } else {
            $this->SingleEventPricingDetails = $singleEventPricingDetails;
        }
        return $this;
    }
    /**
     * Get SoldInRegularTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSoldInRegularTransaction()
    {
        return isset($this->SoldInRegularTransaction) ? $this->SoldInRegularTransaction : null;
    }
    /**
     * Set SoldInRegularTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $soldInRegularTransaction
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSoldInRegularTransaction($soldInRegularTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($soldInRegularTransaction) && !is_bool($soldInRegularTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($soldInRegularTransaction, true), gettype($soldInRegularTransaction)), __LINE__);
        }
        if (is_null($soldInRegularTransaction) || (is_array($soldInRegularTransaction) && empty($soldInRegularTransaction))) {
            unset($this->SoldInRegularTransaction);
        } else {
            $this->SoldInRegularTransaction = $soldInRegularTransaction;
        }
        return $this;
    }
    /**
     * Get StandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getStandName()
    {
        return isset($this->StandName) ? $this->StandName : null;
    }
    /**
     * Set StandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $standName
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setStandName(\patest\StructType\GlobalString $standName = null)
    {
        if (is_null($standName) || (is_array($standName) && empty($standName))) {
            unset($this->StandName);
        } else {
            $this->StandName = $standName;
        }
        return $this;
    }
    /**
     * Get StartDateOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDateOverride()
    {
        return isset($this->StartDateOverride) ? $this->StartDateOverride : null;
    }
    /**
     * Set StartDateOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDateOverride
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setStartDateOverride($startDateOverride = null)
    {
        // validation for constraint: string
        if (!is_null($startDateOverride) && !is_string($startDateOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateOverride, true), gettype($startDateOverride)), __LINE__);
        }
        if (is_null($startDateOverride) || (is_array($startDateOverride) && empty($startDateOverride))) {
            unset($this->StartDateOverride);
        } else {
            $this->StartDateOverride = $startDateOverride;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriptionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\SubscriptionStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SubscriptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return isset($this->SubscriptionId) ? $this->SubscriptionId : null;
    }
    /**
     * Set SubscriptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionId, true)), __LINE__);
        }
        if (is_null($subscriptionId) || (is_array($subscriptionId) && empty($subscriptionId))) {
            unset($this->SubscriptionId);
        } else {
            $this->SubscriptionId = $subscriptionId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get SubscriptionTransactionItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionTransactionItemId()
    {
        return isset($this->SubscriptionTransactionItemId) ? $this->SubscriptionTransactionItemId : null;
    }
    /**
     * Set SubscriptionTransactionItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionTransactionItemId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSubscriptionTransactionItemId($subscriptionTransactionItemId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionTransactionItemId) && !is_string($subscriptionTransactionItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionTransactionItemId, true), gettype($subscriptionTransactionItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionTransactionItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionTransactionItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionTransactionItemId, true)), __LINE__);
        }
        if (is_null($subscriptionTransactionItemId) || (is_array($subscriptionTransactionItemId) && empty($subscriptionTransactionItemId))) {
            unset($this->SubscriptionTransactionItemId);
        } else {
            $this->SubscriptionTransactionItemId = $subscriptionTransactionItemId;
        }
        return $this;
    }
    /**
     * Get SubsidizedByAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizedByAccountId()
    {
        return isset($this->SubsidizedByAccountId) ? $this->SubsidizedByAccountId : null;
    }
    /**
     * Set SubsidizedByAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizedByAccountId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setSubsidizedByAccountId($subsidizedByAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizedByAccountId) && !is_string($subsidizedByAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizedByAccountId, true), gettype($subsidizedByAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subsidizedByAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subsidizedByAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subsidizedByAccountId, true)), __LINE__);
        }
        if (is_null($subsidizedByAccountId) || (is_array($subsidizedByAccountId) && empty($subsidizedByAccountId))) {
            unset($this->SubsidizedByAccountId);
        } else {
            $this->SubsidizedByAccountId = $subsidizedByAccountId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TurnstileIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnstileIds()
    {
        return isset($this->TurnstileIds) ? $this->TurnstileIds : null;
    }
    /**
     * Set TurnstileIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnstileIds
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setTurnstileIds($turnstileIds = null)
    {
        // validation for constraint: string
        if (!is_null($turnstileIds) && !is_string($turnstileIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnstileIds, true), gettype($turnstileIds)), __LINE__);
        }
        if (is_null($turnstileIds) || (is_array($turnstileIds) && empty($turnstileIds))) {
            unset($this->TurnstileIds);
        } else {
            $this->TurnstileIds = $turnstileIds;
        }
        return $this;
    }
    /**
     * Get UpdateInstanceIdChain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateInstanceIdChain()
    {
        return isset($this->UpdateInstanceIdChain) ? $this->UpdateInstanceIdChain : null;
    }
    /**
     * Set UpdateInstanceIdChain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateInstanceIdChain
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setUpdateInstanceIdChain($updateInstanceIdChain = null)
    {
        // validation for constraint: string
        if (!is_null($updateInstanceIdChain) && !is_string($updateInstanceIdChain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateInstanceIdChain, true), gettype($updateInstanceIdChain)), __LINE__);
        }
        if (is_null($updateInstanceIdChain) || (is_array($updateInstanceIdChain) && empty($updateInstanceIdChain))) {
            unset($this->UpdateInstanceIdChain);
        } else {
            $this->UpdateInstanceIdChain = $updateInstanceIdChain;
        }
        return $this;
    }
    /**
     * Get UpdateOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateOfInstanceId()
    {
        return isset($this->UpdateOfInstanceId) ? $this->UpdateOfInstanceId : null;
    }
    /**
     * Set UpdateOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateOfInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setUpdateOfInstanceId($updateOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($updateOfInstanceId) && !is_string($updateOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateOfInstanceId, true), gettype($updateOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($updateOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $updateOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($updateOfInstanceId, true)), __LINE__);
        }
        if (is_null($updateOfInstanceId) || (is_array($updateOfInstanceId) && empty($updateOfInstanceId))) {
            unset($this->UpdateOfInstanceId);
        } else {
            $this->UpdateOfInstanceId = $updateOfInstanceId;
        }
        return $this;
    }
    /**
     * Get UsedFullStackExchanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUsedFullStackExchanges()
    {
        return isset($this->UsedFullStackExchanges) ? $this->UsedFullStackExchanges : null;
    }
    /**
     * Set UsedFullStackExchanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $usedFullStackExchanges
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setUsedFullStackExchanges($usedFullStackExchanges = null)
    {
        // validation for constraint: int
        if (!is_null($usedFullStackExchanges) && !(is_int($usedFullStackExchanges) || ctype_digit($usedFullStackExchanges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($usedFullStackExchanges, true), gettype($usedFullStackExchanges)), __LINE__);
        }
        if (is_null($usedFullStackExchanges) || (is_array($usedFullStackExchanges) && empty($usedFullStackExchanges))) {
            unset($this->UsedFullStackExchanges);
        } else {
            $this->UsedFullStackExchanges = $usedFullStackExchanges;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
    /**
     * Get WaitMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWaitMode()
    {
        return isset($this->WaitMode) ? $this->WaitMode : null;
    }
    /**
     * Set WaitMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketWaitMode::valueIsValid()
     * @uses \patest\EnumType\TicketWaitMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waitMode
     * @return \patest\StructType\Ticketing_SubscriptionInstance
     */
    public function setWaitMode($waitMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketWaitMode::valueIsValid($waitMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketWaitMode', is_array($waitMode) ? implode(', ', $waitMode) : var_export($waitMode, true), implode(', ', \patest\EnumType\TicketWaitMode::getValidValues())), __LINE__);
        }
        if (is_null($waitMode) || (is_array($waitMode) && empty($waitMode))) {
            unset($this->WaitMode);
        } else {
            $this->WaitMode = $waitMode;
        }
        return $this;
    }
}
