<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SubscriptionBasketItemPrivateState StructType
 * @subpackage Structs
 */
class Ticketing_SubscriptionBasketItemPrivateState extends AnyEntity
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The BonusEventCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BonusEventCount;
    /**
     * The BonusEventUtilizationCountAfterReturn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BonusEventUtilizationCountAfterReturn;
    /**
     * The BucketsInfoAtPurchase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BucketsInfoAtPurchase;
    /**
     * The CommitLog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitLog;
    /**
     * The CurrentSubscriptionInstanceStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentSubscriptionInstanceStatus;
    /**
     * The EndDateOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDateOverride;
    /**
     * The EventCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventCount;
    /**
     * The EventUtilizationCountAfterReturn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventUtilizationCountAfterReturn;
    /**
     * The ExchangeReturnedBasketItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExchangeReturnedBasketItemId;
    /**
     * The ExtensionOfSubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtensionOfSubscriptionInstanceId;
    /**
     * The ForwardedTicketsPricingDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForwardedTicketsPricingDetails;
    /**
     * The IsAutoRenewRequested
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoRenewRequested;
    /**
     * The IsBonusTicketPriceable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBonusTicketPriceable;
    /**
     * The IsEventCountChosenManually
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEventCountChosenManually;
    /**
     * The IsHospitality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHospitality;
    /**
     * The IsPartialEventBased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPartialEventBased;
    /**
     * The IsPriceCalculated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPriceCalculated;
    /**
     * The IsPricedPerSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPricedPerSeries;
    /**
     * The MasterInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MasterInstanceId;
    /**
     * The MaxAllowedFullStackExchanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxAllowedFullStackExchanges;
    /**
     * The PartOfSeriesGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PartOfSeriesGroupId;
    /**
     * The PrevSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrevSeriesId;
    /**
     * The PrevSubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrevSubscriptionInstanceId;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The ReportedPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReportedPriceTypeId;
    /**
     * The RestrictionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RestrictionId;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeatAllocHandle
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatAllocHandle;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatingType;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SeatReturnHandle
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatReturnHandle;
    /**
     * The SeatTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatTypeId;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SingleEventPricingDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SingleEventPricingDetails;
    /**
     * The SkipAutoRenewValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipAutoRenewValidation;
    /**
     * The StandId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StandId;
    /**
     * The StandName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StandName;
    /**
     * The StartDateOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDateOverride;
    /**
     * The SubscriptionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionId;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The TicketSchemesToEnroll
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_AddSubscriptionTicketSchemeDetails
     */
    public $TicketSchemesToEnroll;
    /**
     * The UsedFullStackExchanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UsedFullStackExchanges;
    /**
     * The WaitMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WaitMode;
    /**
     * Constructor method for Ticketing.SubscriptionBasketItemPrivateState
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setAction()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setAreaId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setAreaName()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setBonusEventCount()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setBonusEventUtilizationCountAfterReturn()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setBucketsInfoAtPurchase()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setCommitLog()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setCurrentSubscriptionInstanceStatus()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setEndDateOverride()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setEventCount()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setEventUtilizationCountAfterReturn()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setExchangeReturnedBasketItemId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setExtensionOfSubscriptionInstanceId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setForwardedTicketsPricingDetails()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setIsAutoRenewRequested()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setIsBonusTicketPriceable()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setIsEventCountChosenManually()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setIsHospitality()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setIsPartialEventBased()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setIsPriceCalculated()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setIsPricedPerSeries()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setMasterInstanceId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setMaxAllowedFullStackExchanges()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setPartOfSeriesGroupId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setPrevSeriesId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setPrevSubscriptionInstanceId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setPriceLevelId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setPrintCount()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setReportedPriceTypeId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setRestrictionId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setRowName()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSeatAllocHandle()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSeatIdInAreaMap()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSeatingType()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSeatName()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSeatReturnHandle()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSeatTypeId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSectorName()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSeriesId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSingleEventPricingDetails()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSkipAutoRenewValidation()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setStandId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setStandName()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setStartDateOverride()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSubscriptionId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSubscriptionInstanceId()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setSubscriptionNumber()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setTicketSchemesToEnroll()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setUsedFullStackExchanges()
     * @uses Ticketing_SubscriptionBasketItemPrivateState::setWaitMode()
     * @param string $action
     * @param string $areaId
     * @param string $areaName
     * @param int $bonusEventCount
     * @param int $bonusEventUtilizationCountAfterReturn
     * @param string $bucketsInfoAtPurchase
     * @param string $commitLog
     * @param string $currentSubscriptionInstanceStatus
     * @param string $endDateOverride
     * @param int $eventCount
     * @param int $eventUtilizationCountAfterReturn
     * @param int $exchangeReturnedBasketItemId
     * @param string $extensionOfSubscriptionInstanceId
     * @param string $forwardedTicketsPricingDetails
     * @param bool $isAutoRenewRequested
     * @param bool $isBonusTicketPriceable
     * @param bool $isEventCountChosenManually
     * @param bool $isHospitality
     * @param bool $isPartialEventBased
     * @param bool $isPriceCalculated
     * @param bool $isPricedPerSeries
     * @param string $masterInstanceId
     * @param int $maxAllowedFullStackExchanges
     * @param string $partOfSeriesGroupId
     * @param string $prevSeriesId
     * @param string $prevSubscriptionInstanceId
     * @param string $priceLevelId
     * @param int $printCount
     * @param string $reportedPriceTypeId
     * @param string $restrictionId
     * @param string $rowName
     * @param string $seatAllocHandle
     * @param int $seatIdInAreaMap
     * @param string $seatingType
     * @param string $seatName
     * @param string $seatReturnHandle
     * @param string $seatTypeId
     * @param string $sectorName
     * @param string $seriesId
     * @param string $singleEventPricingDetails
     * @param bool $skipAutoRenewValidation
     * @param string $standId
     * @param string $standName
     * @param string $startDateOverride
     * @param string $subscriptionId
     * @param string $subscriptionInstanceId
     * @param string $subscriptionNumber
     * @param \patest\StructType\RecordSetOfTicketing_AddSubscriptionTicketSchemeDetails $ticketSchemesToEnroll
     * @param int $usedFullStackExchanges
     * @param string $waitMode
     */
    public function __construct($action = null, $areaId = null, $areaName = null, $bonusEventCount = null, $bonusEventUtilizationCountAfterReturn = null, $bucketsInfoAtPurchase = null, $commitLog = null, $currentSubscriptionInstanceStatus = null, $endDateOverride = null, $eventCount = null, $eventUtilizationCountAfterReturn = null, $exchangeReturnedBasketItemId = null, $extensionOfSubscriptionInstanceId = null, $forwardedTicketsPricingDetails = null, $isAutoRenewRequested = null, $isBonusTicketPriceable = null, $isEventCountChosenManually = null, $isHospitality = null, $isPartialEventBased = null, $isPriceCalculated = null, $isPricedPerSeries = null, $masterInstanceId = null, $maxAllowedFullStackExchanges = null, $partOfSeriesGroupId = null, $prevSeriesId = null, $prevSubscriptionInstanceId = null, $priceLevelId = null, $printCount = null, $reportedPriceTypeId = null, $restrictionId = null, $rowName = null, $seatAllocHandle = null, $seatIdInAreaMap = null, $seatingType = null, $seatName = null, $seatReturnHandle = null, $seatTypeId = null, $sectorName = null, $seriesId = null, $singleEventPricingDetails = null, $skipAutoRenewValidation = null, $standId = null, $standName = null, $startDateOverride = null, $subscriptionId = null, $subscriptionInstanceId = null, $subscriptionNumber = null, \patest\StructType\RecordSetOfTicketing_AddSubscriptionTicketSchemeDetails $ticketSchemesToEnroll = null, $usedFullStackExchanges = null, $waitMode = null)
    {
        $this
            ->setAction($action)
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setBonusEventCount($bonusEventCount)
            ->setBonusEventUtilizationCountAfterReturn($bonusEventUtilizationCountAfterReturn)
            ->setBucketsInfoAtPurchase($bucketsInfoAtPurchase)
            ->setCommitLog($commitLog)
            ->setCurrentSubscriptionInstanceStatus($currentSubscriptionInstanceStatus)
            ->setEndDateOverride($endDateOverride)
            ->setEventCount($eventCount)
            ->setEventUtilizationCountAfterReturn($eventUtilizationCountAfterReturn)
            ->setExchangeReturnedBasketItemId($exchangeReturnedBasketItemId)
            ->setExtensionOfSubscriptionInstanceId($extensionOfSubscriptionInstanceId)
            ->setForwardedTicketsPricingDetails($forwardedTicketsPricingDetails)
            ->setIsAutoRenewRequested($isAutoRenewRequested)
            ->setIsBonusTicketPriceable($isBonusTicketPriceable)
            ->setIsEventCountChosenManually($isEventCountChosenManually)
            ->setIsHospitality($isHospitality)
            ->setIsPartialEventBased($isPartialEventBased)
            ->setIsPriceCalculated($isPriceCalculated)
            ->setIsPricedPerSeries($isPricedPerSeries)
            ->setMasterInstanceId($masterInstanceId)
            ->setMaxAllowedFullStackExchanges($maxAllowedFullStackExchanges)
            ->setPartOfSeriesGroupId($partOfSeriesGroupId)
            ->setPrevSeriesId($prevSeriesId)
            ->setPrevSubscriptionInstanceId($prevSubscriptionInstanceId)
            ->setPriceLevelId($priceLevelId)
            ->setPrintCount($printCount)
            ->setReportedPriceTypeId($reportedPriceTypeId)
            ->setRestrictionId($restrictionId)
            ->setRowName($rowName)
            ->setSeatAllocHandle($seatAllocHandle)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatingType($seatingType)
            ->setSeatName($seatName)
            ->setSeatReturnHandle($seatReturnHandle)
            ->setSeatTypeId($seatTypeId)
            ->setSectorName($sectorName)
            ->setSeriesId($seriesId)
            ->setSingleEventPricingDetails($singleEventPricingDetails)
            ->setSkipAutoRenewValidation($skipAutoRenewValidation)
            ->setStandId($standId)
            ->setStandName($standName)
            ->setStartDateOverride($startDateOverride)
            ->setSubscriptionId($subscriptionId)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setTicketSchemesToEnroll($ticketSchemesToEnroll)
            ->setUsedFullStackExchanges($usedFullStackExchanges)
            ->setWaitMode($waitMode);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionAction::valueIsValid()
     * @uses \patest\EnumType\SubscriptionAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\SubscriptionAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get BonusEventCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBonusEventCount()
    {
        return isset($this->BonusEventCount) ? $this->BonusEventCount : null;
    }
    /**
     * Set BonusEventCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bonusEventCount
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setBonusEventCount($bonusEventCount = null)
    {
        // validation for constraint: int
        if (!is_null($bonusEventCount) && !(is_int($bonusEventCount) || ctype_digit($bonusEventCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bonusEventCount, true), gettype($bonusEventCount)), __LINE__);
        }
        if (is_null($bonusEventCount) || (is_array($bonusEventCount) && empty($bonusEventCount))) {
            unset($this->BonusEventCount);
        } else {
            $this->BonusEventCount = $bonusEventCount;
        }
        return $this;
    }
    /**
     * Get BonusEventUtilizationCountAfterReturn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBonusEventUtilizationCountAfterReturn()
    {
        return isset($this->BonusEventUtilizationCountAfterReturn) ? $this->BonusEventUtilizationCountAfterReturn : null;
    }
    /**
     * Set BonusEventUtilizationCountAfterReturn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bonusEventUtilizationCountAfterReturn
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setBonusEventUtilizationCountAfterReturn($bonusEventUtilizationCountAfterReturn = null)
    {
        // validation for constraint: int
        if (!is_null($bonusEventUtilizationCountAfterReturn) && !(is_int($bonusEventUtilizationCountAfterReturn) || ctype_digit($bonusEventUtilizationCountAfterReturn))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bonusEventUtilizationCountAfterReturn, true), gettype($bonusEventUtilizationCountAfterReturn)), __LINE__);
        }
        if (is_null($bonusEventUtilizationCountAfterReturn) || (is_array($bonusEventUtilizationCountAfterReturn) && empty($bonusEventUtilizationCountAfterReturn))) {
            unset($this->BonusEventUtilizationCountAfterReturn);
        } else {
            $this->BonusEventUtilizationCountAfterReturn = $bonusEventUtilizationCountAfterReturn;
        }
        return $this;
    }
    /**
     * Get BucketsInfoAtPurchase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBucketsInfoAtPurchase()
    {
        return isset($this->BucketsInfoAtPurchase) ? $this->BucketsInfoAtPurchase : null;
    }
    /**
     * Set BucketsInfoAtPurchase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bucketsInfoAtPurchase
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setBucketsInfoAtPurchase($bucketsInfoAtPurchase = null)
    {
        // validation for constraint: string
        if (!is_null($bucketsInfoAtPurchase) && !is_string($bucketsInfoAtPurchase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bucketsInfoAtPurchase, true), gettype($bucketsInfoAtPurchase)), __LINE__);
        }
        if (is_null($bucketsInfoAtPurchase) || (is_array($bucketsInfoAtPurchase) && empty($bucketsInfoAtPurchase))) {
            unset($this->BucketsInfoAtPurchase);
        } else {
            $this->BucketsInfoAtPurchase = $bucketsInfoAtPurchase;
        }
        return $this;
    }
    /**
     * Get CommitLog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitLog()
    {
        return isset($this->CommitLog) ? $this->CommitLog : null;
    }
    /**
     * Set CommitLog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitLog
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setCommitLog($commitLog = null)
    {
        // validation for constraint: string
        if (!is_null($commitLog) && !is_string($commitLog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitLog, true), gettype($commitLog)), __LINE__);
        }
        if (is_null($commitLog) || (is_array($commitLog) && empty($commitLog))) {
            unset($this->CommitLog);
        } else {
            $this->CommitLog = $commitLog;
        }
        return $this;
    }
    /**
     * Get CurrentSubscriptionInstanceStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentSubscriptionInstanceStatus()
    {
        return isset($this->CurrentSubscriptionInstanceStatus) ? $this->CurrentSubscriptionInstanceStatus : null;
    }
    /**
     * Set CurrentSubscriptionInstanceStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriptionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currentSubscriptionInstanceStatus
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setCurrentSubscriptionInstanceStatus($currentSubscriptionInstanceStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionStatus::valueIsValid($currentSubscriptionInstanceStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionStatus', is_array($currentSubscriptionInstanceStatus) ? implode(', ', $currentSubscriptionInstanceStatus) : var_export($currentSubscriptionInstanceStatus, true), implode(', ', \patest\EnumType\SubscriptionStatus::getValidValues())), __LINE__);
        }
        if (is_null($currentSubscriptionInstanceStatus) || (is_array($currentSubscriptionInstanceStatus) && empty($currentSubscriptionInstanceStatus))) {
            unset($this->CurrentSubscriptionInstanceStatus);
        } else {
            $this->CurrentSubscriptionInstanceStatus = $currentSubscriptionInstanceStatus;
        }
        return $this;
    }
    /**
     * Get EndDateOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDateOverride()
    {
        return isset($this->EndDateOverride) ? $this->EndDateOverride : null;
    }
    /**
     * Set EndDateOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDateOverride
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setEndDateOverride($endDateOverride = null)
    {
        // validation for constraint: string
        if (!is_null($endDateOverride) && !is_string($endDateOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateOverride, true), gettype($endDateOverride)), __LINE__);
        }
        if (is_null($endDateOverride) || (is_array($endDateOverride) && empty($endDateOverride))) {
            unset($this->EndDateOverride);
        } else {
            $this->EndDateOverride = $endDateOverride;
        }
        return $this;
    }
    /**
     * Get EventCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventCount()
    {
        return isset($this->EventCount) ? $this->EventCount : null;
    }
    /**
     * Set EventCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventCount
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setEventCount($eventCount = null)
    {
        // validation for constraint: int
        if (!is_null($eventCount) && !(is_int($eventCount) || ctype_digit($eventCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventCount, true), gettype($eventCount)), __LINE__);
        }
        if (is_null($eventCount) || (is_array($eventCount) && empty($eventCount))) {
            unset($this->EventCount);
        } else {
            $this->EventCount = $eventCount;
        }
        return $this;
    }
    /**
     * Get EventUtilizationCountAfterReturn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventUtilizationCountAfterReturn()
    {
        return isset($this->EventUtilizationCountAfterReturn) ? $this->EventUtilizationCountAfterReturn : null;
    }
    /**
     * Set EventUtilizationCountAfterReturn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventUtilizationCountAfterReturn
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setEventUtilizationCountAfterReturn($eventUtilizationCountAfterReturn = null)
    {
        // validation for constraint: int
        if (!is_null($eventUtilizationCountAfterReturn) && !(is_int($eventUtilizationCountAfterReturn) || ctype_digit($eventUtilizationCountAfterReturn))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventUtilizationCountAfterReturn, true), gettype($eventUtilizationCountAfterReturn)), __LINE__);
        }
        if (is_null($eventUtilizationCountAfterReturn) || (is_array($eventUtilizationCountAfterReturn) && empty($eventUtilizationCountAfterReturn))) {
            unset($this->EventUtilizationCountAfterReturn);
        } else {
            $this->EventUtilizationCountAfterReturn = $eventUtilizationCountAfterReturn;
        }
        return $this;
    }
    /**
     * Get ExchangeReturnedBasketItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExchangeReturnedBasketItemId()
    {
        return isset($this->ExchangeReturnedBasketItemId) ? $this->ExchangeReturnedBasketItemId : null;
    }
    /**
     * Set ExchangeReturnedBasketItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $exchangeReturnedBasketItemId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setExchangeReturnedBasketItemId($exchangeReturnedBasketItemId = null)
    {
        // validation for constraint: int
        if (!is_null($exchangeReturnedBasketItemId) && !(is_int($exchangeReturnedBasketItemId) || ctype_digit($exchangeReturnedBasketItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exchangeReturnedBasketItemId, true), gettype($exchangeReturnedBasketItemId)), __LINE__);
        }
        if (is_null($exchangeReturnedBasketItemId) || (is_array($exchangeReturnedBasketItemId) && empty($exchangeReturnedBasketItemId))) {
            unset($this->ExchangeReturnedBasketItemId);
        } else {
            $this->ExchangeReturnedBasketItemId = $exchangeReturnedBasketItemId;
        }
        return $this;
    }
    /**
     * Get ExtensionOfSubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtensionOfSubscriptionInstanceId()
    {
        return isset($this->ExtensionOfSubscriptionInstanceId) ? $this->ExtensionOfSubscriptionInstanceId : null;
    }
    /**
     * Set ExtensionOfSubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extensionOfSubscriptionInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setExtensionOfSubscriptionInstanceId($extensionOfSubscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($extensionOfSubscriptionInstanceId) && !is_string($extensionOfSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extensionOfSubscriptionInstanceId, true), gettype($extensionOfSubscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extensionOfSubscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extensionOfSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extensionOfSubscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($extensionOfSubscriptionInstanceId) || (is_array($extensionOfSubscriptionInstanceId) && empty($extensionOfSubscriptionInstanceId))) {
            unset($this->ExtensionOfSubscriptionInstanceId);
        } else {
            $this->ExtensionOfSubscriptionInstanceId = $extensionOfSubscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get ForwardedTicketsPricingDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForwardedTicketsPricingDetails()
    {
        return isset($this->ForwardedTicketsPricingDetails) ? $this->ForwardedTicketsPricingDetails : null;
    }
    /**
     * Set ForwardedTicketsPricingDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forwardedTicketsPricingDetails
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setForwardedTicketsPricingDetails($forwardedTicketsPricingDetails = null)
    {
        // validation for constraint: string
        if (!is_null($forwardedTicketsPricingDetails) && !is_string($forwardedTicketsPricingDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forwardedTicketsPricingDetails, true), gettype($forwardedTicketsPricingDetails)), __LINE__);
        }
        if (is_null($forwardedTicketsPricingDetails) || (is_array($forwardedTicketsPricingDetails) && empty($forwardedTicketsPricingDetails))) {
            unset($this->ForwardedTicketsPricingDetails);
        } else {
            $this->ForwardedTicketsPricingDetails = $forwardedTicketsPricingDetails;
        }
        return $this;
    }
    /**
     * Get IsAutoRenewRequested value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoRenewRequested()
    {
        return isset($this->IsAutoRenewRequested) ? $this->IsAutoRenewRequested : null;
    }
    /**
     * Set IsAutoRenewRequested value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoRenewRequested
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setIsAutoRenewRequested($isAutoRenewRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoRenewRequested) && !is_bool($isAutoRenewRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoRenewRequested, true), gettype($isAutoRenewRequested)), __LINE__);
        }
        if (is_null($isAutoRenewRequested) || (is_array($isAutoRenewRequested) && empty($isAutoRenewRequested))) {
            unset($this->IsAutoRenewRequested);
        } else {
            $this->IsAutoRenewRequested = $isAutoRenewRequested;
        }
        return $this;
    }
    /**
     * Get IsBonusTicketPriceable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBonusTicketPriceable()
    {
        return isset($this->IsBonusTicketPriceable) ? $this->IsBonusTicketPriceable : null;
    }
    /**
     * Set IsBonusTicketPriceable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBonusTicketPriceable
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setIsBonusTicketPriceable($isBonusTicketPriceable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBonusTicketPriceable) && !is_bool($isBonusTicketPriceable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBonusTicketPriceable, true), gettype($isBonusTicketPriceable)), __LINE__);
        }
        if (is_null($isBonusTicketPriceable) || (is_array($isBonusTicketPriceable) && empty($isBonusTicketPriceable))) {
            unset($this->IsBonusTicketPriceable);
        } else {
            $this->IsBonusTicketPriceable = $isBonusTicketPriceable;
        }
        return $this;
    }
    /**
     * Get IsEventCountChosenManually value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEventCountChosenManually()
    {
        return isset($this->IsEventCountChosenManually) ? $this->IsEventCountChosenManually : null;
    }
    /**
     * Set IsEventCountChosenManually value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEventCountChosenManually
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setIsEventCountChosenManually($isEventCountChosenManually = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEventCountChosenManually) && !is_bool($isEventCountChosenManually)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEventCountChosenManually, true), gettype($isEventCountChosenManually)), __LINE__);
        }
        if (is_null($isEventCountChosenManually) || (is_array($isEventCountChosenManually) && empty($isEventCountChosenManually))) {
            unset($this->IsEventCountChosenManually);
        } else {
            $this->IsEventCountChosenManually = $isEventCountChosenManually;
        }
        return $this;
    }
    /**
     * Get IsHospitality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHospitality()
    {
        return isset($this->IsHospitality) ? $this->IsHospitality : null;
    }
    /**
     * Set IsHospitality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHospitality
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setIsHospitality($isHospitality = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHospitality) && !is_bool($isHospitality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHospitality, true), gettype($isHospitality)), __LINE__);
        }
        if (is_null($isHospitality) || (is_array($isHospitality) && empty($isHospitality))) {
            unset($this->IsHospitality);
        } else {
            $this->IsHospitality = $isHospitality;
        }
        return $this;
    }
    /**
     * Get IsPartialEventBased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPartialEventBased()
    {
        return isset($this->IsPartialEventBased) ? $this->IsPartialEventBased : null;
    }
    /**
     * Set IsPartialEventBased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPartialEventBased
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setIsPartialEventBased($isPartialEventBased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartialEventBased) && !is_bool($isPartialEventBased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartialEventBased, true), gettype($isPartialEventBased)), __LINE__);
        }
        if (is_null($isPartialEventBased) || (is_array($isPartialEventBased) && empty($isPartialEventBased))) {
            unset($this->IsPartialEventBased);
        } else {
            $this->IsPartialEventBased = $isPartialEventBased;
        }
        return $this;
    }
    /**
     * Get IsPriceCalculated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPriceCalculated()
    {
        return isset($this->IsPriceCalculated) ? $this->IsPriceCalculated : null;
    }
    /**
     * Set IsPriceCalculated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPriceCalculated
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setIsPriceCalculated($isPriceCalculated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPriceCalculated) && !is_bool($isPriceCalculated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPriceCalculated, true), gettype($isPriceCalculated)), __LINE__);
        }
        if (is_null($isPriceCalculated) || (is_array($isPriceCalculated) && empty($isPriceCalculated))) {
            unset($this->IsPriceCalculated);
        } else {
            $this->IsPriceCalculated = $isPriceCalculated;
        }
        return $this;
    }
    /**
     * Get IsPricedPerSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPricedPerSeries()
    {
        return isset($this->IsPricedPerSeries) ? $this->IsPricedPerSeries : null;
    }
    /**
     * Set IsPricedPerSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPricedPerSeries
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setIsPricedPerSeries($isPricedPerSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPricedPerSeries) && !is_bool($isPricedPerSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPricedPerSeries, true), gettype($isPricedPerSeries)), __LINE__);
        }
        if (is_null($isPricedPerSeries) || (is_array($isPricedPerSeries) && empty($isPricedPerSeries))) {
            unset($this->IsPricedPerSeries);
        } else {
            $this->IsPricedPerSeries = $isPricedPerSeries;
        }
        return $this;
    }
    /**
     * Get MasterInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterInstanceId()
    {
        return isset($this->MasterInstanceId) ? $this->MasterInstanceId : null;
    }
    /**
     * Set MasterInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setMasterInstanceId($masterInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($masterInstanceId) && !is_string($masterInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterInstanceId, true), gettype($masterInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($masterInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $masterInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($masterInstanceId, true)), __LINE__);
        }
        if (is_null($masterInstanceId) || (is_array($masterInstanceId) && empty($masterInstanceId))) {
            unset($this->MasterInstanceId);
        } else {
            $this->MasterInstanceId = $masterInstanceId;
        }
        return $this;
    }
    /**
     * Get MaxAllowedFullStackExchanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxAllowedFullStackExchanges()
    {
        return isset($this->MaxAllowedFullStackExchanges) ? $this->MaxAllowedFullStackExchanges : null;
    }
    /**
     * Set MaxAllowedFullStackExchanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxAllowedFullStackExchanges
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setMaxAllowedFullStackExchanges($maxAllowedFullStackExchanges = null)
    {
        // validation for constraint: int
        if (!is_null($maxAllowedFullStackExchanges) && !(is_int($maxAllowedFullStackExchanges) || ctype_digit($maxAllowedFullStackExchanges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAllowedFullStackExchanges, true), gettype($maxAllowedFullStackExchanges)), __LINE__);
        }
        if (is_null($maxAllowedFullStackExchanges) || (is_array($maxAllowedFullStackExchanges) && empty($maxAllowedFullStackExchanges))) {
            unset($this->MaxAllowedFullStackExchanges);
        } else {
            $this->MaxAllowedFullStackExchanges = $maxAllowedFullStackExchanges;
        }
        return $this;
    }
    /**
     * Get PartOfSeriesGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartOfSeriesGroupId()
    {
        return isset($this->PartOfSeriesGroupId) ? $this->PartOfSeriesGroupId : null;
    }
    /**
     * Set PartOfSeriesGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partOfSeriesGroupId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setPartOfSeriesGroupId($partOfSeriesGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($partOfSeriesGroupId) && !is_string($partOfSeriesGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partOfSeriesGroupId, true), gettype($partOfSeriesGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($partOfSeriesGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $partOfSeriesGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($partOfSeriesGroupId, true)), __LINE__);
        }
        if (is_null($partOfSeriesGroupId) || (is_array($partOfSeriesGroupId) && empty($partOfSeriesGroupId))) {
            unset($this->PartOfSeriesGroupId);
        } else {
            $this->PartOfSeriesGroupId = $partOfSeriesGroupId;
        }
        return $this;
    }
    /**
     * Get PrevSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrevSeriesId()
    {
        return isset($this->PrevSeriesId) ? $this->PrevSeriesId : null;
    }
    /**
     * Set PrevSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prevSeriesId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setPrevSeriesId($prevSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($prevSeriesId) && !is_string($prevSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prevSeriesId, true), gettype($prevSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($prevSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $prevSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($prevSeriesId, true)), __LINE__);
        }
        if (is_null($prevSeriesId) || (is_array($prevSeriesId) && empty($prevSeriesId))) {
            unset($this->PrevSeriesId);
        } else {
            $this->PrevSeriesId = $prevSeriesId;
        }
        return $this;
    }
    /**
     * Get PrevSubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrevSubscriptionInstanceId()
    {
        return isset($this->PrevSubscriptionInstanceId) ? $this->PrevSubscriptionInstanceId : null;
    }
    /**
     * Set PrevSubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prevSubscriptionInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setPrevSubscriptionInstanceId($prevSubscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($prevSubscriptionInstanceId) && !is_string($prevSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prevSubscriptionInstanceId, true), gettype($prevSubscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($prevSubscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $prevSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($prevSubscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($prevSubscriptionInstanceId) || (is_array($prevSubscriptionInstanceId) && empty($prevSubscriptionInstanceId))) {
            unset($this->PrevSubscriptionInstanceId);
        } else {
            $this->PrevSubscriptionInstanceId = $prevSubscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get ReportedPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportedPriceTypeId()
    {
        return isset($this->ReportedPriceTypeId) ? $this->ReportedPriceTypeId : null;
    }
    /**
     * Set ReportedPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportedPriceTypeId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setReportedPriceTypeId($reportedPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($reportedPriceTypeId) && !is_string($reportedPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportedPriceTypeId, true), gettype($reportedPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reportedPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reportedPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reportedPriceTypeId, true)), __LINE__);
        }
        if (is_null($reportedPriceTypeId) || (is_array($reportedPriceTypeId) && empty($reportedPriceTypeId))) {
            unset($this->ReportedPriceTypeId);
        } else {
            $this->ReportedPriceTypeId = $reportedPriceTypeId;
        }
        return $this;
    }
    /**
     * Get RestrictionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionId()
    {
        return isset($this->RestrictionId) ? $this->RestrictionId : null;
    }
    /**
     * Set RestrictionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setRestrictionId($restrictionId = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionId) && !is_string($restrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionId, true), gettype($restrictionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($restrictionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $restrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($restrictionId, true)), __LINE__);
        }
        if (is_null($restrictionId) || (is_array($restrictionId) && empty($restrictionId))) {
            unset($this->RestrictionId);
        } else {
            $this->RestrictionId = $restrictionId;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeatAllocHandle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatAllocHandle()
    {
        return isset($this->SeatAllocHandle) ? $this->SeatAllocHandle : null;
    }
    /**
     * Set SeatAllocHandle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatAllocHandle
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSeatAllocHandle($seatAllocHandle = null)
    {
        // validation for constraint: string
        if (!is_null($seatAllocHandle) && !is_string($seatAllocHandle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatAllocHandle, true), gettype($seatAllocHandle)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatAllocHandle) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatAllocHandle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatAllocHandle, true)), __LINE__);
        }
        if (is_null($seatAllocHandle) || (is_array($seatAllocHandle) && empty($seatAllocHandle))) {
            unset($this->SeatAllocHandle);
        } else {
            $this->SeatAllocHandle = $seatAllocHandle;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeatingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingType()
    {
        return isset($this->SeatingType) ? $this->SeatingType : null;
    }
    /**
     * Set SeatingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatingType
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSeatingType($seatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($seatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($seatingType) ? implode(', ', $seatingType) : var_export($seatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        if (is_null($seatingType) || (is_array($seatingType) && empty($seatingType))) {
            unset($this->SeatingType);
        } else {
            $this->SeatingType = $seatingType;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SeatReturnHandle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatReturnHandle()
    {
        return isset($this->SeatReturnHandle) ? $this->SeatReturnHandle : null;
    }
    /**
     * Set SeatReturnHandle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatReturnHandle
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSeatReturnHandle($seatReturnHandle = null)
    {
        // validation for constraint: string
        if (!is_null($seatReturnHandle) && !is_string($seatReturnHandle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatReturnHandle, true), gettype($seatReturnHandle)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatReturnHandle) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatReturnHandle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatReturnHandle, true)), __LINE__);
        }
        if (is_null($seatReturnHandle) || (is_array($seatReturnHandle) && empty($seatReturnHandle))) {
            unset($this->SeatReturnHandle);
        } else {
            $this->SeatReturnHandle = $seatReturnHandle;
        }
        return $this;
    }
    /**
     * Get SeatTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeId()
    {
        return isset($this->SeatTypeId) ? $this->SeatTypeId : null;
    }
    /**
     * Set SeatTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSeatTypeId($seatTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeId) && !is_string($seatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeId, true), gettype($seatTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatTypeId, true)), __LINE__);
        }
        if (is_null($seatTypeId) || (is_array($seatTypeId) && empty($seatTypeId))) {
            unset($this->SeatTypeId);
        } else {
            $this->SeatTypeId = $seatTypeId;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SingleEventPricingDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSingleEventPricingDetails()
    {
        return isset($this->SingleEventPricingDetails) ? $this->SingleEventPricingDetails : null;
    }
    /**
     * Set SingleEventPricingDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $singleEventPricingDetails
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSingleEventPricingDetails($singleEventPricingDetails = null)
    {
        // validation for constraint: string
        if (!is_null($singleEventPricingDetails) && !is_string($singleEventPricingDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleEventPricingDetails, true), gettype($singleEventPricingDetails)), __LINE__);
        }
        if (is_null($singleEventPricingDetails) || (is_array($singleEventPricingDetails) && empty($singleEventPricingDetails))) {
            unset($this->SingleEventPricingDetails);
        } else {
            $this->SingleEventPricingDetails = $singleEventPricingDetails;
        }
        return $this;
    }
    /**
     * Get SkipAutoRenewValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipAutoRenewValidation()
    {
        return isset($this->SkipAutoRenewValidation) ? $this->SkipAutoRenewValidation : null;
    }
    /**
     * Set SkipAutoRenewValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipAutoRenewValidation
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSkipAutoRenewValidation($skipAutoRenewValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipAutoRenewValidation) && !is_bool($skipAutoRenewValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipAutoRenewValidation, true), gettype($skipAutoRenewValidation)), __LINE__);
        }
        if (is_null($skipAutoRenewValidation) || (is_array($skipAutoRenewValidation) && empty($skipAutoRenewValidation))) {
            unset($this->SkipAutoRenewValidation);
        } else {
            $this->SkipAutoRenewValidation = $skipAutoRenewValidation;
        }
        return $this;
    }
    /**
     * Get StandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandId()
    {
        return isset($this->StandId) ? $this->StandId : null;
    }
    /**
     * Set StandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setStandId($standId = null)
    {
        // validation for constraint: string
        if (!is_null($standId) && !is_string($standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standId, true), gettype($standId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($standId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($standId, true)), __LINE__);
        }
        if (is_null($standId) || (is_array($standId) && empty($standId))) {
            unset($this->StandId);
        } else {
            $this->StandId = $standId;
        }
        return $this;
    }
    /**
     * Get StandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandName()
    {
        return isset($this->StandName) ? $this->StandName : null;
    }
    /**
     * Set StandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setStandName($standName = null)
    {
        // validation for constraint: string
        if (!is_null($standName) && !is_string($standName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standName, true), gettype($standName)), __LINE__);
        }
        if (is_null($standName) || (is_array($standName) && empty($standName))) {
            unset($this->StandName);
        } else {
            $this->StandName = $standName;
        }
        return $this;
    }
    /**
     * Get StartDateOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDateOverride()
    {
        return isset($this->StartDateOverride) ? $this->StartDateOverride : null;
    }
    /**
     * Set StartDateOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDateOverride
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setStartDateOverride($startDateOverride = null)
    {
        // validation for constraint: string
        if (!is_null($startDateOverride) && !is_string($startDateOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateOverride, true), gettype($startDateOverride)), __LINE__);
        }
        if (is_null($startDateOverride) || (is_array($startDateOverride) && empty($startDateOverride))) {
            unset($this->StartDateOverride);
        } else {
            $this->StartDateOverride = $startDateOverride;
        }
        return $this;
    }
    /**
     * Get SubscriptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return isset($this->SubscriptionId) ? $this->SubscriptionId : null;
    }
    /**
     * Set SubscriptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionId, true)), __LINE__);
        }
        if (is_null($subscriptionId) || (is_array($subscriptionId) && empty($subscriptionId))) {
            unset($this->SubscriptionId);
        } else {
            $this->SubscriptionId = $subscriptionId;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get TicketSchemesToEnroll value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_AddSubscriptionTicketSchemeDetails|null
     */
    public function getTicketSchemesToEnroll()
    {
        return isset($this->TicketSchemesToEnroll) ? $this->TicketSchemesToEnroll : null;
    }
    /**
     * Set TicketSchemesToEnroll value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_AddSubscriptionTicketSchemeDetails $ticketSchemesToEnroll
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setTicketSchemesToEnroll(\patest\StructType\RecordSetOfTicketing_AddSubscriptionTicketSchemeDetails $ticketSchemesToEnroll = null)
    {
        if (is_null($ticketSchemesToEnroll) || (is_array($ticketSchemesToEnroll) && empty($ticketSchemesToEnroll))) {
            unset($this->TicketSchemesToEnroll);
        } else {
            $this->TicketSchemesToEnroll = $ticketSchemesToEnroll;
        }
        return $this;
    }
    /**
     * Get UsedFullStackExchanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUsedFullStackExchanges()
    {
        return isset($this->UsedFullStackExchanges) ? $this->UsedFullStackExchanges : null;
    }
    /**
     * Set UsedFullStackExchanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $usedFullStackExchanges
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setUsedFullStackExchanges($usedFullStackExchanges = null)
    {
        // validation for constraint: int
        if (!is_null($usedFullStackExchanges) && !(is_int($usedFullStackExchanges) || ctype_digit($usedFullStackExchanges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($usedFullStackExchanges, true), gettype($usedFullStackExchanges)), __LINE__);
        }
        if (is_null($usedFullStackExchanges) || (is_array($usedFullStackExchanges) && empty($usedFullStackExchanges))) {
            unset($this->UsedFullStackExchanges);
        } else {
            $this->UsedFullStackExchanges = $usedFullStackExchanges;
        }
        return $this;
    }
    /**
     * Get WaitMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWaitMode()
    {
        return isset($this->WaitMode) ? $this->WaitMode : null;
    }
    /**
     * Set WaitMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketWaitMode::valueIsValid()
     * @uses \patest\EnumType\TicketWaitMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waitMode
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemPrivateState
     */
    public function setWaitMode($waitMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketWaitMode::valueIsValid($waitMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketWaitMode', is_array($waitMode) ? implode(', ', $waitMode) : var_export($waitMode, true), implode(', ', \patest\EnumType\TicketWaitMode::getValidValues())), __LINE__);
        }
        if (is_null($waitMode) || (is_array($waitMode) && empty($waitMode))) {
            unset($this->WaitMode);
        } else {
            $this->WaitMode = $waitMode;
        }
        return $this;
    }
}
