<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SubscriptionAutoRenewFulfillment StructType
 * @subpackage Structs
 */
class Ticketing_SubscriptionAutoRenewFulfillment extends PersistableEntity
{
    /**
     * The ClientEnrollmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientEnrollmentId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The FulfillmentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FulfillmentDate;
    /**
     * The NewSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewSeriesId;
    /**
     * The NewSubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewSubscriptionInstanceId;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Remark;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for Ticketing.SubscriptionAutoRenewFulfillment
     * @uses Ticketing_SubscriptionAutoRenewFulfillment::setClientEnrollmentId()
     * @uses Ticketing_SubscriptionAutoRenewFulfillment::setClientId()
     * @uses Ticketing_SubscriptionAutoRenewFulfillment::setFulfillmentDate()
     * @uses Ticketing_SubscriptionAutoRenewFulfillment::setNewSeriesId()
     * @uses Ticketing_SubscriptionAutoRenewFulfillment::setNewSubscriptionInstanceId()
     * @uses Ticketing_SubscriptionAutoRenewFulfillment::setRemark()
     * @uses Ticketing_SubscriptionAutoRenewFulfillment::setSeriesId()
     * @uses Ticketing_SubscriptionAutoRenewFulfillment::setState()
     * @uses Ticketing_SubscriptionAutoRenewFulfillment::setSubscriptionInstanceId()
     * @uses Ticketing_SubscriptionAutoRenewFulfillment::setTransactionId()
     * @param string $clientEnrollmentId
     * @param string $clientId
     * @param string $fulfillmentDate
     * @param string $newSeriesId
     * @param string $newSubscriptionInstanceId
     * @param \patest\StructType\GlobalString $remark
     * @param string $seriesId
     * @param string $state
     * @param string $subscriptionInstanceId
     * @param string $transactionId
     */
    public function __construct($clientEnrollmentId = null, $clientId = null, $fulfillmentDate = null, $newSeriesId = null, $newSubscriptionInstanceId = null, \patest\StructType\GlobalString $remark = null, $seriesId = null, $state = null, $subscriptionInstanceId = null, $transactionId = null)
    {
        $this
            ->setClientEnrollmentId($clientEnrollmentId)
            ->setClientId($clientId)
            ->setFulfillmentDate($fulfillmentDate)
            ->setNewSeriesId($newSeriesId)
            ->setNewSubscriptionInstanceId($newSubscriptionInstanceId)
            ->setRemark($remark)
            ->setSeriesId($seriesId)
            ->setState($state)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setTransactionId($transactionId);
    }
    /**
     * Get ClientEnrollmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientEnrollmentId()
    {
        return isset($this->ClientEnrollmentId) ? $this->ClientEnrollmentId : null;
    }
    /**
     * Set ClientEnrollmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientEnrollmentId
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillment
     */
    public function setClientEnrollmentId($clientEnrollmentId = null)
    {
        // validation for constraint: string
        if (!is_null($clientEnrollmentId) && !is_string($clientEnrollmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientEnrollmentId, true), gettype($clientEnrollmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientEnrollmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientEnrollmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientEnrollmentId, true)), __LINE__);
        }
        if (is_null($clientEnrollmentId) || (is_array($clientEnrollmentId) && empty($clientEnrollmentId))) {
            unset($this->ClientEnrollmentId);
        } else {
            $this->ClientEnrollmentId = $clientEnrollmentId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillment
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get FulfillmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFulfillmentDate()
    {
        return isset($this->FulfillmentDate) ? $this->FulfillmentDate : null;
    }
    /**
     * Set FulfillmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fulfillmentDate
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillment
     */
    public function setFulfillmentDate($fulfillmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($fulfillmentDate) && !is_string($fulfillmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fulfillmentDate, true), gettype($fulfillmentDate)), __LINE__);
        }
        if (is_null($fulfillmentDate) || (is_array($fulfillmentDate) && empty($fulfillmentDate))) {
            unset($this->FulfillmentDate);
        } else {
            $this->FulfillmentDate = $fulfillmentDate;
        }
        return $this;
    }
    /**
     * Get NewSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewSeriesId()
    {
        return isset($this->NewSeriesId) ? $this->NewSeriesId : null;
    }
    /**
     * Set NewSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newSeriesId
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillment
     */
    public function setNewSeriesId($newSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($newSeriesId) && !is_string($newSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSeriesId, true), gettype($newSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newSeriesId, true)), __LINE__);
        }
        if (is_null($newSeriesId) || (is_array($newSeriesId) && empty($newSeriesId))) {
            unset($this->NewSeriesId);
        } else {
            $this->NewSeriesId = $newSeriesId;
        }
        return $this;
    }
    /**
     * Get NewSubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewSubscriptionInstanceId()
    {
        return isset($this->NewSubscriptionInstanceId) ? $this->NewSubscriptionInstanceId : null;
    }
    /**
     * Set NewSubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newSubscriptionInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillment
     */
    public function setNewSubscriptionInstanceId($newSubscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($newSubscriptionInstanceId) && !is_string($newSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSubscriptionInstanceId, true), gettype($newSubscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newSubscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newSubscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($newSubscriptionInstanceId) || (is_array($newSubscriptionInstanceId) && empty($newSubscriptionInstanceId))) {
            unset($this->NewSubscriptionInstanceId);
        } else {
            $this->NewSubscriptionInstanceId = $newSubscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $remark
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillment
     */
    public function setRemark(\patest\StructType\GlobalString $remark = null)
    {
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillment
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EnrollmentFulfillmentState::valueIsValid()
     * @uses \patest\EnumType\EnrollmentFulfillmentState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillment
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EnrollmentFulfillmentState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EnrollmentFulfillmentState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\EnrollmentFulfillmentState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillment
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillment
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
}
