<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Subscription StructType
 * @subpackage Structs
 */
class Ticketing_Subscription extends PersistableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The EntityVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityVersion;
    /**
     * The LatestInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LatestInstanceId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * Constructor method for Ticketing.Subscription
     * @uses Ticketing_Subscription::setClientId()
     * @uses Ticketing_Subscription::setCreationDate()
     * @uses Ticketing_Subscription::setEntityVersion()
     * @uses Ticketing_Subscription::setLatestInstanceId()
     * @uses Ticketing_Subscription::setSubscriptionNumber()
     * @param string $clientId
     * @param string $creationDate
     * @param string $entityVersion
     * @param string $latestInstanceId
     * @param string $subscriptionNumber
     */
    public function __construct($clientId = null, $creationDate = null, $entityVersion = null, $latestInstanceId = null, $subscriptionNumber = null)
    {
        $this
            ->setClientId($clientId)
            ->setCreationDate($creationDate)
            ->setEntityVersion($entityVersion)
            ->setLatestInstanceId($latestInstanceId)
            ->setSubscriptionNumber($subscriptionNumber);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_Subscription
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Ticketing_Subscription
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get EntityVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityVersion()
    {
        return isset($this->EntityVersion) ? $this->EntityVersion : null;
    }
    /**
     * Set EntityVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityVersion
     * @return \patest\StructType\Ticketing_Subscription
     */
    public function setEntityVersion($entityVersion = null)
    {
        // validation for constraint: string
        if (!is_null($entityVersion) && !is_string($entityVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityVersion, true), gettype($entityVersion)), __LINE__);
        }
        if (is_null($entityVersion) || (is_array($entityVersion) && empty($entityVersion))) {
            unset($this->EntityVersion);
        } else {
            $this->EntityVersion = $entityVersion;
        }
        return $this;
    }
    /**
     * Get LatestInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLatestInstanceId()
    {
        return isset($this->LatestInstanceId) ? $this->LatestInstanceId : null;
    }
    /**
     * Set LatestInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $latestInstanceId
     * @return \patest\StructType\Ticketing_Subscription
     */
    public function setLatestInstanceId($latestInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($latestInstanceId) && !is_string($latestInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestInstanceId, true), gettype($latestInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($latestInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $latestInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($latestInstanceId, true)), __LINE__);
        }
        if (is_null($latestInstanceId) || (is_array($latestInstanceId) && empty($latestInstanceId))) {
            unset($this->LatestInstanceId);
        } else {
            $this->LatestInstanceId = $latestInstanceId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Ticketing_Subscription
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
}
