<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ShowGenre StructType
 * @subpackage Structs
 */
class Ticketing_ShowGenre extends Ticketing_Base
{
    /**
     * The DisplayInSlideShow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayInSlideShow;
    /**
     * The EntityVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityVersion;
    /**
     * The GenreId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GenreId;
    /**
     * The GenreName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GenreName;
    /**
     * The IsRecommended
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRecommended;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * Constructor method for Ticketing.ShowGenre
     * @uses Ticketing_ShowGenre::setDisplayInSlideShow()
     * @uses Ticketing_ShowGenre::setEntityVersion()
     * @uses Ticketing_ShowGenre::setGenreId()
     * @uses Ticketing_ShowGenre::setGenreName()
     * @uses Ticketing_ShowGenre::setIsRecommended()
     * @uses Ticketing_ShowGenre::setShowId()
     * @param bool $displayInSlideShow
     * @param string $entityVersion
     * @param string $genreId
     * @param \patest\StructType\GlobalString $genreName
     * @param bool $isRecommended
     * @param string $showId
     */
    public function __construct($displayInSlideShow = null, $entityVersion = null, $genreId = null, \patest\StructType\GlobalString $genreName = null, $isRecommended = null, $showId = null)
    {
        $this
            ->setDisplayInSlideShow($displayInSlideShow)
            ->setEntityVersion($entityVersion)
            ->setGenreId($genreId)
            ->setGenreName($genreName)
            ->setIsRecommended($isRecommended)
            ->setShowId($showId);
    }
    /**
     * Get DisplayInSlideShow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayInSlideShow()
    {
        return isset($this->DisplayInSlideShow) ? $this->DisplayInSlideShow : null;
    }
    /**
     * Set DisplayInSlideShow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayInSlideShow
     * @return \patest\StructType\Ticketing_ShowGenre
     */
    public function setDisplayInSlideShow($displayInSlideShow = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayInSlideShow) && !is_bool($displayInSlideShow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayInSlideShow, true), gettype($displayInSlideShow)), __LINE__);
        }
        if (is_null($displayInSlideShow) || (is_array($displayInSlideShow) && empty($displayInSlideShow))) {
            unset($this->DisplayInSlideShow);
        } else {
            $this->DisplayInSlideShow = $displayInSlideShow;
        }
        return $this;
    }
    /**
     * Get EntityVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityVersion()
    {
        return isset($this->EntityVersion) ? $this->EntityVersion : null;
    }
    /**
     * Set EntityVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityVersion
     * @return \patest\StructType\Ticketing_ShowGenre
     */
    public function setEntityVersion($entityVersion = null)
    {
        // validation for constraint: string
        if (!is_null($entityVersion) && !is_string($entityVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityVersion, true), gettype($entityVersion)), __LINE__);
        }
        if (is_null($entityVersion) || (is_array($entityVersion) && empty($entityVersion))) {
            unset($this->EntityVersion);
        } else {
            $this->EntityVersion = $entityVersion;
        }
        return $this;
    }
    /**
     * Get GenreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGenreId()
    {
        return isset($this->GenreId) ? $this->GenreId : null;
    }
    /**
     * Set GenreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $genreId
     * @return \patest\StructType\Ticketing_ShowGenre
     */
    public function setGenreId($genreId = null)
    {
        // validation for constraint: string
        if (!is_null($genreId) && !is_string($genreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genreId, true), gettype($genreId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($genreId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $genreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($genreId, true)), __LINE__);
        }
        if (is_null($genreId) || (is_array($genreId) && empty($genreId))) {
            unset($this->GenreId);
        } else {
            $this->GenreId = $genreId;
        }
        return $this;
    }
    /**
     * Get GenreName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGenreName()
    {
        return isset($this->GenreName) ? $this->GenreName : null;
    }
    /**
     * Set GenreName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $genreName
     * @return \patest\StructType\Ticketing_ShowGenre
     */
    public function setGenreName(\patest\StructType\GlobalString $genreName = null)
    {
        if (is_null($genreName) || (is_array($genreName) && empty($genreName))) {
            unset($this->GenreName);
        } else {
            $this->GenreName = $genreName;
        }
        return $this;
    }
    /**
     * Get IsRecommended value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRecommended()
    {
        return isset($this->IsRecommended) ? $this->IsRecommended : null;
    }
    /**
     * Set IsRecommended value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRecommended
     * @return \patest\StructType\Ticketing_ShowGenre
     */
    public function setIsRecommended($isRecommended = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRecommended) && !is_bool($isRecommended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRecommended, true), gettype($isRecommended)), __LINE__);
        }
        if (is_null($isRecommended) || (is_array($isRecommended) && empty($isRecommended))) {
            unset($this->IsRecommended);
        } else {
            $this->IsRecommended = $isRecommended;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\Ticketing_ShowGenre
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
}
