<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeriesOverlappingRelation StructType
 * @subpackage Structs
 */
class Ticketing_SeriesOverlappingRelation extends PersistableEntity
{
    /**
     * The FirstSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FirstSeriesId;
    /**
     * The SecondSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SecondSeriesId;
    /**
     * Constructor method for Ticketing.SeriesOverlappingRelation
     * @uses Ticketing_SeriesOverlappingRelation::setFirstSeriesId()
     * @uses Ticketing_SeriesOverlappingRelation::setSecondSeriesId()
     * @param string $firstSeriesId
     * @param string $secondSeriesId
     */
    public function __construct($firstSeriesId = null, $secondSeriesId = null)
    {
        $this
            ->setFirstSeriesId($firstSeriesId)
            ->setSecondSeriesId($secondSeriesId);
    }
    /**
     * Get FirstSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstSeriesId()
    {
        return isset($this->FirstSeriesId) ? $this->FirstSeriesId : null;
    }
    /**
     * Set FirstSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstSeriesId
     * @return \patest\StructType\Ticketing_SeriesOverlappingRelation
     */
    public function setFirstSeriesId($firstSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($firstSeriesId) && !is_string($firstSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstSeriesId, true), gettype($firstSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($firstSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $firstSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($firstSeriesId, true)), __LINE__);
        }
        if (is_null($firstSeriesId) || (is_array($firstSeriesId) && empty($firstSeriesId))) {
            unset($this->FirstSeriesId);
        } else {
            $this->FirstSeriesId = $firstSeriesId;
        }
        return $this;
    }
    /**
     * Get SecondSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondSeriesId()
    {
        return isset($this->SecondSeriesId) ? $this->SecondSeriesId : null;
    }
    /**
     * Set SecondSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondSeriesId
     * @return \patest\StructType\Ticketing_SeriesOverlappingRelation
     */
    public function setSecondSeriesId($secondSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($secondSeriesId) && !is_string($secondSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondSeriesId, true), gettype($secondSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($secondSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $secondSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($secondSeriesId, true)), __LINE__);
        }
        if (is_null($secondSeriesId) || (is_array($secondSeriesId) && empty($secondSeriesId))) {
            unset($this->SecondSeriesId);
        } else {
            $this->SecondSeriesId = $secondSeriesId;
        }
        return $this;
    }
}
