<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeriesOfEventInfo StructType
 * @subpackage Structs
 */
class Ticketing_SeriesOfEventInfo extends AnyEntity
{
    /**
     * The MinQtyOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinQtyOfEvents;
    /**
     * The QtyOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QtyOfEvents;
    /**
     * The RelationKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationKind;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SeriesName;
    /**
     * Constructor method for Ticketing.SeriesOfEventInfo
     * @uses Ticketing_SeriesOfEventInfo::setMinQtyOfEvents()
     * @uses Ticketing_SeriesOfEventInfo::setQtyOfEvents()
     * @uses Ticketing_SeriesOfEventInfo::setRelationKind()
     * @uses Ticketing_SeriesOfEventInfo::setSeriesId()
     * @uses Ticketing_SeriesOfEventInfo::setSeriesName()
     * @param int $minQtyOfEvents
     * @param int $qtyOfEvents
     * @param string $relationKind
     * @param string $seriesId
     * @param \patest\StructType\GlobalString $seriesName
     */
    public function __construct($minQtyOfEvents = null, $qtyOfEvents = null, $relationKind = null, $seriesId = null, \patest\StructType\GlobalString $seriesName = null)
    {
        $this
            ->setMinQtyOfEvents($minQtyOfEvents)
            ->setQtyOfEvents($qtyOfEvents)
            ->setRelationKind($relationKind)
            ->setSeriesId($seriesId)
            ->setSeriesName($seriesName);
    }
    /**
     * Get MinQtyOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinQtyOfEvents()
    {
        return isset($this->MinQtyOfEvents) ? $this->MinQtyOfEvents : null;
    }
    /**
     * Set MinQtyOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minQtyOfEvents
     * @return \patest\StructType\Ticketing_SeriesOfEventInfo
     */
    public function setMinQtyOfEvents($minQtyOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($minQtyOfEvents) && !(is_int($minQtyOfEvents) || ctype_digit($minQtyOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minQtyOfEvents, true), gettype($minQtyOfEvents)), __LINE__);
        }
        if (is_null($minQtyOfEvents) || (is_array($minQtyOfEvents) && empty($minQtyOfEvents))) {
            unset($this->MinQtyOfEvents);
        } else {
            $this->MinQtyOfEvents = $minQtyOfEvents;
        }
        return $this;
    }
    /**
     * Get QtyOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQtyOfEvents()
    {
        return isset($this->QtyOfEvents) ? $this->QtyOfEvents : null;
    }
    /**
     * Set QtyOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $qtyOfEvents
     * @return \patest\StructType\Ticketing_SeriesOfEventInfo
     */
    public function setQtyOfEvents($qtyOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($qtyOfEvents) && !(is_int($qtyOfEvents) || ctype_digit($qtyOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qtyOfEvents, true), gettype($qtyOfEvents)), __LINE__);
        }
        if (is_null($qtyOfEvents) || (is_array($qtyOfEvents) && empty($qtyOfEvents))) {
            unset($this->QtyOfEvents);
        } else {
            $this->QtyOfEvents = $qtyOfEvents;
        }
        return $this;
    }
    /**
     * Get RelationKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationKind()
    {
        return isset($this->RelationKind) ? $this->RelationKind : null;
    }
    /**
     * Set RelationKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesRelatedEventKind::valueIsValid()
     * @uses \patest\EnumType\SeriesRelatedEventKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relationKind
     * @return \patest\StructType\Ticketing_SeriesOfEventInfo
     */
    public function setRelationKind($relationKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesRelatedEventKind::valueIsValid($relationKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesRelatedEventKind', is_array($relationKind) ? implode(', ', $relationKind) : var_export($relationKind, true), implode(', ', \patest\EnumType\SeriesRelatedEventKind::getValidValues())), __LINE__);
        }
        if (is_null($relationKind) || (is_array($relationKind) && empty($relationKind))) {
            unset($this->RelationKind);
        } else {
            $this->RelationKind = $relationKind;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_SeriesOfEventInfo
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $seriesName
     * @return \patest\StructType\Ticketing_SeriesOfEventInfo
     */
    public function setSeriesName(\patest\StructType\GlobalString $seriesName = null)
    {
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
}
