<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeriesExchangePolicyBase StructType
 * @subpackage Structs
 */
class Ticketing_SeriesExchangePolicyBase extends PersistableEntity
{
    /**
     * The AllowExchangesForUnpaidTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowExchangesForUnpaidTickets;
    /**
     * The DefaultSeatgeekAllocationTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultSeatgeekAllocationTypeId;
    /**
     * The ExchangeEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExchangeEnabled;
    /**
     * The ExchangeTarget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExchangeTarget;
    /**
     * The LimitNumOfFullStackExchanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LimitNumOfFullStackExchanges;
    /**
     * The MaxAllowedFullStackExchanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxAllowedFullStackExchanges;
    /**
     * Constructor method for Ticketing.SeriesExchangePolicyBase
     * @uses Ticketing_SeriesExchangePolicyBase::setAllowExchangesForUnpaidTickets()
     * @uses Ticketing_SeriesExchangePolicyBase::setDefaultSeatgeekAllocationTypeId()
     * @uses Ticketing_SeriesExchangePolicyBase::setExchangeEnabled()
     * @uses Ticketing_SeriesExchangePolicyBase::setExchangeTarget()
     * @uses Ticketing_SeriesExchangePolicyBase::setLimitNumOfFullStackExchanges()
     * @uses Ticketing_SeriesExchangePolicyBase::setMaxAllowedFullStackExchanges()
     * @param bool $allowExchangesForUnpaidTickets
     * @param string $defaultSeatgeekAllocationTypeId
     * @param bool $exchangeEnabled
     * @param string $exchangeTarget
     * @param bool $limitNumOfFullStackExchanges
     * @param int $maxAllowedFullStackExchanges
     */
    public function __construct($allowExchangesForUnpaidTickets = null, $defaultSeatgeekAllocationTypeId = null, $exchangeEnabled = null, $exchangeTarget = null, $limitNumOfFullStackExchanges = null, $maxAllowedFullStackExchanges = null)
    {
        $this
            ->setAllowExchangesForUnpaidTickets($allowExchangesForUnpaidTickets)
            ->setDefaultSeatgeekAllocationTypeId($defaultSeatgeekAllocationTypeId)
            ->setExchangeEnabled($exchangeEnabled)
            ->setExchangeTarget($exchangeTarget)
            ->setLimitNumOfFullStackExchanges($limitNumOfFullStackExchanges)
            ->setMaxAllowedFullStackExchanges($maxAllowedFullStackExchanges);
    }
    /**
     * Get AllowExchangesForUnpaidTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowExchangesForUnpaidTickets()
    {
        return isset($this->AllowExchangesForUnpaidTickets) ? $this->AllowExchangesForUnpaidTickets : null;
    }
    /**
     * Set AllowExchangesForUnpaidTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowExchangesForUnpaidTickets
     * @return \patest\StructType\Ticketing_SeriesExchangePolicyBase
     */
    public function setAllowExchangesForUnpaidTickets($allowExchangesForUnpaidTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowExchangesForUnpaidTickets) && !is_bool($allowExchangesForUnpaidTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowExchangesForUnpaidTickets, true), gettype($allowExchangesForUnpaidTickets)), __LINE__);
        }
        if (is_null($allowExchangesForUnpaidTickets) || (is_array($allowExchangesForUnpaidTickets) && empty($allowExchangesForUnpaidTickets))) {
            unset($this->AllowExchangesForUnpaidTickets);
        } else {
            $this->AllowExchangesForUnpaidTickets = $allowExchangesForUnpaidTickets;
        }
        return $this;
    }
    /**
     * Get DefaultSeatgeekAllocationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSeatgeekAllocationTypeId()
    {
        return isset($this->DefaultSeatgeekAllocationTypeId) ? $this->DefaultSeatgeekAllocationTypeId : null;
    }
    /**
     * Set DefaultSeatgeekAllocationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSeatgeekAllocationTypeId
     * @return \patest\StructType\Ticketing_SeriesExchangePolicyBase
     */
    public function setDefaultSeatgeekAllocationTypeId($defaultSeatgeekAllocationTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSeatgeekAllocationTypeId) && !is_string($defaultSeatgeekAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSeatgeekAllocationTypeId, true), gettype($defaultSeatgeekAllocationTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultSeatgeekAllocationTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultSeatgeekAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultSeatgeekAllocationTypeId, true)), __LINE__);
        }
        if (is_null($defaultSeatgeekAllocationTypeId) || (is_array($defaultSeatgeekAllocationTypeId) && empty($defaultSeatgeekAllocationTypeId))) {
            unset($this->DefaultSeatgeekAllocationTypeId);
        } else {
            $this->DefaultSeatgeekAllocationTypeId = $defaultSeatgeekAllocationTypeId;
        }
        return $this;
    }
    /**
     * Get ExchangeEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExchangeEnabled()
    {
        return isset($this->ExchangeEnabled) ? $this->ExchangeEnabled : null;
    }
    /**
     * Set ExchangeEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exchangeEnabled
     * @return \patest\StructType\Ticketing_SeriesExchangePolicyBase
     */
    public function setExchangeEnabled($exchangeEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($exchangeEnabled) && !is_bool($exchangeEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exchangeEnabled, true), gettype($exchangeEnabled)), __LINE__);
        }
        if (is_null($exchangeEnabled) || (is_array($exchangeEnabled) && empty($exchangeEnabled))) {
            unset($this->ExchangeEnabled);
        } else {
            $this->ExchangeEnabled = $exchangeEnabled;
        }
        return $this;
    }
    /**
     * Get ExchangeTarget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExchangeTarget()
    {
        return isset($this->ExchangeTarget) ? $this->ExchangeTarget : null;
    }
    /**
     * Set ExchangeTarget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberTicketExchangeTarget::valueIsValid()
     * @uses \patest\EnumType\SubscriberTicketExchangeTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exchangeTarget
     * @return \patest\StructType\Ticketing_SeriesExchangePolicyBase
     */
    public function setExchangeTarget($exchangeTarget = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberTicketExchangeTarget::valueIsValid($exchangeTarget)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberTicketExchangeTarget', is_array($exchangeTarget) ? implode(', ', $exchangeTarget) : var_export($exchangeTarget, true), implode(', ', \patest\EnumType\SubscriberTicketExchangeTarget::getValidValues())), __LINE__);
        }
        if (is_null($exchangeTarget) || (is_array($exchangeTarget) && empty($exchangeTarget))) {
            unset($this->ExchangeTarget);
        } else {
            $this->ExchangeTarget = $exchangeTarget;
        }
        return $this;
    }
    /**
     * Get LimitNumOfFullStackExchanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLimitNumOfFullStackExchanges()
    {
        return isset($this->LimitNumOfFullStackExchanges) ? $this->LimitNumOfFullStackExchanges : null;
    }
    /**
     * Set LimitNumOfFullStackExchanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $limitNumOfFullStackExchanges
     * @return \patest\StructType\Ticketing_SeriesExchangePolicyBase
     */
    public function setLimitNumOfFullStackExchanges($limitNumOfFullStackExchanges = null)
    {
        // validation for constraint: boolean
        if (!is_null($limitNumOfFullStackExchanges) && !is_bool($limitNumOfFullStackExchanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($limitNumOfFullStackExchanges, true), gettype($limitNumOfFullStackExchanges)), __LINE__);
        }
        if (is_null($limitNumOfFullStackExchanges) || (is_array($limitNumOfFullStackExchanges) && empty($limitNumOfFullStackExchanges))) {
            unset($this->LimitNumOfFullStackExchanges);
        } else {
            $this->LimitNumOfFullStackExchanges = $limitNumOfFullStackExchanges;
        }
        return $this;
    }
    /**
     * Get MaxAllowedFullStackExchanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxAllowedFullStackExchanges()
    {
        return isset($this->MaxAllowedFullStackExchanges) ? $this->MaxAllowedFullStackExchanges : null;
    }
    /**
     * Set MaxAllowedFullStackExchanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxAllowedFullStackExchanges
     * @return \patest\StructType\Ticketing_SeriesExchangePolicyBase
     */
    public function setMaxAllowedFullStackExchanges($maxAllowedFullStackExchanges = null)
    {
        // validation for constraint: int
        if (!is_null($maxAllowedFullStackExchanges) && !(is_int($maxAllowedFullStackExchanges) || ctype_digit($maxAllowedFullStackExchanges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAllowedFullStackExchanges, true), gettype($maxAllowedFullStackExchanges)), __LINE__);
        }
        if (is_null($maxAllowedFullStackExchanges) || (is_array($maxAllowedFullStackExchanges) && empty($maxAllowedFullStackExchanges))) {
            unset($this->MaxAllowedFullStackExchanges);
        } else {
            $this->MaxAllowedFullStackExchanges = $maxAllowedFullStackExchanges;
        }
        return $this;
    }
}
