<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeriesDetailsForSwitchToPricePerEvent StructType
 * @subpackage Structs
 */
class Ticketing_SeriesDetailsForSwitchToPricePerEvent extends PersistableEntity
{
    /**
     * The IsPartialEventBased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPartialEventBased;
    /**
     * The RelatedEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_EventDetailsForSwitchSeriesToPricePerEvent
     */
    public $RelatedEvents;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The TicketsAllocationErrorCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketsAllocationErrorCount;
    /**
     * The TicketsAllocationStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketsAllocationStatus;
    /**
     * Constructor method for Ticketing.SeriesDetailsForSwitchToPricePerEvent
     * @uses Ticketing_SeriesDetailsForSwitchToPricePerEvent::setIsPartialEventBased()
     * @uses Ticketing_SeriesDetailsForSwitchToPricePerEvent::setRelatedEvents()
     * @uses Ticketing_SeriesDetailsForSwitchToPricePerEvent::setSeriesId()
     * @uses Ticketing_SeriesDetailsForSwitchToPricePerEvent::setTicketsAllocationErrorCount()
     * @uses Ticketing_SeriesDetailsForSwitchToPricePerEvent::setTicketsAllocationStatus()
     * @param bool $isPartialEventBased
     * @param \patest\StructType\RecordSetOfTicketing_EventDetailsForSwitchSeriesToPricePerEvent $relatedEvents
     * @param string $seriesId
     * @param int $ticketsAllocationErrorCount
     * @param string $ticketsAllocationStatus
     */
    public function __construct($isPartialEventBased = null, \patest\StructType\RecordSetOfTicketing_EventDetailsForSwitchSeriesToPricePerEvent $relatedEvents = null, $seriesId = null, $ticketsAllocationErrorCount = null, $ticketsAllocationStatus = null)
    {
        $this
            ->setIsPartialEventBased($isPartialEventBased)
            ->setRelatedEvents($relatedEvents)
            ->setSeriesId($seriesId)
            ->setTicketsAllocationErrorCount($ticketsAllocationErrorCount)
            ->setTicketsAllocationStatus($ticketsAllocationStatus);
    }
    /**
     * Get IsPartialEventBased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPartialEventBased()
    {
        return isset($this->IsPartialEventBased) ? $this->IsPartialEventBased : null;
    }
    /**
     * Set IsPartialEventBased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPartialEventBased
     * @return \patest\StructType\Ticketing_SeriesDetailsForSwitchToPricePerEvent
     */
    public function setIsPartialEventBased($isPartialEventBased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartialEventBased) && !is_bool($isPartialEventBased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartialEventBased, true), gettype($isPartialEventBased)), __LINE__);
        }
        if (is_null($isPartialEventBased) || (is_array($isPartialEventBased) && empty($isPartialEventBased))) {
            unset($this->IsPartialEventBased);
        } else {
            $this->IsPartialEventBased = $isPartialEventBased;
        }
        return $this;
    }
    /**
     * Get RelatedEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_EventDetailsForSwitchSeriesToPricePerEvent|null
     */
    public function getRelatedEvents()
    {
        return isset($this->RelatedEvents) ? $this->RelatedEvents : null;
    }
    /**
     * Set RelatedEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_EventDetailsForSwitchSeriesToPricePerEvent $relatedEvents
     * @return \patest\StructType\Ticketing_SeriesDetailsForSwitchToPricePerEvent
     */
    public function setRelatedEvents(\patest\StructType\RecordSetOfTicketing_EventDetailsForSwitchSeriesToPricePerEvent $relatedEvents = null)
    {
        if (is_null($relatedEvents) || (is_array($relatedEvents) && empty($relatedEvents))) {
            unset($this->RelatedEvents);
        } else {
            $this->RelatedEvents = $relatedEvents;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_SeriesDetailsForSwitchToPricePerEvent
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get TicketsAllocationErrorCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketsAllocationErrorCount()
    {
        return isset($this->TicketsAllocationErrorCount) ? $this->TicketsAllocationErrorCount : null;
    }
    /**
     * Set TicketsAllocationErrorCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketsAllocationErrorCount
     * @return \patest\StructType\Ticketing_SeriesDetailsForSwitchToPricePerEvent
     */
    public function setTicketsAllocationErrorCount($ticketsAllocationErrorCount = null)
    {
        // validation for constraint: int
        if (!is_null($ticketsAllocationErrorCount) && !(is_int($ticketsAllocationErrorCount) || ctype_digit($ticketsAllocationErrorCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketsAllocationErrorCount, true), gettype($ticketsAllocationErrorCount)), __LINE__);
        }
        if (is_null($ticketsAllocationErrorCount) || (is_array($ticketsAllocationErrorCount) && empty($ticketsAllocationErrorCount))) {
            unset($this->TicketsAllocationErrorCount);
        } else {
            $this->TicketsAllocationErrorCount = $ticketsAllocationErrorCount;
        }
        return $this;
    }
    /**
     * Get TicketsAllocationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketsAllocationStatus()
    {
        return isset($this->TicketsAllocationStatus) ? $this->TicketsAllocationStatus : null;
    }
    /**
     * Set TicketsAllocationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketsAllocationStatus::valueIsValid()
     * @uses \patest\EnumType\TicketsAllocationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketsAllocationStatus
     * @return \patest\StructType\Ticketing_SeriesDetailsForSwitchToPricePerEvent
     */
    public function setTicketsAllocationStatus($ticketsAllocationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketsAllocationStatus::valueIsValid($ticketsAllocationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketsAllocationStatus', is_array($ticketsAllocationStatus) ? implode(', ', $ticketsAllocationStatus) : var_export($ticketsAllocationStatus, true), implode(', ', \patest\EnumType\TicketsAllocationStatus::getValidValues())), __LINE__);
        }
        if (is_null($ticketsAllocationStatus) || (is_array($ticketsAllocationStatus) && empty($ticketsAllocationStatus))) {
            unset($this->TicketsAllocationStatus);
        } else {
            $this->TicketsAllocationStatus = $ticketsAllocationStatus;
        }
        return $this;
    }
}
