<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatingPlanStatistics StructType
 * @subpackage Structs
 */
class Ticketing_SeatingPlanStatistics extends PersistableEntity
{
    /**
     * The CurrentSessionsData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentSessionsData;
    /**
     * The EntityVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityVersion;
    /**
     * The ForResaleCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ForResaleCount;
    /**
     * The FreeCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FreeCount;
    /**
     * The GaCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GaCapacity;
    /**
     * The HeldForSubscribersCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HeldForSubscribersCount;
    /**
     * The InProcessCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InProcessCount;
    /**
     * The InvalidatedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvalidatedAt;
    /**
     * The InvalidationReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvalidationReason;
    /**
     * The LockedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LockedCount;
    /**
     * The ReservedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReservedCount;
    /**
     * The RsCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RsCapacity;
    /**
     * The SeatingPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanId;
    /**
     * The SoldCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SoldCount;
    /**
     * The StatisticsData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatisticsData;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The UpdatedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UpdatedAt;
    /**
     * Constructor method for Ticketing.SeatingPlanStatistics
     * @uses Ticketing_SeatingPlanStatistics::setCurrentSessionsData()
     * @uses Ticketing_SeatingPlanStatistics::setEntityVersion()
     * @uses Ticketing_SeatingPlanStatistics::setForResaleCount()
     * @uses Ticketing_SeatingPlanStatistics::setFreeCount()
     * @uses Ticketing_SeatingPlanStatistics::setGaCapacity()
     * @uses Ticketing_SeatingPlanStatistics::setHeldForSubscribersCount()
     * @uses Ticketing_SeatingPlanStatistics::setInProcessCount()
     * @uses Ticketing_SeatingPlanStatistics::setInvalidatedAt()
     * @uses Ticketing_SeatingPlanStatistics::setInvalidationReason()
     * @uses Ticketing_SeatingPlanStatistics::setLockedCount()
     * @uses Ticketing_SeatingPlanStatistics::setReservedCount()
     * @uses Ticketing_SeatingPlanStatistics::setRsCapacity()
     * @uses Ticketing_SeatingPlanStatistics::setSeatingPlanId()
     * @uses Ticketing_SeatingPlanStatistics::setSoldCount()
     * @uses Ticketing_SeatingPlanStatistics::setStatisticsData()
     * @uses Ticketing_SeatingPlanStatistics::setStatus()
     * @uses Ticketing_SeatingPlanStatistics::setUpdatedAt()
     * @param string $currentSessionsData
     * @param string $entityVersion
     * @param int $forResaleCount
     * @param int $freeCount
     * @param int $gaCapacity
     * @param int $heldForSubscribersCount
     * @param int $inProcessCount
     * @param string $invalidatedAt
     * @param string $invalidationReason
     * @param int $lockedCount
     * @param int $reservedCount
     * @param int $rsCapacity
     * @param string $seatingPlanId
     * @param int $soldCount
     * @param string $statisticsData
     * @param string $status
     * @param string $updatedAt
     */
    public function __construct($currentSessionsData = null, $entityVersion = null, $forResaleCount = null, $freeCount = null, $gaCapacity = null, $heldForSubscribersCount = null, $inProcessCount = null, $invalidatedAt = null, $invalidationReason = null, $lockedCount = null, $reservedCount = null, $rsCapacity = null, $seatingPlanId = null, $soldCount = null, $statisticsData = null, $status = null, $updatedAt = null)
    {
        $this
            ->setCurrentSessionsData($currentSessionsData)
            ->setEntityVersion($entityVersion)
            ->setForResaleCount($forResaleCount)
            ->setFreeCount($freeCount)
            ->setGaCapacity($gaCapacity)
            ->setHeldForSubscribersCount($heldForSubscribersCount)
            ->setInProcessCount($inProcessCount)
            ->setInvalidatedAt($invalidatedAt)
            ->setInvalidationReason($invalidationReason)
            ->setLockedCount($lockedCount)
            ->setReservedCount($reservedCount)
            ->setRsCapacity($rsCapacity)
            ->setSeatingPlanId($seatingPlanId)
            ->setSoldCount($soldCount)
            ->setStatisticsData($statisticsData)
            ->setStatus($status)
            ->setUpdatedAt($updatedAt);
    }
    /**
     * Get CurrentSessionsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentSessionsData()
    {
        return isset($this->CurrentSessionsData) ? $this->CurrentSessionsData : null;
    }
    /**
     * Set CurrentSessionsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentSessionsData
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setCurrentSessionsData($currentSessionsData = null)
    {
        // validation for constraint: string
        if (!is_null($currentSessionsData) && !is_string($currentSessionsData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentSessionsData, true), gettype($currentSessionsData)), __LINE__);
        }
        if (is_null($currentSessionsData) || (is_array($currentSessionsData) && empty($currentSessionsData))) {
            unset($this->CurrentSessionsData);
        } else {
            $this->CurrentSessionsData = $currentSessionsData;
        }
        return $this;
    }
    /**
     * Get EntityVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityVersion()
    {
        return isset($this->EntityVersion) ? $this->EntityVersion : null;
    }
    /**
     * Set EntityVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityVersion
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setEntityVersion($entityVersion = null)
    {
        // validation for constraint: string
        if (!is_null($entityVersion) && !is_string($entityVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityVersion, true), gettype($entityVersion)), __LINE__);
        }
        if (is_null($entityVersion) || (is_array($entityVersion) && empty($entityVersion))) {
            unset($this->EntityVersion);
        } else {
            $this->EntityVersion = $entityVersion;
        }
        return $this;
    }
    /**
     * Get ForResaleCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getForResaleCount()
    {
        return isset($this->ForResaleCount) ? $this->ForResaleCount : null;
    }
    /**
     * Set ForResaleCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $forResaleCount
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setForResaleCount($forResaleCount = null)
    {
        // validation for constraint: int
        if (!is_null($forResaleCount) && !(is_int($forResaleCount) || ctype_digit($forResaleCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($forResaleCount, true), gettype($forResaleCount)), __LINE__);
        }
        if (is_null($forResaleCount) || (is_array($forResaleCount) && empty($forResaleCount))) {
            unset($this->ForResaleCount);
        } else {
            $this->ForResaleCount = $forResaleCount;
        }
        return $this;
    }
    /**
     * Get FreeCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFreeCount()
    {
        return isset($this->FreeCount) ? $this->FreeCount : null;
    }
    /**
     * Set FreeCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $freeCount
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setFreeCount($freeCount = null)
    {
        // validation for constraint: int
        if (!is_null($freeCount) && !(is_int($freeCount) || ctype_digit($freeCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($freeCount, true), gettype($freeCount)), __LINE__);
        }
        if (is_null($freeCount) || (is_array($freeCount) && empty($freeCount))) {
            unset($this->FreeCount);
        } else {
            $this->FreeCount = $freeCount;
        }
        return $this;
    }
    /**
     * Get GaCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGaCapacity()
    {
        return isset($this->GaCapacity) ? $this->GaCapacity : null;
    }
    /**
     * Set GaCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $gaCapacity
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setGaCapacity($gaCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($gaCapacity) && !(is_int($gaCapacity) || ctype_digit($gaCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gaCapacity, true), gettype($gaCapacity)), __LINE__);
        }
        if (is_null($gaCapacity) || (is_array($gaCapacity) && empty($gaCapacity))) {
            unset($this->GaCapacity);
        } else {
            $this->GaCapacity = $gaCapacity;
        }
        return $this;
    }
    /**
     * Get HeldForSubscribersCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHeldForSubscribersCount()
    {
        return isset($this->HeldForSubscribersCount) ? $this->HeldForSubscribersCount : null;
    }
    /**
     * Set HeldForSubscribersCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $heldForSubscribersCount
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setHeldForSubscribersCount($heldForSubscribersCount = null)
    {
        // validation for constraint: int
        if (!is_null($heldForSubscribersCount) && !(is_int($heldForSubscribersCount) || ctype_digit($heldForSubscribersCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($heldForSubscribersCount, true), gettype($heldForSubscribersCount)), __LINE__);
        }
        if (is_null($heldForSubscribersCount) || (is_array($heldForSubscribersCount) && empty($heldForSubscribersCount))) {
            unset($this->HeldForSubscribersCount);
        } else {
            $this->HeldForSubscribersCount = $heldForSubscribersCount;
        }
        return $this;
    }
    /**
     * Get InProcessCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInProcessCount()
    {
        return isset($this->InProcessCount) ? $this->InProcessCount : null;
    }
    /**
     * Set InProcessCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inProcessCount
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setInProcessCount($inProcessCount = null)
    {
        // validation for constraint: int
        if (!is_null($inProcessCount) && !(is_int($inProcessCount) || ctype_digit($inProcessCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inProcessCount, true), gettype($inProcessCount)), __LINE__);
        }
        if (is_null($inProcessCount) || (is_array($inProcessCount) && empty($inProcessCount))) {
            unset($this->InProcessCount);
        } else {
            $this->InProcessCount = $inProcessCount;
        }
        return $this;
    }
    /**
     * Get InvalidatedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvalidatedAt()
    {
        return isset($this->InvalidatedAt) ? $this->InvalidatedAt : null;
    }
    /**
     * Set InvalidatedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invalidatedAt
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setInvalidatedAt($invalidatedAt = null)
    {
        // validation for constraint: string
        if (!is_null($invalidatedAt) && !is_string($invalidatedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invalidatedAt, true), gettype($invalidatedAt)), __LINE__);
        }
        if (is_null($invalidatedAt) || (is_array($invalidatedAt) && empty($invalidatedAt))) {
            unset($this->InvalidatedAt);
        } else {
            $this->InvalidatedAt = $invalidatedAt;
        }
        return $this;
    }
    /**
     * Get InvalidationReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvalidationReason()
    {
        return isset($this->InvalidationReason) ? $this->InvalidationReason : null;
    }
    /**
     * Set InvalidationReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invalidationReason
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setInvalidationReason($invalidationReason = null)
    {
        // validation for constraint: string
        if (!is_null($invalidationReason) && !is_string($invalidationReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invalidationReason, true), gettype($invalidationReason)), __LINE__);
        }
        if (is_null($invalidationReason) || (is_array($invalidationReason) && empty($invalidationReason))) {
            unset($this->InvalidationReason);
        } else {
            $this->InvalidationReason = $invalidationReason;
        }
        return $this;
    }
    /**
     * Get LockedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLockedCount()
    {
        return isset($this->LockedCount) ? $this->LockedCount : null;
    }
    /**
     * Set LockedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lockedCount
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setLockedCount($lockedCount = null)
    {
        // validation for constraint: int
        if (!is_null($lockedCount) && !(is_int($lockedCount) || ctype_digit($lockedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lockedCount, true), gettype($lockedCount)), __LINE__);
        }
        if (is_null($lockedCount) || (is_array($lockedCount) && empty($lockedCount))) {
            unset($this->LockedCount);
        } else {
            $this->LockedCount = $lockedCount;
        }
        return $this;
    }
    /**
     * Get ReservedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReservedCount()
    {
        return isset($this->ReservedCount) ? $this->ReservedCount : null;
    }
    /**
     * Set ReservedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reservedCount
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setReservedCount($reservedCount = null)
    {
        // validation for constraint: int
        if (!is_null($reservedCount) && !(is_int($reservedCount) || ctype_digit($reservedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservedCount, true), gettype($reservedCount)), __LINE__);
        }
        if (is_null($reservedCount) || (is_array($reservedCount) && empty($reservedCount))) {
            unset($this->ReservedCount);
        } else {
            $this->ReservedCount = $reservedCount;
        }
        return $this;
    }
    /**
     * Get RsCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRsCapacity()
    {
        return isset($this->RsCapacity) ? $this->RsCapacity : null;
    }
    /**
     * Set RsCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rsCapacity
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setRsCapacity($rsCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($rsCapacity) && !(is_int($rsCapacity) || ctype_digit($rsCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rsCapacity, true), gettype($rsCapacity)), __LINE__);
        }
        if (is_null($rsCapacity) || (is_array($rsCapacity) && empty($rsCapacity))) {
            unset($this->RsCapacity);
        } else {
            $this->RsCapacity = $rsCapacity;
        }
        return $this;
    }
    /**
     * Get SeatingPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanId()
    {
        return isset($this->SeatingPlanId) ? $this->SeatingPlanId : null;
    }
    /**
     * Set SeatingPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanId
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setSeatingPlanId($seatingPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanId) && !is_string($seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanId, true), gettype($seatingPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanId, true)), __LINE__);
        }
        if (is_null($seatingPlanId) || (is_array($seatingPlanId) && empty($seatingPlanId))) {
            unset($this->SeatingPlanId);
        } else {
            $this->SeatingPlanId = $seatingPlanId;
        }
        return $this;
    }
    /**
     * Get SoldCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSoldCount()
    {
        return isset($this->SoldCount) ? $this->SoldCount : null;
    }
    /**
     * Set SoldCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $soldCount
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setSoldCount($soldCount = null)
    {
        // validation for constraint: int
        if (!is_null($soldCount) && !(is_int($soldCount) || ctype_digit($soldCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldCount, true), gettype($soldCount)), __LINE__);
        }
        if (is_null($soldCount) || (is_array($soldCount) && empty($soldCount))) {
            unset($this->SoldCount);
        } else {
            $this->SoldCount = $soldCount;
        }
        return $this;
    }
    /**
     * Get StatisticsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatisticsData()
    {
        return isset($this->StatisticsData) ? $this->StatisticsData : null;
    }
    /**
     * Set StatisticsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statisticsData
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setStatisticsData($statisticsData = null)
    {
        // validation for constraint: string
        if (!is_null($statisticsData) && !is_string($statisticsData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statisticsData, true), gettype($statisticsData)), __LINE__);
        }
        if (is_null($statisticsData) || (is_array($statisticsData) && empty($statisticsData))) {
            unset($this->StatisticsData);
        } else {
            $this->StatisticsData = $statisticsData;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatingPlanStatisticsRecordStatus::valueIsValid()
     * @uses \patest\EnumType\SeatingPlanStatisticsRecordStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatingPlanStatisticsRecordStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatingPlanStatisticsRecordStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\SeatingPlanStatisticsRecordStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get UpdatedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return isset($this->UpdatedAt) ? $this->UpdatedAt : null;
    }
    /**
     * Set UpdatedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updatedAt
     * @return \patest\StructType\Ticketing_SeatingPlanStatistics
     */
    public function setUpdatedAt($updatedAt = null)
    {
        // validation for constraint: string
        if (!is_null($updatedAt) && !is_string($updatedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedAt, true), gettype($updatedAt)), __LINE__);
        }
        if (is_null($updatedAt) || (is_array($updatedAt) && empty($updatedAt))) {
            unset($this->UpdatedAt);
        } else {
            $this->UpdatedAt = $updatedAt;
        }
        return $this;
    }
}
