<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatingPlanSeatRuntimeInfo StructType
 * @subpackage Structs
 */
class Ticketing_SeatingPlanSeatRuntimeInfo extends AnyEntity
{
    /**
     * The AllocationIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllocationIds;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The IsAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailable;
    /**
     * The IsOccupiedByPeer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOccupiedByPeer;
    /**
     * The IsResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsResale;
    /**
     * The IsSubscriberSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubscriberSeat;
    /**
     * The LockId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockId;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The ResoldAtPricingDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResoldAtPricingDetails;
    /**
     * The ResoldAtPricingVariationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ResoldAtPricingVariationId;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatingPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanId;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SeatStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatStatus;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The SoldAtApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SoldAtApplicationChannel;
    /**
     * The SoldAtPriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SoldAtPriceLevelId;
    /**
     * The SoldAtPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SoldAtPriceTypeId;
    /**
     * The SoldAtPricingDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SoldAtPricingDetails;
    /**
     * The SoldAtPricingVariationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SoldAtPricingVariationId;
    /**
     * The SoldAtSaleModeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SoldAtSaleModeId;
    /**
     * Constructor method for Ticketing.SeatingPlanSeatRuntimeInfo
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setAllocationIds()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setAreaId()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setIsAvailable()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setIsOccupiedByPeer()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setIsResale()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setIsSubscriberSeat()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setLockId()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setPriceLevelId()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setResoldAtPricingDetails()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setResoldAtPricingVariationId()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setRowName()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setSeatIdInAreaMap()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setSeatingPlanId()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setSeatName()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setSeatStatus()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setSectorName()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setSoldAtApplicationChannel()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setSoldAtPriceLevelId()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setSoldAtPriceTypeId()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setSoldAtPricingDetails()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setSoldAtPricingVariationId()
     * @uses Ticketing_SeatingPlanSeatRuntimeInfo::setSoldAtSaleModeId()
     * @param string $allocationIds
     * @param string $areaId
     * @param bool $isAvailable
     * @param bool $isOccupiedByPeer
     * @param bool $isResale
     * @param bool $isSubscriberSeat
     * @param string $lockId
     * @param string $priceLevelId
     * @param string $resoldAtPricingDetails
     * @param int $resoldAtPricingVariationId
     * @param string $rowName
     * @param int $seatIdInAreaMap
     * @param string $seatingPlanId
     * @param string $seatName
     * @param string $seatStatus
     * @param string $sectorName
     * @param string $soldAtApplicationChannel
     * @param string $soldAtPriceLevelId
     * @param string $soldAtPriceTypeId
     * @param string $soldAtPricingDetails
     * @param int $soldAtPricingVariationId
     * @param string $soldAtSaleModeId
     */
    public function __construct($allocationIds = null, $areaId = null, $isAvailable = null, $isOccupiedByPeer = null, $isResale = null, $isSubscriberSeat = null, $lockId = null, $priceLevelId = null, $resoldAtPricingDetails = null, $resoldAtPricingVariationId = null, $rowName = null, $seatIdInAreaMap = null, $seatingPlanId = null, $seatName = null, $seatStatus = null, $sectorName = null, $soldAtApplicationChannel = null, $soldAtPriceLevelId = null, $soldAtPriceTypeId = null, $soldAtPricingDetails = null, $soldAtPricingVariationId = null, $soldAtSaleModeId = null)
    {
        $this
            ->setAllocationIds($allocationIds)
            ->setAreaId($areaId)
            ->setIsAvailable($isAvailable)
            ->setIsOccupiedByPeer($isOccupiedByPeer)
            ->setIsResale($isResale)
            ->setIsSubscriberSeat($isSubscriberSeat)
            ->setLockId($lockId)
            ->setPriceLevelId($priceLevelId)
            ->setResoldAtPricingDetails($resoldAtPricingDetails)
            ->setResoldAtPricingVariationId($resoldAtPricingVariationId)
            ->setRowName($rowName)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatingPlanId($seatingPlanId)
            ->setSeatName($seatName)
            ->setSeatStatus($seatStatus)
            ->setSectorName($sectorName)
            ->setSoldAtApplicationChannel($soldAtApplicationChannel)
            ->setSoldAtPriceLevelId($soldAtPriceLevelId)
            ->setSoldAtPriceTypeId($soldAtPriceTypeId)
            ->setSoldAtPricingDetails($soldAtPricingDetails)
            ->setSoldAtPricingVariationId($soldAtPricingVariationId)
            ->setSoldAtSaleModeId($soldAtSaleModeId);
    }
    /**
     * Get AllocationIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationIds()
    {
        return isset($this->AllocationIds) ? $this->AllocationIds : null;
    }
    /**
     * Set AllocationIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationIds
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setAllocationIds($allocationIds = null)
    {
        // validation for constraint: string
        if (!is_null($allocationIds) && !is_string($allocationIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationIds, true), gettype($allocationIds)), __LINE__);
        }
        if (is_null($allocationIds) || (is_array($allocationIds) && empty($allocationIds))) {
            unset($this->AllocationIds);
        } else {
            $this->AllocationIds = $allocationIds;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get IsAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailable()
    {
        return isset($this->IsAvailable) ? $this->IsAvailable : null;
    }
    /**
     * Set IsAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailable
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setIsAvailable($isAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailable) && !is_bool($isAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailable, true), gettype($isAvailable)), __LINE__);
        }
        if (is_null($isAvailable) || (is_array($isAvailable) && empty($isAvailable))) {
            unset($this->IsAvailable);
        } else {
            $this->IsAvailable = $isAvailable;
        }
        return $this;
    }
    /**
     * Get IsOccupiedByPeer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOccupiedByPeer()
    {
        return isset($this->IsOccupiedByPeer) ? $this->IsOccupiedByPeer : null;
    }
    /**
     * Set IsOccupiedByPeer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOccupiedByPeer
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setIsOccupiedByPeer($isOccupiedByPeer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOccupiedByPeer) && !is_bool($isOccupiedByPeer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOccupiedByPeer, true), gettype($isOccupiedByPeer)), __LINE__);
        }
        if (is_null($isOccupiedByPeer) || (is_array($isOccupiedByPeer) && empty($isOccupiedByPeer))) {
            unset($this->IsOccupiedByPeer);
        } else {
            $this->IsOccupiedByPeer = $isOccupiedByPeer;
        }
        return $this;
    }
    /**
     * Get IsResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsResale()
    {
        return isset($this->IsResale) ? $this->IsResale : null;
    }
    /**
     * Set IsResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isResale
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setIsResale($isResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResale) && !is_bool($isResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResale, true), gettype($isResale)), __LINE__);
        }
        if (is_null($isResale) || (is_array($isResale) && empty($isResale))) {
            unset($this->IsResale);
        } else {
            $this->IsResale = $isResale;
        }
        return $this;
    }
    /**
     * Get IsSubscriberSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubscriberSeat()
    {
        return isset($this->IsSubscriberSeat) ? $this->IsSubscriberSeat : null;
    }
    /**
     * Set IsSubscriberSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubscriberSeat
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setIsSubscriberSeat($isSubscriberSeat = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscriberSeat) && !is_bool($isSubscriberSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubscriberSeat, true), gettype($isSubscriberSeat)), __LINE__);
        }
        if (is_null($isSubscriberSeat) || (is_array($isSubscriberSeat) && empty($isSubscriberSeat))) {
            unset($this->IsSubscriberSeat);
        } else {
            $this->IsSubscriberSeat = $isSubscriberSeat;
        }
        return $this;
    }
    /**
     * Get LockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockId()
    {
        return isset($this->LockId) ? $this->LockId : null;
    }
    /**
     * Set LockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockId
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setLockId($lockId = null)
    {
        // validation for constraint: string
        if (!is_null($lockId) && !is_string($lockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockId, true), gettype($lockId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockId, true)), __LINE__);
        }
        if (is_null($lockId) || (is_array($lockId) && empty($lockId))) {
            unset($this->LockId);
        } else {
            $this->LockId = $lockId;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get ResoldAtPricingDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResoldAtPricingDetails()
    {
        return isset($this->ResoldAtPricingDetails) ? $this->ResoldAtPricingDetails : null;
    }
    /**
     * Set ResoldAtPricingDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resoldAtPricingDetails
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setResoldAtPricingDetails($resoldAtPricingDetails = null)
    {
        // validation for constraint: string
        if (!is_null($resoldAtPricingDetails) && !is_string($resoldAtPricingDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resoldAtPricingDetails, true), gettype($resoldAtPricingDetails)), __LINE__);
        }
        if (is_null($resoldAtPricingDetails) || (is_array($resoldAtPricingDetails) && empty($resoldAtPricingDetails))) {
            unset($this->ResoldAtPricingDetails);
        } else {
            $this->ResoldAtPricingDetails = $resoldAtPricingDetails;
        }
        return $this;
    }
    /**
     * Get ResoldAtPricingVariationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getResoldAtPricingVariationId()
    {
        return isset($this->ResoldAtPricingVariationId) ? $this->ResoldAtPricingVariationId : null;
    }
    /**
     * Set ResoldAtPricingVariationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $resoldAtPricingVariationId
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setResoldAtPricingVariationId($resoldAtPricingVariationId = null)
    {
        // validation for constraint: int
        if (!is_null($resoldAtPricingVariationId) && !(is_int($resoldAtPricingVariationId) || ctype_digit($resoldAtPricingVariationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resoldAtPricingVariationId, true), gettype($resoldAtPricingVariationId)), __LINE__);
        }
        if (is_null($resoldAtPricingVariationId) || (is_array($resoldAtPricingVariationId) && empty($resoldAtPricingVariationId))) {
            unset($this->ResoldAtPricingVariationId);
        } else {
            $this->ResoldAtPricingVariationId = $resoldAtPricingVariationId;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeatingPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanId()
    {
        return isset($this->SeatingPlanId) ? $this->SeatingPlanId : null;
    }
    /**
     * Set SeatingPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanId
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setSeatingPlanId($seatingPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanId) && !is_string($seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanId, true), gettype($seatingPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanId, true)), __LINE__);
        }
        if (is_null($seatingPlanId) || (is_array($seatingPlanId) && empty($seatingPlanId))) {
            unset($this->SeatingPlanId);
        } else {
            $this->SeatingPlanId = $seatingPlanId;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SeatStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatStatus()
    {
        return isset($this->SeatStatus) ? $this->SeatStatus : null;
    }
    /**
     * Set SeatStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatPropertyValues::valueIsValid()
     * @uses \patest\EnumType\SeatPropertyValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatStatus
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setSeatStatus($seatStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatPropertyValues::valueIsValid($seatStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatPropertyValues', is_array($seatStatus) ? implode(', ', $seatStatus) : var_export($seatStatus, true), implode(', ', \patest\EnumType\SeatPropertyValues::getValidValues())), __LINE__);
        }
        if (is_null($seatStatus) || (is_array($seatStatus) && empty($seatStatus))) {
            unset($this->SeatStatus);
        } else {
            $this->SeatStatus = $seatStatus;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SoldAtApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoldAtApplicationChannel()
    {
        return isset($this->SoldAtApplicationChannel) ? $this->SoldAtApplicationChannel : null;
    }
    /**
     * Set SoldAtApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $soldAtApplicationChannel
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setSoldAtApplicationChannel($soldAtApplicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($soldAtApplicationChannel) && !is_string($soldAtApplicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soldAtApplicationChannel, true), gettype($soldAtApplicationChannel)), __LINE__);
        }
        if (is_null($soldAtApplicationChannel) || (is_array($soldAtApplicationChannel) && empty($soldAtApplicationChannel))) {
            unset($this->SoldAtApplicationChannel);
        } else {
            $this->SoldAtApplicationChannel = $soldAtApplicationChannel;
        }
        return $this;
    }
    /**
     * Get SoldAtPriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoldAtPriceLevelId()
    {
        return isset($this->SoldAtPriceLevelId) ? $this->SoldAtPriceLevelId : null;
    }
    /**
     * Set SoldAtPriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $soldAtPriceLevelId
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setSoldAtPriceLevelId($soldAtPriceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($soldAtPriceLevelId) && !is_string($soldAtPriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soldAtPriceLevelId, true), gettype($soldAtPriceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($soldAtPriceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $soldAtPriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($soldAtPriceLevelId, true)), __LINE__);
        }
        if (is_null($soldAtPriceLevelId) || (is_array($soldAtPriceLevelId) && empty($soldAtPriceLevelId))) {
            unset($this->SoldAtPriceLevelId);
        } else {
            $this->SoldAtPriceLevelId = $soldAtPriceLevelId;
        }
        return $this;
    }
    /**
     * Get SoldAtPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoldAtPriceTypeId()
    {
        return isset($this->SoldAtPriceTypeId) ? $this->SoldAtPriceTypeId : null;
    }
    /**
     * Set SoldAtPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $soldAtPriceTypeId
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setSoldAtPriceTypeId($soldAtPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($soldAtPriceTypeId) && !is_string($soldAtPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soldAtPriceTypeId, true), gettype($soldAtPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($soldAtPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $soldAtPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($soldAtPriceTypeId, true)), __LINE__);
        }
        if (is_null($soldAtPriceTypeId) || (is_array($soldAtPriceTypeId) && empty($soldAtPriceTypeId))) {
            unset($this->SoldAtPriceTypeId);
        } else {
            $this->SoldAtPriceTypeId = $soldAtPriceTypeId;
        }
        return $this;
    }
    /**
     * Get SoldAtPricingDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoldAtPricingDetails()
    {
        return isset($this->SoldAtPricingDetails) ? $this->SoldAtPricingDetails : null;
    }
    /**
     * Set SoldAtPricingDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $soldAtPricingDetails
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setSoldAtPricingDetails($soldAtPricingDetails = null)
    {
        // validation for constraint: string
        if (!is_null($soldAtPricingDetails) && !is_string($soldAtPricingDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soldAtPricingDetails, true), gettype($soldAtPricingDetails)), __LINE__);
        }
        if (is_null($soldAtPricingDetails) || (is_array($soldAtPricingDetails) && empty($soldAtPricingDetails))) {
            unset($this->SoldAtPricingDetails);
        } else {
            $this->SoldAtPricingDetails = $soldAtPricingDetails;
        }
        return $this;
    }
    /**
     * Get SoldAtPricingVariationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSoldAtPricingVariationId()
    {
        return isset($this->SoldAtPricingVariationId) ? $this->SoldAtPricingVariationId : null;
    }
    /**
     * Set SoldAtPricingVariationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $soldAtPricingVariationId
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setSoldAtPricingVariationId($soldAtPricingVariationId = null)
    {
        // validation for constraint: int
        if (!is_null($soldAtPricingVariationId) && !(is_int($soldAtPricingVariationId) || ctype_digit($soldAtPricingVariationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldAtPricingVariationId, true), gettype($soldAtPricingVariationId)), __LINE__);
        }
        if (is_null($soldAtPricingVariationId) || (is_array($soldAtPricingVariationId) && empty($soldAtPricingVariationId))) {
            unset($this->SoldAtPricingVariationId);
        } else {
            $this->SoldAtPricingVariationId = $soldAtPricingVariationId;
        }
        return $this;
    }
    /**
     * Get SoldAtSaleModeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoldAtSaleModeId()
    {
        return isset($this->SoldAtSaleModeId) ? $this->SoldAtSaleModeId : null;
    }
    /**
     * Set SoldAtSaleModeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $soldAtSaleModeId
     * @return \patest\StructType\Ticketing_SeatingPlanSeatRuntimeInfo
     */
    public function setSoldAtSaleModeId($soldAtSaleModeId = null)
    {
        // validation for constraint: string
        if (!is_null($soldAtSaleModeId) && !is_string($soldAtSaleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soldAtSaleModeId, true), gettype($soldAtSaleModeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($soldAtSaleModeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $soldAtSaleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($soldAtSaleModeId, true)), __LINE__);
        }
        if (is_null($soldAtSaleModeId) || (is_array($soldAtSaleModeId) && empty($soldAtSaleModeId))) {
            unset($this->SoldAtSaleModeId);
        } else {
            $this->SoldAtSaleModeId = $soldAtSaleModeId;
        }
        return $this;
    }
}
