<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatingPlanLimitationInfo StructType
 * @subpackage Structs
 */
class Ticketing_SeatingPlanLimitationInfo extends AnyEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The AvailableCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvailableCount;
    /**
     * The ConsumedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConsumedCount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EffectiveLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EffectiveLimit;
    /**
     * The IdString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdString;
    /**
     * The LimitValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LimitValue;
    /**
     * The LimitValueType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LimitValueType;
    /**
     * The MatchingSeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MatchingSeatCount;
    /**
     * The QuotaRemainder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuotaRemainder;
    /**
     * The ReservedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReservedCount;
    /**
     * The SeatingPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanId;
    /**
     * The SoldCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SoldCount;
    /**
     * The TemporarilyHeldCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TemporarilyHeldCount;
    /**
     * Constructor method for Ticketing.SeatingPlanLimitationInfo
     * @uses Ticketing_SeatingPlanLimitationInfo::setAreaId()
     * @uses Ticketing_SeatingPlanLimitationInfo::setAreaName()
     * @uses Ticketing_SeatingPlanLimitationInfo::setAvailableCount()
     * @uses Ticketing_SeatingPlanLimitationInfo::setConsumedCount()
     * @uses Ticketing_SeatingPlanLimitationInfo::setDescription()
     * @uses Ticketing_SeatingPlanLimitationInfo::setEffectiveLimit()
     * @uses Ticketing_SeatingPlanLimitationInfo::setIdString()
     * @uses Ticketing_SeatingPlanLimitationInfo::setLimitValue()
     * @uses Ticketing_SeatingPlanLimitationInfo::setLimitValueType()
     * @uses Ticketing_SeatingPlanLimitationInfo::setMatchingSeatCount()
     * @uses Ticketing_SeatingPlanLimitationInfo::setQuotaRemainder()
     * @uses Ticketing_SeatingPlanLimitationInfo::setReservedCount()
     * @uses Ticketing_SeatingPlanLimitationInfo::setSeatingPlanId()
     * @uses Ticketing_SeatingPlanLimitationInfo::setSoldCount()
     * @uses Ticketing_SeatingPlanLimitationInfo::setTemporarilyHeldCount()
     * @param string $areaId
     * @param string $areaName
     * @param int $availableCount
     * @param int $consumedCount
     * @param string $description
     * @param int $effectiveLimit
     * @param string $idString
     * @param int $limitValue
     * @param string $limitValueType
     * @param int $matchingSeatCount
     * @param int $quotaRemainder
     * @param int $reservedCount
     * @param string $seatingPlanId
     * @param int $soldCount
     * @param int $temporarilyHeldCount
     */
    public function __construct($areaId = null, $areaName = null, $availableCount = null, $consumedCount = null, $description = null, $effectiveLimit = null, $idString = null, $limitValue = null, $limitValueType = null, $matchingSeatCount = null, $quotaRemainder = null, $reservedCount = null, $seatingPlanId = null, $soldCount = null, $temporarilyHeldCount = null)
    {
        $this
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setAvailableCount($availableCount)
            ->setConsumedCount($consumedCount)
            ->setDescription($description)
            ->setEffectiveLimit($effectiveLimit)
            ->setIdString($idString)
            ->setLimitValue($limitValue)
            ->setLimitValueType($limitValueType)
            ->setMatchingSeatCount($matchingSeatCount)
            ->setQuotaRemainder($quotaRemainder)
            ->setReservedCount($reservedCount)
            ->setSeatingPlanId($seatingPlanId)
            ->setSoldCount($soldCount)
            ->setTemporarilyHeldCount($temporarilyHeldCount);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get AvailableCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvailableCount()
    {
        return isset($this->AvailableCount) ? $this->AvailableCount : null;
    }
    /**
     * Set AvailableCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $availableCount
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setAvailableCount($availableCount = null)
    {
        // validation for constraint: int
        if (!is_null($availableCount) && !(is_int($availableCount) || ctype_digit($availableCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableCount, true), gettype($availableCount)), __LINE__);
        }
        if (is_null($availableCount) || (is_array($availableCount) && empty($availableCount))) {
            unset($this->AvailableCount);
        } else {
            $this->AvailableCount = $availableCount;
        }
        return $this;
    }
    /**
     * Get ConsumedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConsumedCount()
    {
        return isset($this->ConsumedCount) ? $this->ConsumedCount : null;
    }
    /**
     * Set ConsumedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $consumedCount
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setConsumedCount($consumedCount = null)
    {
        // validation for constraint: int
        if (!is_null($consumedCount) && !(is_int($consumedCount) || ctype_digit($consumedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consumedCount, true), gettype($consumedCount)), __LINE__);
        }
        if (is_null($consumedCount) || (is_array($consumedCount) && empty($consumedCount))) {
            unset($this->ConsumedCount);
        } else {
            $this->ConsumedCount = $consumedCount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectiveLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEffectiveLimit()
    {
        return isset($this->EffectiveLimit) ? $this->EffectiveLimit : null;
    }
    /**
     * Set EffectiveLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $effectiveLimit
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setEffectiveLimit($effectiveLimit = null)
    {
        // validation for constraint: int
        if (!is_null($effectiveLimit) && !(is_int($effectiveLimit) || ctype_digit($effectiveLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($effectiveLimit, true), gettype($effectiveLimit)), __LINE__);
        }
        if (is_null($effectiveLimit) || (is_array($effectiveLimit) && empty($effectiveLimit))) {
            unset($this->EffectiveLimit);
        } else {
            $this->EffectiveLimit = $effectiveLimit;
        }
        return $this;
    }
    /**
     * Get IdString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdString()
    {
        return isset($this->IdString) ? $this->IdString : null;
    }
    /**
     * Set IdString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idString
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setIdString($idString = null)
    {
        // validation for constraint: string
        if (!is_null($idString) && !is_string($idString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idString, true), gettype($idString)), __LINE__);
        }
        if (is_null($idString) || (is_array($idString) && empty($idString))) {
            unset($this->IdString);
        } else {
            $this->IdString = $idString;
        }
        return $this;
    }
    /**
     * Get LimitValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLimitValue()
    {
        return isset($this->LimitValue) ? $this->LimitValue : null;
    }
    /**
     * Set LimitValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $limitValue
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setLimitValue($limitValue = null)
    {
        // validation for constraint: int
        if (!is_null($limitValue) && !(is_int($limitValue) || ctype_digit($limitValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limitValue, true), gettype($limitValue)), __LINE__);
        }
        if (is_null($limitValue) || (is_array($limitValue) && empty($limitValue))) {
            unset($this->LimitValue);
        } else {
            $this->LimitValue = $limitValue;
        }
        return $this;
    }
    /**
     * Get LimitValueType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLimitValueType()
    {
        return isset($this->LimitValueType) ? $this->LimitValueType : null;
    }
    /**
     * Set LimitValueType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LimitationValueType::valueIsValid()
     * @uses \patest\EnumType\LimitationValueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $limitValueType
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setLimitValueType($limitValueType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LimitationValueType::valueIsValid($limitValueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LimitationValueType', is_array($limitValueType) ? implode(', ', $limitValueType) : var_export($limitValueType, true), implode(', ', \patest\EnumType\LimitationValueType::getValidValues())), __LINE__);
        }
        if (is_null($limitValueType) || (is_array($limitValueType) && empty($limitValueType))) {
            unset($this->LimitValueType);
        } else {
            $this->LimitValueType = $limitValueType;
        }
        return $this;
    }
    /**
     * Get MatchingSeatCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMatchingSeatCount()
    {
        return isset($this->MatchingSeatCount) ? $this->MatchingSeatCount : null;
    }
    /**
     * Set MatchingSeatCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $matchingSeatCount
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setMatchingSeatCount($matchingSeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($matchingSeatCount) && !(is_int($matchingSeatCount) || ctype_digit($matchingSeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matchingSeatCount, true), gettype($matchingSeatCount)), __LINE__);
        }
        if (is_null($matchingSeatCount) || (is_array($matchingSeatCount) && empty($matchingSeatCount))) {
            unset($this->MatchingSeatCount);
        } else {
            $this->MatchingSeatCount = $matchingSeatCount;
        }
        return $this;
    }
    /**
     * Get QuotaRemainder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuotaRemainder()
    {
        return isset($this->QuotaRemainder) ? $this->QuotaRemainder : null;
    }
    /**
     * Set QuotaRemainder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quotaRemainder
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setQuotaRemainder($quotaRemainder = null)
    {
        // validation for constraint: int
        if (!is_null($quotaRemainder) && !(is_int($quotaRemainder) || ctype_digit($quotaRemainder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quotaRemainder, true), gettype($quotaRemainder)), __LINE__);
        }
        if (is_null($quotaRemainder) || (is_array($quotaRemainder) && empty($quotaRemainder))) {
            unset($this->QuotaRemainder);
        } else {
            $this->QuotaRemainder = $quotaRemainder;
        }
        return $this;
    }
    /**
     * Get ReservedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReservedCount()
    {
        return isset($this->ReservedCount) ? $this->ReservedCount : null;
    }
    /**
     * Set ReservedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reservedCount
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setReservedCount($reservedCount = null)
    {
        // validation for constraint: int
        if (!is_null($reservedCount) && !(is_int($reservedCount) || ctype_digit($reservedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservedCount, true), gettype($reservedCount)), __LINE__);
        }
        if (is_null($reservedCount) || (is_array($reservedCount) && empty($reservedCount))) {
            unset($this->ReservedCount);
        } else {
            $this->ReservedCount = $reservedCount;
        }
        return $this;
    }
    /**
     * Get SeatingPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanId()
    {
        return isset($this->SeatingPlanId) ? $this->SeatingPlanId : null;
    }
    /**
     * Set SeatingPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanId
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setSeatingPlanId($seatingPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanId) && !is_string($seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanId, true), gettype($seatingPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanId, true)), __LINE__);
        }
        if (is_null($seatingPlanId) || (is_array($seatingPlanId) && empty($seatingPlanId))) {
            unset($this->SeatingPlanId);
        } else {
            $this->SeatingPlanId = $seatingPlanId;
        }
        return $this;
    }
    /**
     * Get SoldCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSoldCount()
    {
        return isset($this->SoldCount) ? $this->SoldCount : null;
    }
    /**
     * Set SoldCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $soldCount
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setSoldCount($soldCount = null)
    {
        // validation for constraint: int
        if (!is_null($soldCount) && !(is_int($soldCount) || ctype_digit($soldCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldCount, true), gettype($soldCount)), __LINE__);
        }
        if (is_null($soldCount) || (is_array($soldCount) && empty($soldCount))) {
            unset($this->SoldCount);
        } else {
            $this->SoldCount = $soldCount;
        }
        return $this;
    }
    /**
     * Get TemporarilyHeldCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTemporarilyHeldCount()
    {
        return isset($this->TemporarilyHeldCount) ? $this->TemporarilyHeldCount : null;
    }
    /**
     * Set TemporarilyHeldCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $temporarilyHeldCount
     * @return \patest\StructType\Ticketing_SeatingPlanLimitationInfo
     */
    public function setTemporarilyHeldCount($temporarilyHeldCount = null)
    {
        // validation for constraint: int
        if (!is_null($temporarilyHeldCount) && !(is_int($temporarilyHeldCount) || ctype_digit($temporarilyHeldCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($temporarilyHeldCount, true), gettype($temporarilyHeldCount)), __LINE__);
        }
        if (is_null($temporarilyHeldCount) || (is_array($temporarilyHeldCount) && empty($temporarilyHeldCount))) {
            unset($this->TemporarilyHeldCount);
        } else {
            $this->TemporarilyHeldCount = $temporarilyHeldCount;
        }
        return $this;
    }
}
