<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatUpgradesPolicyBase StructType
 * @subpackage Structs
 */
class Ticketing_SeatUpgradesPolicyBase extends PersistableEntity
{
    /**
     * The AllowedPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AllowedPriceTypes
     */
    public $AllowedPriceTypes;
    /**
     * The BlockedPriceTypeGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BlockedPriceTypeGroups
     */
    public $BlockedPriceTypeGroups;
    /**
     * The FallbackAllocationTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FallbackAllocationTypeId;
    /**
     * The IsPerformerPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPerformerPolicy;
    /**
     * The OverrideToPerformer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OverrideToPerformer;
    /**
     * The UpgradesEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpgradesEnabled;
    /**
     * Constructor method for Ticketing.SeatUpgradesPolicyBase
     * @uses Ticketing_SeatUpgradesPolicyBase::setAllowedPriceTypes()
     * @uses Ticketing_SeatUpgradesPolicyBase::setBlockedPriceTypeGroups()
     * @uses Ticketing_SeatUpgradesPolicyBase::setFallbackAllocationTypeId()
     * @uses Ticketing_SeatUpgradesPolicyBase::setIsPerformerPolicy()
     * @uses Ticketing_SeatUpgradesPolicyBase::setOverrideToPerformer()
     * @uses Ticketing_SeatUpgradesPolicyBase::setUpgradesEnabled()
     * @param \patest\StructType\AllowedPriceTypes $allowedPriceTypes
     * @param \patest\StructType\BlockedPriceTypeGroups $blockedPriceTypeGroups
     * @param string $fallbackAllocationTypeId
     * @param bool $isPerformerPolicy
     * @param bool $overrideToPerformer
     * @param bool $upgradesEnabled
     */
    public function __construct(\patest\StructType\AllowedPriceTypes $allowedPriceTypes = null, \patest\StructType\BlockedPriceTypeGroups $blockedPriceTypeGroups = null, $fallbackAllocationTypeId = null, $isPerformerPolicy = null, $overrideToPerformer = null, $upgradesEnabled = null)
    {
        $this
            ->setAllowedPriceTypes($allowedPriceTypes)
            ->setBlockedPriceTypeGroups($blockedPriceTypeGroups)
            ->setFallbackAllocationTypeId($fallbackAllocationTypeId)
            ->setIsPerformerPolicy($isPerformerPolicy)
            ->setOverrideToPerformer($overrideToPerformer)
            ->setUpgradesEnabled($upgradesEnabled);
    }
    /**
     * Get AllowedPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AllowedPriceTypes|null
     */
    public function getAllowedPriceTypes()
    {
        return isset($this->AllowedPriceTypes) ? $this->AllowedPriceTypes : null;
    }
    /**
     * Set AllowedPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AllowedPriceTypes $allowedPriceTypes
     * @return \patest\StructType\Ticketing_SeatUpgradesPolicyBase
     */
    public function setAllowedPriceTypes(\patest\StructType\AllowedPriceTypes $allowedPriceTypes = null)
    {
        if (is_null($allowedPriceTypes) || (is_array($allowedPriceTypes) && empty($allowedPriceTypes))) {
            unset($this->AllowedPriceTypes);
        } else {
            $this->AllowedPriceTypes = $allowedPriceTypes;
        }
        return $this;
    }
    /**
     * Get BlockedPriceTypeGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BlockedPriceTypeGroups|null
     */
    public function getBlockedPriceTypeGroups()
    {
        return isset($this->BlockedPriceTypeGroups) ? $this->BlockedPriceTypeGroups : null;
    }
    /**
     * Set BlockedPriceTypeGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BlockedPriceTypeGroups $blockedPriceTypeGroups
     * @return \patest\StructType\Ticketing_SeatUpgradesPolicyBase
     */
    public function setBlockedPriceTypeGroups(\patest\StructType\BlockedPriceTypeGroups $blockedPriceTypeGroups = null)
    {
        if (is_null($blockedPriceTypeGroups) || (is_array($blockedPriceTypeGroups) && empty($blockedPriceTypeGroups))) {
            unset($this->BlockedPriceTypeGroups);
        } else {
            $this->BlockedPriceTypeGroups = $blockedPriceTypeGroups;
        }
        return $this;
    }
    /**
     * Get FallbackAllocationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFallbackAllocationTypeId()
    {
        return isset($this->FallbackAllocationTypeId) ? $this->FallbackAllocationTypeId : null;
    }
    /**
     * Set FallbackAllocationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fallbackAllocationTypeId
     * @return \patest\StructType\Ticketing_SeatUpgradesPolicyBase
     */
    public function setFallbackAllocationTypeId($fallbackAllocationTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($fallbackAllocationTypeId) && !is_string($fallbackAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fallbackAllocationTypeId, true), gettype($fallbackAllocationTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fallbackAllocationTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fallbackAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fallbackAllocationTypeId, true)), __LINE__);
        }
        if (is_null($fallbackAllocationTypeId) || (is_array($fallbackAllocationTypeId) && empty($fallbackAllocationTypeId))) {
            unset($this->FallbackAllocationTypeId);
        } else {
            $this->FallbackAllocationTypeId = $fallbackAllocationTypeId;
        }
        return $this;
    }
    /**
     * Get IsPerformerPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPerformerPolicy()
    {
        return isset($this->IsPerformerPolicy) ? $this->IsPerformerPolicy : null;
    }
    /**
     * Set IsPerformerPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPerformerPolicy
     * @return \patest\StructType\Ticketing_SeatUpgradesPolicyBase
     */
    public function setIsPerformerPolicy($isPerformerPolicy = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPerformerPolicy) && !is_bool($isPerformerPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPerformerPolicy, true), gettype($isPerformerPolicy)), __LINE__);
        }
        if (is_null($isPerformerPolicy) || (is_array($isPerformerPolicy) && empty($isPerformerPolicy))) {
            unset($this->IsPerformerPolicy);
        } else {
            $this->IsPerformerPolicy = $isPerformerPolicy;
        }
        return $this;
    }
    /**
     * Get OverrideToPerformer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOverrideToPerformer()
    {
        return isset($this->OverrideToPerformer) ? $this->OverrideToPerformer : null;
    }
    /**
     * Set OverrideToPerformer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $overrideToPerformer
     * @return \patest\StructType\Ticketing_SeatUpgradesPolicyBase
     */
    public function setOverrideToPerformer($overrideToPerformer = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideToPerformer) && !is_bool($overrideToPerformer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideToPerformer, true), gettype($overrideToPerformer)), __LINE__);
        }
        if (is_null($overrideToPerformer) || (is_array($overrideToPerformer) && empty($overrideToPerformer))) {
            unset($this->OverrideToPerformer);
        } else {
            $this->OverrideToPerformer = $overrideToPerformer;
        }
        return $this;
    }
    /**
     * Get UpgradesEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpgradesEnabled()
    {
        return isset($this->UpgradesEnabled) ? $this->UpgradesEnabled : null;
    }
    /**
     * Set UpgradesEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $upgradesEnabled
     * @return \patest\StructType\Ticketing_SeatUpgradesPolicyBase
     */
    public function setUpgradesEnabled($upgradesEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($upgradesEnabled) && !is_bool($upgradesEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($upgradesEnabled, true), gettype($upgradesEnabled)), __LINE__);
        }
        if (is_null($upgradesEnabled) || (is_array($upgradesEnabled) && empty($upgradesEnabled))) {
            unset($this->UpgradesEnabled);
        } else {
            $this->UpgradesEnabled = $upgradesEnabled;
        }
        return $this;
    }
}
