<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.RelocationsPolicyBase StructType
 * @subpackage Structs
 */
class Ticketing_RelocationsPolicyBase extends PersistableEntity
{
    /**
     * The AccountCreditCategory
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountCreditCategory;
    /**
     * The AddOnsEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AddOnsEnabled;
    /**
     * The AllowPaymentConsolidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowPaymentConsolidation;
    /**
     * The CrossPlanEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CrossPlanEnabled;
    /**
     * The CrossRelocationAllowedForSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CrossRelocationAllowedForSeries
     */
    public $CrossRelocationAllowedForSeries;
    /**
     * The DefaultAddOnPriceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultAddOnPriceType;
    /**
     * The DefaultRestrictionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultRestrictionId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The DowngradesEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DowngradesEnabled;
    /**
     * The EndDatetime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDatetime;
    /**
     * The EndDatetimeUtc
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDatetimeUtc;
    /**
     * The MaxAddOns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxAddOns;
    /**
     * The MaxTotalSubs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTotalSubs;
    /**
     * The RelocateOutAllowedPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RelocateOutAllowedPriceTypes
     */
    public $RelocateOutAllowedPriceTypes;
    /**
     * The RelocateOutBlockedClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RelocateOutBlockedClientTypes
     */
    public $RelocateOutBlockedClientTypes;
    /**
     * The RelocateOutBlockedPriceLevels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RelocateOutBlockedPriceLevels
     */
    public $RelocateOutBlockedPriceLevels;
    /**
     * The RelocateOutBlockedPriceTypeGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RelocateOutBlockedPriceTypeGroups
     */
    public $RelocateOutBlockedPriceTypeGroups;
    /**
     * The RelocateOutBlockedType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $RelocateOutBlockedType;
    /**
     * The RelocateOutEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RelocateOutEnabled;
    /**
     * The RelocationPriceTypeMapping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_RelocationPriceTypeMapping
     */
    public $RelocationPriceTypeMapping;
    /**
     * Constructor method for Ticketing.RelocationsPolicyBase
     * @uses Ticketing_RelocationsPolicyBase::setAccountCreditCategory()
     * @uses Ticketing_RelocationsPolicyBase::setAddOnsEnabled()
     * @uses Ticketing_RelocationsPolicyBase::setAllowPaymentConsolidation()
     * @uses Ticketing_RelocationsPolicyBase::setCrossPlanEnabled()
     * @uses Ticketing_RelocationsPolicyBase::setCrossRelocationAllowedForSeries()
     * @uses Ticketing_RelocationsPolicyBase::setDefaultAddOnPriceType()
     * @uses Ticketing_RelocationsPolicyBase::setDefaultRestrictionId()
     * @uses Ticketing_RelocationsPolicyBase::setDescription()
     * @uses Ticketing_RelocationsPolicyBase::setDowngradesEnabled()
     * @uses Ticketing_RelocationsPolicyBase::setEndDatetime()
     * @uses Ticketing_RelocationsPolicyBase::setEndDatetimeUtc()
     * @uses Ticketing_RelocationsPolicyBase::setMaxAddOns()
     * @uses Ticketing_RelocationsPolicyBase::setMaxTotalSubs()
     * @uses Ticketing_RelocationsPolicyBase::setRelocateOutAllowedPriceTypes()
     * @uses Ticketing_RelocationsPolicyBase::setRelocateOutBlockedClientTypes()
     * @uses Ticketing_RelocationsPolicyBase::setRelocateOutBlockedPriceLevels()
     * @uses Ticketing_RelocationsPolicyBase::setRelocateOutBlockedPriceTypeGroups()
     * @uses Ticketing_RelocationsPolicyBase::setRelocateOutBlockedType()
     * @uses Ticketing_RelocationsPolicyBase::setRelocateOutEnabled()
     * @uses Ticketing_RelocationsPolicyBase::setRelocationPriceTypeMapping()
     * @param string $accountCreditCategory
     * @param bool $addOnsEnabled
     * @param bool $allowPaymentConsolidation
     * @param bool $crossPlanEnabled
     * @param \patest\StructType\CrossRelocationAllowedForSeries $crossRelocationAllowedForSeries
     * @param string $defaultAddOnPriceType
     * @param string $defaultRestrictionId
     * @param \patest\StructType\GlobalString $description
     * @param bool $downgradesEnabled
     * @param string $endDatetime
     * @param string $endDatetimeUtc
     * @param int $maxAddOns
     * @param int $maxTotalSubs
     * @param \patest\StructType\RelocateOutAllowedPriceTypes $relocateOutAllowedPriceTypes
     * @param \patest\StructType\RelocateOutBlockedClientTypes $relocateOutBlockedClientTypes
     * @param \patest\StructType\RelocateOutBlockedPriceLevels $relocateOutBlockedPriceLevels
     * @param \patest\StructType\RelocateOutBlockedPriceTypeGroups $relocateOutBlockedPriceTypeGroups
     * @param string[] $relocateOutBlockedType
     * @param bool $relocateOutEnabled
     * @param \patest\StructType\RecordSetOfTicketing_RelocationPriceTypeMapping $relocationPriceTypeMapping
     */
    public function __construct($accountCreditCategory = null, $addOnsEnabled = null, $allowPaymentConsolidation = null, $crossPlanEnabled = null, \patest\StructType\CrossRelocationAllowedForSeries $crossRelocationAllowedForSeries = null, $defaultAddOnPriceType = null, $defaultRestrictionId = null, \patest\StructType\GlobalString $description = null, $downgradesEnabled = null, $endDatetime = null, $endDatetimeUtc = null, $maxAddOns = null, $maxTotalSubs = null, \patest\StructType\RelocateOutAllowedPriceTypes $relocateOutAllowedPriceTypes = null, \patest\StructType\RelocateOutBlockedClientTypes $relocateOutBlockedClientTypes = null, \patest\StructType\RelocateOutBlockedPriceLevels $relocateOutBlockedPriceLevels = null, \patest\StructType\RelocateOutBlockedPriceTypeGroups $relocateOutBlockedPriceTypeGroups = null, array $relocateOutBlockedType = array(), $relocateOutEnabled = null, \patest\StructType\RecordSetOfTicketing_RelocationPriceTypeMapping $relocationPriceTypeMapping = null)
    {
        $this
            ->setAccountCreditCategory($accountCreditCategory)
            ->setAddOnsEnabled($addOnsEnabled)
            ->setAllowPaymentConsolidation($allowPaymentConsolidation)
            ->setCrossPlanEnabled($crossPlanEnabled)
            ->setCrossRelocationAllowedForSeries($crossRelocationAllowedForSeries)
            ->setDefaultAddOnPriceType($defaultAddOnPriceType)
            ->setDefaultRestrictionId($defaultRestrictionId)
            ->setDescription($description)
            ->setDowngradesEnabled($downgradesEnabled)
            ->setEndDatetime($endDatetime)
            ->setEndDatetimeUtc($endDatetimeUtc)
            ->setMaxAddOns($maxAddOns)
            ->setMaxTotalSubs($maxTotalSubs)
            ->setRelocateOutAllowedPriceTypes($relocateOutAllowedPriceTypes)
            ->setRelocateOutBlockedClientTypes($relocateOutBlockedClientTypes)
            ->setRelocateOutBlockedPriceLevels($relocateOutBlockedPriceLevels)
            ->setRelocateOutBlockedPriceTypeGroups($relocateOutBlockedPriceTypeGroups)
            ->setRelocateOutBlockedType($relocateOutBlockedType)
            ->setRelocateOutEnabled($relocateOutEnabled)
            ->setRelocationPriceTypeMapping($relocationPriceTypeMapping);
    }
    /**
     * Get AccountCreditCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountCreditCategory()
    {
        return isset($this->AccountCreditCategory) ? $this->AccountCreditCategory : null;
    }
    /**
     * Set AccountCreditCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountCreditCategory
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setAccountCreditCategory($accountCreditCategory = null)
    {
        // validation for constraint: string
        if (!is_null($accountCreditCategory) && !is_string($accountCreditCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCreditCategory, true), gettype($accountCreditCategory)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountCreditCategory) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountCreditCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountCreditCategory, true)), __LINE__);
        }
        if (is_null($accountCreditCategory) || (is_array($accountCreditCategory) && empty($accountCreditCategory))) {
            unset($this->AccountCreditCategory);
        } else {
            $this->AccountCreditCategory = $accountCreditCategory;
        }
        return $this;
    }
    /**
     * Get AddOnsEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAddOnsEnabled()
    {
        return isset($this->AddOnsEnabled) ? $this->AddOnsEnabled : null;
    }
    /**
     * Set AddOnsEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $addOnsEnabled
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setAddOnsEnabled($addOnsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($addOnsEnabled) && !is_bool($addOnsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addOnsEnabled, true), gettype($addOnsEnabled)), __LINE__);
        }
        if (is_null($addOnsEnabled) || (is_array($addOnsEnabled) && empty($addOnsEnabled))) {
            unset($this->AddOnsEnabled);
        } else {
            $this->AddOnsEnabled = $addOnsEnabled;
        }
        return $this;
    }
    /**
     * Get AllowPaymentConsolidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowPaymentConsolidation()
    {
        return isset($this->AllowPaymentConsolidation) ? $this->AllowPaymentConsolidation : null;
    }
    /**
     * Set AllowPaymentConsolidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowPaymentConsolidation
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setAllowPaymentConsolidation($allowPaymentConsolidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPaymentConsolidation) && !is_bool($allowPaymentConsolidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPaymentConsolidation, true), gettype($allowPaymentConsolidation)), __LINE__);
        }
        if (is_null($allowPaymentConsolidation) || (is_array($allowPaymentConsolidation) && empty($allowPaymentConsolidation))) {
            unset($this->AllowPaymentConsolidation);
        } else {
            $this->AllowPaymentConsolidation = $allowPaymentConsolidation;
        }
        return $this;
    }
    /**
     * Get CrossPlanEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCrossPlanEnabled()
    {
        return isset($this->CrossPlanEnabled) ? $this->CrossPlanEnabled : null;
    }
    /**
     * Set CrossPlanEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $crossPlanEnabled
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setCrossPlanEnabled($crossPlanEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($crossPlanEnabled) && !is_bool($crossPlanEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($crossPlanEnabled, true), gettype($crossPlanEnabled)), __LINE__);
        }
        if (is_null($crossPlanEnabled) || (is_array($crossPlanEnabled) && empty($crossPlanEnabled))) {
            unset($this->CrossPlanEnabled);
        } else {
            $this->CrossPlanEnabled = $crossPlanEnabled;
        }
        return $this;
    }
    /**
     * Get CrossRelocationAllowedForSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CrossRelocationAllowedForSeries|null
     */
    public function getCrossRelocationAllowedForSeries()
    {
        return isset($this->CrossRelocationAllowedForSeries) ? $this->CrossRelocationAllowedForSeries : null;
    }
    /**
     * Set CrossRelocationAllowedForSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CrossRelocationAllowedForSeries $crossRelocationAllowedForSeries
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setCrossRelocationAllowedForSeries(\patest\StructType\CrossRelocationAllowedForSeries $crossRelocationAllowedForSeries = null)
    {
        if (is_null($crossRelocationAllowedForSeries) || (is_array($crossRelocationAllowedForSeries) && empty($crossRelocationAllowedForSeries))) {
            unset($this->CrossRelocationAllowedForSeries);
        } else {
            $this->CrossRelocationAllowedForSeries = $crossRelocationAllowedForSeries;
        }
        return $this;
    }
    /**
     * Get DefaultAddOnPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultAddOnPriceType()
    {
        return isset($this->DefaultAddOnPriceType) ? $this->DefaultAddOnPriceType : null;
    }
    /**
     * Set DefaultAddOnPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultAddOnPriceType
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setDefaultAddOnPriceType($defaultAddOnPriceType = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAddOnPriceType) && !is_string($defaultAddOnPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAddOnPriceType, true), gettype($defaultAddOnPriceType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultAddOnPriceType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultAddOnPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultAddOnPriceType, true)), __LINE__);
        }
        if (is_null($defaultAddOnPriceType) || (is_array($defaultAddOnPriceType) && empty($defaultAddOnPriceType))) {
            unset($this->DefaultAddOnPriceType);
        } else {
            $this->DefaultAddOnPriceType = $defaultAddOnPriceType;
        }
        return $this;
    }
    /**
     * Get DefaultRestrictionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultRestrictionId()
    {
        return isset($this->DefaultRestrictionId) ? $this->DefaultRestrictionId : null;
    }
    /**
     * Set DefaultRestrictionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultRestrictionId
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setDefaultRestrictionId($defaultRestrictionId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultRestrictionId) && !is_string($defaultRestrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultRestrictionId, true), gettype($defaultRestrictionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultRestrictionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultRestrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultRestrictionId, true)), __LINE__);
        }
        if (is_null($defaultRestrictionId) || (is_array($defaultRestrictionId) && empty($defaultRestrictionId))) {
            unset($this->DefaultRestrictionId);
        } else {
            $this->DefaultRestrictionId = $defaultRestrictionId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DowngradesEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDowngradesEnabled()
    {
        return isset($this->DowngradesEnabled) ? $this->DowngradesEnabled : null;
    }
    /**
     * Set DowngradesEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $downgradesEnabled
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setDowngradesEnabled($downgradesEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($downgradesEnabled) && !is_bool($downgradesEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($downgradesEnabled, true), gettype($downgradesEnabled)), __LINE__);
        }
        if (is_null($downgradesEnabled) || (is_array($downgradesEnabled) && empty($downgradesEnabled))) {
            unset($this->DowngradesEnabled);
        } else {
            $this->DowngradesEnabled = $downgradesEnabled;
        }
        return $this;
    }
    /**
     * Get EndDatetime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDatetime()
    {
        return isset($this->EndDatetime) ? $this->EndDatetime : null;
    }
    /**
     * Set EndDatetime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDatetime
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setEndDatetime($endDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($endDatetime) && !is_string($endDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDatetime, true), gettype($endDatetime)), __LINE__);
        }
        if (is_null($endDatetime) || (is_array($endDatetime) && empty($endDatetime))) {
            unset($this->EndDatetime);
        } else {
            $this->EndDatetime = $endDatetime;
        }
        return $this;
    }
    /**
     * Get EndDatetimeUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDatetimeUtc()
    {
        return isset($this->EndDatetimeUtc) ? $this->EndDatetimeUtc : null;
    }
    /**
     * Set EndDatetimeUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDatetimeUtc
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setEndDatetimeUtc($endDatetimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($endDatetimeUtc) && !is_string($endDatetimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDatetimeUtc, true), gettype($endDatetimeUtc)), __LINE__);
        }
        if (is_null($endDatetimeUtc) || (is_array($endDatetimeUtc) && empty($endDatetimeUtc))) {
            unset($this->EndDatetimeUtc);
        } else {
            $this->EndDatetimeUtc = $endDatetimeUtc;
        }
        return $this;
    }
    /**
     * Get MaxAddOns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxAddOns()
    {
        return isset($this->MaxAddOns) ? $this->MaxAddOns : null;
    }
    /**
     * Set MaxAddOns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxAddOns
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setMaxAddOns($maxAddOns = null)
    {
        // validation for constraint: int
        if (!is_null($maxAddOns) && !(is_int($maxAddOns) || ctype_digit($maxAddOns))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAddOns, true), gettype($maxAddOns)), __LINE__);
        }
        if (is_null($maxAddOns) || (is_array($maxAddOns) && empty($maxAddOns))) {
            unset($this->MaxAddOns);
        } else {
            $this->MaxAddOns = $maxAddOns;
        }
        return $this;
    }
    /**
     * Get MaxTotalSubs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTotalSubs()
    {
        return isset($this->MaxTotalSubs) ? $this->MaxTotalSubs : null;
    }
    /**
     * Set MaxTotalSubs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTotalSubs
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setMaxTotalSubs($maxTotalSubs = null)
    {
        // validation for constraint: int
        if (!is_null($maxTotalSubs) && !(is_int($maxTotalSubs) || ctype_digit($maxTotalSubs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTotalSubs, true), gettype($maxTotalSubs)), __LINE__);
        }
        if (is_null($maxTotalSubs) || (is_array($maxTotalSubs) && empty($maxTotalSubs))) {
            unset($this->MaxTotalSubs);
        } else {
            $this->MaxTotalSubs = $maxTotalSubs;
        }
        return $this;
    }
    /**
     * Get RelocateOutAllowedPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RelocateOutAllowedPriceTypes|null
     */
    public function getRelocateOutAllowedPriceTypes()
    {
        return isset($this->RelocateOutAllowedPriceTypes) ? $this->RelocateOutAllowedPriceTypes : null;
    }
    /**
     * Set RelocateOutAllowedPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RelocateOutAllowedPriceTypes $relocateOutAllowedPriceTypes
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setRelocateOutAllowedPriceTypes(\patest\StructType\RelocateOutAllowedPriceTypes $relocateOutAllowedPriceTypes = null)
    {
        if (is_null($relocateOutAllowedPriceTypes) || (is_array($relocateOutAllowedPriceTypes) && empty($relocateOutAllowedPriceTypes))) {
            unset($this->RelocateOutAllowedPriceTypes);
        } else {
            $this->RelocateOutAllowedPriceTypes = $relocateOutAllowedPriceTypes;
        }
        return $this;
    }
    /**
     * Get RelocateOutBlockedClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RelocateOutBlockedClientTypes|null
     */
    public function getRelocateOutBlockedClientTypes()
    {
        return isset($this->RelocateOutBlockedClientTypes) ? $this->RelocateOutBlockedClientTypes : null;
    }
    /**
     * Set RelocateOutBlockedClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RelocateOutBlockedClientTypes $relocateOutBlockedClientTypes
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setRelocateOutBlockedClientTypes(\patest\StructType\RelocateOutBlockedClientTypes $relocateOutBlockedClientTypes = null)
    {
        if (is_null($relocateOutBlockedClientTypes) || (is_array($relocateOutBlockedClientTypes) && empty($relocateOutBlockedClientTypes))) {
            unset($this->RelocateOutBlockedClientTypes);
        } else {
            $this->RelocateOutBlockedClientTypes = $relocateOutBlockedClientTypes;
        }
        return $this;
    }
    /**
     * Get RelocateOutBlockedPriceLevels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RelocateOutBlockedPriceLevels|null
     */
    public function getRelocateOutBlockedPriceLevels()
    {
        return isset($this->RelocateOutBlockedPriceLevels) ? $this->RelocateOutBlockedPriceLevels : null;
    }
    /**
     * Set RelocateOutBlockedPriceLevels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RelocateOutBlockedPriceLevels $relocateOutBlockedPriceLevels
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setRelocateOutBlockedPriceLevels(\patest\StructType\RelocateOutBlockedPriceLevels $relocateOutBlockedPriceLevels = null)
    {
        if (is_null($relocateOutBlockedPriceLevels) || (is_array($relocateOutBlockedPriceLevels) && empty($relocateOutBlockedPriceLevels))) {
            unset($this->RelocateOutBlockedPriceLevels);
        } else {
            $this->RelocateOutBlockedPriceLevels = $relocateOutBlockedPriceLevels;
        }
        return $this;
    }
    /**
     * Get RelocateOutBlockedPriceTypeGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RelocateOutBlockedPriceTypeGroups|null
     */
    public function getRelocateOutBlockedPriceTypeGroups()
    {
        return isset($this->RelocateOutBlockedPriceTypeGroups) ? $this->RelocateOutBlockedPriceTypeGroups : null;
    }
    /**
     * Set RelocateOutBlockedPriceTypeGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RelocateOutBlockedPriceTypeGroups $relocateOutBlockedPriceTypeGroups
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setRelocateOutBlockedPriceTypeGroups(\patest\StructType\RelocateOutBlockedPriceTypeGroups $relocateOutBlockedPriceTypeGroups = null)
    {
        if (is_null($relocateOutBlockedPriceTypeGroups) || (is_array($relocateOutBlockedPriceTypeGroups) && empty($relocateOutBlockedPriceTypeGroups))) {
            unset($this->RelocateOutBlockedPriceTypeGroups);
        } else {
            $this->RelocateOutBlockedPriceTypeGroups = $relocateOutBlockedPriceTypeGroups;
        }
        return $this;
    }
    /**
     * Get RelocateOutBlockedType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getRelocateOutBlockedType()
    {
        return isset($this->RelocateOutBlockedType) ? $this->RelocateOutBlockedType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRelocateOutBlockedType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelocateOutBlockedType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelocateOutBlockedTypeForArrayConstraintsFromSetRelocateOutBlockedType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketing_RelocationsPolicyBaseRelocateOutBlockedTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\RelocationsPolicyBlockedType::valueIsValid($ticketing_RelocationsPolicyBaseRelocateOutBlockedTypeItem)) {
                $invalidValues[] = is_object($ticketing_RelocationsPolicyBaseRelocateOutBlockedTypeItem) ? get_class($ticketing_RelocationsPolicyBaseRelocateOutBlockedTypeItem) : sprintf('%s(%s)', gettype($ticketing_RelocationsPolicyBaseRelocateOutBlockedTypeItem), var_export($ticketing_RelocationsPolicyBaseRelocateOutBlockedTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RelocationsPolicyBlockedType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\RelocationsPolicyBlockedType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelocateOutBlockedType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RelocationsPolicyBlockedType::valueIsValid()
     * @uses \patest\EnumType\RelocationsPolicyBlockedType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $relocateOutBlockedType
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setRelocateOutBlockedType(array $relocateOutBlockedType = array())
    {
        // validation for constraint: list
        if ('' !== ($relocateOutBlockedTypeArrayErrorMessage = self::validateRelocateOutBlockedTypeForArrayConstraintsFromSetRelocateOutBlockedType($relocateOutBlockedType))) {
            throw new \InvalidArgumentException($relocateOutBlockedTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($relocateOutBlockedType) || (is_array($relocateOutBlockedType) && empty($relocateOutBlockedType))) {
            unset($this->RelocateOutBlockedType);
        } else {
            $this->RelocateOutBlockedType = is_array($relocateOutBlockedType) ? implode(' ', $relocateOutBlockedType) : null;
        }
        return $this;
    }
    /**
     * Get RelocateOutEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRelocateOutEnabled()
    {
        return isset($this->RelocateOutEnabled) ? $this->RelocateOutEnabled : null;
    }
    /**
     * Set RelocateOutEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $relocateOutEnabled
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setRelocateOutEnabled($relocateOutEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($relocateOutEnabled) && !is_bool($relocateOutEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($relocateOutEnabled, true), gettype($relocateOutEnabled)), __LINE__);
        }
        if (is_null($relocateOutEnabled) || (is_array($relocateOutEnabled) && empty($relocateOutEnabled))) {
            unset($this->RelocateOutEnabled);
        } else {
            $this->RelocateOutEnabled = $relocateOutEnabled;
        }
        return $this;
    }
    /**
     * Get RelocationPriceTypeMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_RelocationPriceTypeMapping|null
     */
    public function getRelocationPriceTypeMapping()
    {
        return isset($this->RelocationPriceTypeMapping) ? $this->RelocationPriceTypeMapping : null;
    }
    /**
     * Set RelocationPriceTypeMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_RelocationPriceTypeMapping $relocationPriceTypeMapping
     * @return \patest\StructType\Ticketing_RelocationsPolicyBase
     */
    public function setRelocationPriceTypeMapping(\patest\StructType\RecordSetOfTicketing_RelocationPriceTypeMapping $relocationPriceTypeMapping = null)
    {
        if (is_null($relocationPriceTypeMapping) || (is_array($relocationPriceTypeMapping) && empty($relocationPriceTypeMapping))) {
            unset($this->RelocationPriceTypeMapping);
        } else {
            $this->RelocationPriceTypeMapping = $relocationPriceTypeMapping;
        }
        return $this;
    }
}
