<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.RelocationWave StructType
 * @subpackage Structs
 */
class Ticketing_RelocationWave extends PersistableEntity
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NumLinkedAccounts
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumLinkedAccounts;
    /**
     * The RelatedSeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RelatedSeriesIds
     */
    public $RelatedSeriesIds;
    /**
     * The StartDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDateTime;
    /**
     * The StartDateTimeUtc
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDateTimeUtc;
    /**
     * Constructor method for Ticketing.RelocationWave
     * @uses Ticketing_RelocationWave::setName()
     * @uses Ticketing_RelocationWave::setNumLinkedAccounts()
     * @uses Ticketing_RelocationWave::setRelatedSeriesIds()
     * @uses Ticketing_RelocationWave::setStartDateTime()
     * @uses Ticketing_RelocationWave::setStartDateTimeUtc()
     * @param string $name
     * @param int $numLinkedAccounts
     * @param \patest\StructType\RelatedSeriesIds $relatedSeriesIds
     * @param string $startDateTime
     * @param string $startDateTimeUtc
     */
    public function __construct($name = null, $numLinkedAccounts = null, \patest\StructType\RelatedSeriesIds $relatedSeriesIds = null, $startDateTime = null, $startDateTimeUtc = null)
    {
        $this
            ->setName($name)
            ->setNumLinkedAccounts($numLinkedAccounts)
            ->setRelatedSeriesIds($relatedSeriesIds)
            ->setStartDateTime($startDateTime)
            ->setStartDateTimeUtc($startDateTimeUtc);
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Ticketing_RelocationWave
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumLinkedAccounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumLinkedAccounts()
    {
        return isset($this->NumLinkedAccounts) ? $this->NumLinkedAccounts : null;
    }
    /**
     * Set NumLinkedAccounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numLinkedAccounts
     * @return \patest\StructType\Ticketing_RelocationWave
     */
    public function setNumLinkedAccounts($numLinkedAccounts = null)
    {
        // validation for constraint: int
        if (!is_null($numLinkedAccounts) && !(is_int($numLinkedAccounts) || ctype_digit($numLinkedAccounts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numLinkedAccounts, true), gettype($numLinkedAccounts)), __LINE__);
        }
        if (is_null($numLinkedAccounts) || (is_array($numLinkedAccounts) && empty($numLinkedAccounts))) {
            unset($this->NumLinkedAccounts);
        } else {
            $this->NumLinkedAccounts = $numLinkedAccounts;
        }
        return $this;
    }
    /**
     * Get RelatedSeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RelatedSeriesIds|null
     */
    public function getRelatedSeriesIds()
    {
        return isset($this->RelatedSeriesIds) ? $this->RelatedSeriesIds : null;
    }
    /**
     * Set RelatedSeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RelatedSeriesIds $relatedSeriesIds
     * @return \patest\StructType\Ticketing_RelocationWave
     */
    public function setRelatedSeriesIds(\patest\StructType\RelatedSeriesIds $relatedSeriesIds = null)
    {
        if (is_null($relatedSeriesIds) || (is_array($relatedSeriesIds) && empty($relatedSeriesIds))) {
            unset($this->RelatedSeriesIds);
        } else {
            $this->RelatedSeriesIds = $relatedSeriesIds;
        }
        return $this;
    }
    /**
     * Get StartDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDateTime()
    {
        return isset($this->StartDateTime) ? $this->StartDateTime : null;
    }
    /**
     * Set StartDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDateTime
     * @return \patest\StructType\Ticketing_RelocationWave
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateTime, true), gettype($startDateTime)), __LINE__);
        }
        if (is_null($startDateTime) || (is_array($startDateTime) && empty($startDateTime))) {
            unset($this->StartDateTime);
        } else {
            $this->StartDateTime = $startDateTime;
        }
        return $this;
    }
    /**
     * Get StartDateTimeUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDateTimeUtc()
    {
        return isset($this->StartDateTimeUtc) ? $this->StartDateTimeUtc : null;
    }
    /**
     * Set StartDateTimeUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDateTimeUtc
     * @return \patest\StructType\Ticketing_RelocationWave
     */
    public function setStartDateTimeUtc($startDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTimeUtc) && !is_string($startDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateTimeUtc, true), gettype($startDateTimeUtc)), __LINE__);
        }
        if (is_null($startDateTimeUtc) || (is_array($startDateTimeUtc) && empty($startDateTimeUtc))) {
            unset($this->StartDateTimeUtc);
        } else {
            $this->StartDateTimeUtc = $startDateTimeUtc;
        }
        return $this;
    }
}
