<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.RelocationPriceTypeMapping StructType
 * @subpackage Structs
 */
class Ticketing_RelocationPriceTypeMapping extends PersistableEntity
{
    /**
     * The BasePriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BasePriceTypeId;
    /**
     * The DisplayValue
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayValue;
    /**
     * The RelosConfigId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelosConfigId;
    /**
     * The TargetPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPriceTypeId;
    /**
     * Constructor method for Ticketing.RelocationPriceTypeMapping
     * @uses Ticketing_RelocationPriceTypeMapping::setBasePriceTypeId()
     * @uses Ticketing_RelocationPriceTypeMapping::setDisplayValue()
     * @uses Ticketing_RelocationPriceTypeMapping::setRelosConfigId()
     * @uses Ticketing_RelocationPriceTypeMapping::setTargetPriceTypeId()
     * @param string $basePriceTypeId
     * @param string $displayValue
     * @param string $relosConfigId
     * @param string $targetPriceTypeId
     */
    public function __construct($basePriceTypeId = null, $displayValue = null, $relosConfigId = null, $targetPriceTypeId = null)
    {
        $this
            ->setBasePriceTypeId($basePriceTypeId)
            ->setDisplayValue($displayValue)
            ->setRelosConfigId($relosConfigId)
            ->setTargetPriceTypeId($targetPriceTypeId);
    }
    /**
     * Get BasePriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBasePriceTypeId()
    {
        return isset($this->BasePriceTypeId) ? $this->BasePriceTypeId : null;
    }
    /**
     * Set BasePriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $basePriceTypeId
     * @return \patest\StructType\Ticketing_RelocationPriceTypeMapping
     */
    public function setBasePriceTypeId($basePriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($basePriceTypeId) && !is_string($basePriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basePriceTypeId, true), gettype($basePriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($basePriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $basePriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($basePriceTypeId, true)), __LINE__);
        }
        if (is_null($basePriceTypeId) || (is_array($basePriceTypeId) && empty($basePriceTypeId))) {
            unset($this->BasePriceTypeId);
        } else {
            $this->BasePriceTypeId = $basePriceTypeId;
        }
        return $this;
    }
    /**
     * Get DisplayValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayValue()
    {
        return isset($this->DisplayValue) ? $this->DisplayValue : null;
    }
    /**
     * Set DisplayValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayValue
     * @return \patest\StructType\Ticketing_RelocationPriceTypeMapping
     */
    public function setDisplayValue($displayValue = null)
    {
        // validation for constraint: string
        if (!is_null($displayValue) && !is_string($displayValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayValue, true), gettype($displayValue)), __LINE__);
        }
        if (is_null($displayValue) || (is_array($displayValue) && empty($displayValue))) {
            unset($this->DisplayValue);
        } else {
            $this->DisplayValue = $displayValue;
        }
        return $this;
    }
    /**
     * Get RelosConfigId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelosConfigId()
    {
        return isset($this->RelosConfigId) ? $this->RelosConfigId : null;
    }
    /**
     * Set RelosConfigId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relosConfigId
     * @return \patest\StructType\Ticketing_RelocationPriceTypeMapping
     */
    public function setRelosConfigId($relosConfigId = null)
    {
        // validation for constraint: string
        if (!is_null($relosConfigId) && !is_string($relosConfigId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relosConfigId, true), gettype($relosConfigId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relosConfigId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relosConfigId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relosConfigId, true)), __LINE__);
        }
        if (is_null($relosConfigId) || (is_array($relosConfigId) && empty($relosConfigId))) {
            unset($this->RelosConfigId);
        } else {
            $this->RelosConfigId = $relosConfigId;
        }
        return $this;
    }
    /**
     * Get TargetPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPriceTypeId()
    {
        return isset($this->TargetPriceTypeId) ? $this->TargetPriceTypeId : null;
    }
    /**
     * Set TargetPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPriceTypeId
     * @return \patest\StructType\Ticketing_RelocationPriceTypeMapping
     */
    public function setTargetPriceTypeId($targetPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPriceTypeId) && !is_string($targetPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPriceTypeId, true), gettype($targetPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPriceTypeId, true)), __LINE__);
        }
        if (is_null($targetPriceTypeId) || (is_array($targetPriceTypeId) && empty($targetPriceTypeId))) {
            unset($this->TargetPriceTypeId);
        } else {
            $this->TargetPriceTypeId = $targetPriceTypeId;
        }
        return $this;
    }
}
