<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ProcessBallotLine StructType
 * @subpackage Structs
 */
class Ticketing_ProcessBallotLine extends AnyEntity
{
    /**
     * The AllocatedTickets
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllocatedTickets;
    /**
     * The Applicants
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Applicants;
    /**
     * The AvailableSeats
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvailableSeats;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelName;
    /**
     * The RequestedTickets
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RequestedTickets;
    /**
     * The SectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectionId;
    /**
     * The WonTickets
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WonTickets;
    /**
     * Constructor method for Ticketing.ProcessBallotLine
     * @uses Ticketing_ProcessBallotLine::setAllocatedTickets()
     * @uses Ticketing_ProcessBallotLine::setApplicants()
     * @uses Ticketing_ProcessBallotLine::setAvailableSeats()
     * @uses Ticketing_ProcessBallotLine::setPriceLevelName()
     * @uses Ticketing_ProcessBallotLine::setRequestedTickets()
     * @uses Ticketing_ProcessBallotLine::setSectionId()
     * @uses Ticketing_ProcessBallotLine::setWonTickets()
     * @param int $allocatedTickets
     * @param int $applicants
     * @param int $availableSeats
     * @param string $priceLevelName
     * @param int $requestedTickets
     * @param string $sectionId
     * @param int $wonTickets
     */
    public function __construct($allocatedTickets = null, $applicants = null, $availableSeats = null, $priceLevelName = null, $requestedTickets = null, $sectionId = null, $wonTickets = null)
    {
        $this
            ->setAllocatedTickets($allocatedTickets)
            ->setApplicants($applicants)
            ->setAvailableSeats($availableSeats)
            ->setPriceLevelName($priceLevelName)
            ->setRequestedTickets($requestedTickets)
            ->setSectionId($sectionId)
            ->setWonTickets($wonTickets);
    }
    /**
     * Get AllocatedTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllocatedTickets()
    {
        return isset($this->AllocatedTickets) ? $this->AllocatedTickets : null;
    }
    /**
     * Set AllocatedTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allocatedTickets
     * @return \patest\StructType\Ticketing_ProcessBallotLine
     */
    public function setAllocatedTickets($allocatedTickets = null)
    {
        // validation for constraint: int
        if (!is_null($allocatedTickets) && !(is_int($allocatedTickets) || ctype_digit($allocatedTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allocatedTickets, true), gettype($allocatedTickets)), __LINE__);
        }
        if (is_null($allocatedTickets) || (is_array($allocatedTickets) && empty($allocatedTickets))) {
            unset($this->AllocatedTickets);
        } else {
            $this->AllocatedTickets = $allocatedTickets;
        }
        return $this;
    }
    /**
     * Get Applicants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getApplicants()
    {
        return isset($this->Applicants) ? $this->Applicants : null;
    }
    /**
     * Set Applicants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $applicants
     * @return \patest\StructType\Ticketing_ProcessBallotLine
     */
    public function setApplicants($applicants = null)
    {
        // validation for constraint: int
        if (!is_null($applicants) && !(is_int($applicants) || ctype_digit($applicants))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicants, true), gettype($applicants)), __LINE__);
        }
        if (is_null($applicants) || (is_array($applicants) && empty($applicants))) {
            unset($this->Applicants);
        } else {
            $this->Applicants = $applicants;
        }
        return $this;
    }
    /**
     * Get AvailableSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvailableSeats()
    {
        return isset($this->AvailableSeats) ? $this->AvailableSeats : null;
    }
    /**
     * Set AvailableSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $availableSeats
     * @return \patest\StructType\Ticketing_ProcessBallotLine
     */
    public function setAvailableSeats($availableSeats = null)
    {
        // validation for constraint: int
        if (!is_null($availableSeats) && !(is_int($availableSeats) || ctype_digit($availableSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableSeats, true), gettype($availableSeats)), __LINE__);
        }
        if (is_null($availableSeats) || (is_array($availableSeats) && empty($availableSeats))) {
            unset($this->AvailableSeats);
        } else {
            $this->AvailableSeats = $availableSeats;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelName
     * @return \patest\StructType\Ticketing_ProcessBallotLine
     */
    public function setPriceLevelName($priceLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelName) && !is_string($priceLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelName, true), gettype($priceLevelName)), __LINE__);
        }
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get RequestedTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRequestedTickets()
    {
        return isset($this->RequestedTickets) ? $this->RequestedTickets : null;
    }
    /**
     * Set RequestedTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $requestedTickets
     * @return \patest\StructType\Ticketing_ProcessBallotLine
     */
    public function setRequestedTickets($requestedTickets = null)
    {
        // validation for constraint: int
        if (!is_null($requestedTickets) && !(is_int($requestedTickets) || ctype_digit($requestedTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedTickets, true), gettype($requestedTickets)), __LINE__);
        }
        if (is_null($requestedTickets) || (is_array($requestedTickets) && empty($requestedTickets))) {
            unset($this->RequestedTickets);
        } else {
            $this->RequestedTickets = $requestedTickets;
        }
        return $this;
    }
    /**
     * Get SectionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionId()
    {
        return isset($this->SectionId) ? $this->SectionId : null;
    }
    /**
     * Set SectionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionId
     * @return \patest\StructType\Ticketing_ProcessBallotLine
     */
    public function setSectionId($sectionId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionId) && !is_string($sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionId, true), gettype($sectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectionId, true)), __LINE__);
        }
        if (is_null($sectionId) || (is_array($sectionId) && empty($sectionId))) {
            unset($this->SectionId);
        } else {
            $this->SectionId = $sectionId;
        }
        return $this;
    }
    /**
     * Get WonTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWonTickets()
    {
        return isset($this->WonTickets) ? $this->WonTickets : null;
    }
    /**
     * Set WonTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $wonTickets
     * @return \patest\StructType\Ticketing_ProcessBallotLine
     */
    public function setWonTickets($wonTickets = null)
    {
        // validation for constraint: int
        if (!is_null($wonTickets) && !(is_int($wonTickets) || ctype_digit($wonTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wonTickets, true), gettype($wonTickets)), __LINE__);
        }
        if (is_null($wonTickets) || (is_array($wonTickets) && empty($wonTickets))) {
            unset($this->WonTickets);
        } else {
            $this->WonTickets = $wonTickets;
        }
        return $this;
    }
}
