<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Printing.ShowGenre StructType
 * @subpackage Structs
 */
class Ticketing_Printing_ShowGenre extends Printing_Item_ComplexProperty_Base
{
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalReference;
    /**
     * The GenreName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GenreName;
    /**
     * Constructor method for Ticketing.Printing.ShowGenre
     * @uses Ticketing_Printing_ShowGenre::setExternalReference()
     * @uses Ticketing_Printing_ShowGenre::setGenreName()
     * @param string $externalReference
     * @param \patest\StructType\GlobalString $genreName
     */
    public function __construct($externalReference = null, \patest\StructType\GlobalString $genreName = null)
    {
        $this
            ->setExternalReference($externalReference)
            ->setGenreName($genreName);
    }
    /**
     * Get ExternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalReference()
    {
        return isset($this->ExternalReference) ? $this->ExternalReference : null;
    }
    /**
     * Set ExternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalReference
     * @return \patest\StructType\Ticketing_Printing_ShowGenre
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        if (is_null($externalReference) || (is_array($externalReference) && empty($externalReference))) {
            unset($this->ExternalReference);
        } else {
            $this->ExternalReference = $externalReference;
        }
        return $this;
    }
    /**
     * Get GenreName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGenreName()
    {
        return isset($this->GenreName) ? $this->GenreName : null;
    }
    /**
     * Set GenreName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $genreName
     * @return \patest\StructType\Ticketing_Printing_ShowGenre
     */
    public function setGenreName(\patest\StructType\GlobalString $genreName = null)
    {
        if (is_null($genreName) || (is_array($genreName) && empty($genreName))) {
            unset($this->GenreName);
        } else {
            $this->GenreName = $genreName;
        }
        return $this;
    }
}
