<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Printing.SeriesSeason StructType
 * @subpackage Structs
 */
class Ticketing_Printing_SeriesSeason extends Printing_Item_ComplexProperty_Base
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The SeasonEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeasonEndDate;
    /**
     * The SeasonStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeasonStartDate;
    /**
     * Constructor method for Ticketing.Printing.SeriesSeason
     * @uses Ticketing_Printing_SeriesSeason::setName()
     * @uses Ticketing_Printing_SeriesSeason::setSeasonEndDate()
     * @uses Ticketing_Printing_SeriesSeason::setSeasonStartDate()
     * @param \patest\StructType\GlobalString $name
     * @param string $seasonEndDate
     * @param string $seasonStartDate
     */
    public function __construct(\patest\StructType\GlobalString $name = null, $seasonEndDate = null, $seasonStartDate = null)
    {
        $this
            ->setName($name)
            ->setSeasonEndDate($seasonEndDate)
            ->setSeasonStartDate($seasonStartDate);
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_Printing_SeriesSeason
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SeasonEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonEndDate()
    {
        return isset($this->SeasonEndDate) ? $this->SeasonEndDate : null;
    }
    /**
     * Set SeasonEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonEndDate
     * @return \patest\StructType\Ticketing_Printing_SeriesSeason
     */
    public function setSeasonEndDate($seasonEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($seasonEndDate) && !is_string($seasonEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonEndDate, true), gettype($seasonEndDate)), __LINE__);
        }
        if (is_null($seasonEndDate) || (is_array($seasonEndDate) && empty($seasonEndDate))) {
            unset($this->SeasonEndDate);
        } else {
            $this->SeasonEndDate = $seasonEndDate;
        }
        return $this;
    }
    /**
     * Get SeasonStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonStartDate()
    {
        return isset($this->SeasonStartDate) ? $this->SeasonStartDate : null;
    }
    /**
     * Set SeasonStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonStartDate
     * @return \patest\StructType\Ticketing_Printing_SeriesSeason
     */
    public function setSeasonStartDate($seasonStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($seasonStartDate) && !is_string($seasonStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonStartDate, true), gettype($seasonStartDate)), __LINE__);
        }
        if (is_null($seasonStartDate) || (is_array($seasonStartDate) && empty($seasonStartDate))) {
            unset($this->SeasonStartDate);
        } else {
            $this->SeasonStartDate = $seasonStartDate;
        }
        return $this;
    }
}
