<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.PayUnpaidTicketsByTicketSchemeLog StructType
 * @subpackage Structs
 */
class Ticketing_PayUnpaidTicketsByTicketSchemeLog extends PersistableEntity
{
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypes;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Errors;
    /**
     * The Events
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Events;
    /**
     * The PaidDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaidDate;
    /**
     * The PaymentMethods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethods;
    /**
     * The Population
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Population;
    /**
     * The Processed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Processed;
    /**
     * The ProcessedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessedByUserId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The TicketSchemes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketSchemes;
    /**
     * The WorkItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $WorkItemId;
    /**
     * Constructor method for Ticketing.PayUnpaidTicketsByTicketSchemeLog
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLog::setClientTypes()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLog::setErrors()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLog::setEvents()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLog::setPaidDate()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLog::setPaymentMethods()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLog::setPopulation()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLog::setProcessed()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLog::setProcessedByUserId()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLog::setState()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLog::setTicketSchemes()
     * @uses Ticketing_PayUnpaidTicketsByTicketSchemeLog::setWorkItemId()
     * @param string $clientTypes
     * @param int $errors
     * @param string $events
     * @param string $paidDate
     * @param string $paymentMethods
     * @param int $population
     * @param int $processed
     * @param string $processedByUserId
     * @param string $state
     * @param string $ticketSchemes
     * @param string $workItemId
     */
    public function __construct($clientTypes = null, $errors = null, $events = null, $paidDate = null, $paymentMethods = null, $population = null, $processed = null, $processedByUserId = null, $state = null, $ticketSchemes = null, $workItemId = null)
    {
        $this
            ->setClientTypes($clientTypes)
            ->setErrors($errors)
            ->setEvents($events)
            ->setPaidDate($paidDate)
            ->setPaymentMethods($paymentMethods)
            ->setPopulation($population)
            ->setProcessed($processed)
            ->setProcessedByUserId($processedByUserId)
            ->setState($state)
            ->setTicketSchemes($ticketSchemes)
            ->setWorkItemId($workItemId);
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypes
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLog
     */
    public function setClientTypes($clientTypes = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypes) && !is_string($clientTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypes, true), gettype($clientTypes)), __LINE__);
        }
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get Errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $errors
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLog
     */
    public function setErrors($errors = null)
    {
        // validation for constraint: int
        if (!is_null($errors) && !(is_int($errors) || ctype_digit($errors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errors, true), gettype($errors)), __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get Events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvents()
    {
        return isset($this->Events) ? $this->Events : null;
    }
    /**
     * Set Events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $events
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLog
     */
    public function setEvents($events = null)
    {
        // validation for constraint: string
        if (!is_null($events) && !is_string($events)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($events, true), gettype($events)), __LINE__);
        }
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->Events);
        } else {
            $this->Events = $events;
        }
        return $this;
    }
    /**
     * Get PaidDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaidDate()
    {
        return isset($this->PaidDate) ? $this->PaidDate : null;
    }
    /**
     * Set PaidDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paidDate
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLog
     */
    public function setPaidDate($paidDate = null)
    {
        // validation for constraint: string
        if (!is_null($paidDate) && !is_string($paidDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidDate, true), gettype($paidDate)), __LINE__);
        }
        if (is_null($paidDate) || (is_array($paidDate) && empty($paidDate))) {
            unset($this->PaidDate);
        } else {
            $this->PaidDate = $paidDate;
        }
        return $this;
    }
    /**
     * Get PaymentMethods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethods()
    {
        return isset($this->PaymentMethods) ? $this->PaymentMethods : null;
    }
    /**
     * Set PaymentMethods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethods
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLog
     */
    public function setPaymentMethods($paymentMethods = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethods) && !is_string($paymentMethods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethods, true), gettype($paymentMethods)), __LINE__);
        }
        if (is_null($paymentMethods) || (is_array($paymentMethods) && empty($paymentMethods))) {
            unset($this->PaymentMethods);
        } else {
            $this->PaymentMethods = $paymentMethods;
        }
        return $this;
    }
    /**
     * Get Population value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPopulation()
    {
        return isset($this->Population) ? $this->Population : null;
    }
    /**
     * Set Population value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $population
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLog
     */
    public function setPopulation($population = null)
    {
        // validation for constraint: int
        if (!is_null($population) && !(is_int($population) || ctype_digit($population))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($population, true), gettype($population)), __LINE__);
        }
        if (is_null($population) || (is_array($population) && empty($population))) {
            unset($this->Population);
        } else {
            $this->Population = $population;
        }
        return $this;
    }
    /**
     * Get Processed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProcessed()
    {
        return isset($this->Processed) ? $this->Processed : null;
    }
    /**
     * Set Processed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $processed
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLog
     */
    public function setProcessed($processed = null)
    {
        // validation for constraint: int
        if (!is_null($processed) && !(is_int($processed) || ctype_digit($processed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processed, true), gettype($processed)), __LINE__);
        }
        if (is_null($processed) || (is_array($processed) && empty($processed))) {
            unset($this->Processed);
        } else {
            $this->Processed = $processed;
        }
        return $this;
    }
    /**
     * Get ProcessedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessedByUserId()
    {
        return isset($this->ProcessedByUserId) ? $this->ProcessedByUserId : null;
    }
    /**
     * Set ProcessedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processedByUserId
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLog
     */
    public function setProcessedByUserId($processedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($processedByUserId) && !is_string($processedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processedByUserId, true), gettype($processedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($processedByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($processedByUserId, true)), __LINE__);
        }
        if (is_null($processedByUserId) || (is_array($processedByUserId) && empty($processedByUserId))) {
            unset($this->ProcessedByUserId);
        } else {
            $this->ProcessedByUserId = $processedByUserId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FulfillmentExecutionState::valueIsValid()
     * @uses \patest\EnumType\FulfillmentExecutionState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLog
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FulfillmentExecutionState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FulfillmentExecutionState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\FulfillmentExecutionState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get TicketSchemes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSchemes()
    {
        return isset($this->TicketSchemes) ? $this->TicketSchemes : null;
    }
    /**
     * Set TicketSchemes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSchemes
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLog
     */
    public function setTicketSchemes($ticketSchemes = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemes) && !is_string($ticketSchemes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemes, true), gettype($ticketSchemes)), __LINE__);
        }
        if (is_null($ticketSchemes) || (is_array($ticketSchemes) && empty($ticketSchemes))) {
            unset($this->TicketSchemes);
        } else {
            $this->TicketSchemes = $ticketSchemes;
        }
        return $this;
    }
    /**
     * Get WorkItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkItemId()
    {
        return isset($this->WorkItemId) ? $this->WorkItemId : null;
    }
    /**
     * Set WorkItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workItemId
     * @return \patest\StructType\Ticketing_PayUnpaidTicketsByTicketSchemeLog
     */
    public function setWorkItemId($workItemId = null)
    {
        // validation for constraint: string
        if (!is_null($workItemId) && !is_string($workItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workItemId, true), gettype($workItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($workItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $workItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($workItemId, true)), __LINE__);
        }
        if (is_null($workItemId) || (is_array($workItemId) && empty($workItemId))) {
            unset($this->WorkItemId);
        } else {
            $this->WorkItemId = $workItemId;
        }
        return $this;
    }
}
