<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.PartyClient StructType
 * @subpackage Structs
 */
class Ticketing_PartyClient extends PersistableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The DeletionAdminClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeletionAdminClientId;
    /**
     * The DeletionDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeletionDateTime;
    /**
     * The LastTicketRevokedDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastTicketRevokedDateTime;
    /**
     * The PartyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PartyId;
    /**
     * Constructor method for Ticketing.PartyClient
     * @uses Ticketing_PartyClient::setClientId()
     * @uses Ticketing_PartyClient::setCreationDateTime()
     * @uses Ticketing_PartyClient::setDeletionAdminClientId()
     * @uses Ticketing_PartyClient::setDeletionDateTime()
     * @uses Ticketing_PartyClient::setLastTicketRevokedDateTime()
     * @uses Ticketing_PartyClient::setPartyId()
     * @param string $clientId
     * @param string $creationDateTime
     * @param string $deletionAdminClientId
     * @param string $deletionDateTime
     * @param string $lastTicketRevokedDateTime
     * @param string $partyId
     */
    public function __construct($clientId = null, $creationDateTime = null, $deletionAdminClientId = null, $deletionDateTime = null, $lastTicketRevokedDateTime = null, $partyId = null)
    {
        $this
            ->setClientId($clientId)
            ->setCreationDateTime($creationDateTime)
            ->setDeletionAdminClientId($deletionAdminClientId)
            ->setDeletionDateTime($deletionDateTime)
            ->setLastTicketRevokedDateTime($lastTicketRevokedDateTime)
            ->setPartyId($partyId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_PartyClient
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Ticketing_PartyClient
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get DeletionAdminClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeletionAdminClientId()
    {
        return isset($this->DeletionAdminClientId) ? $this->DeletionAdminClientId : null;
    }
    /**
     * Set DeletionAdminClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deletionAdminClientId
     * @return \patest\StructType\Ticketing_PartyClient
     */
    public function setDeletionAdminClientId($deletionAdminClientId = null)
    {
        // validation for constraint: string
        if (!is_null($deletionAdminClientId) && !is_string($deletionAdminClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deletionAdminClientId, true), gettype($deletionAdminClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deletionAdminClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deletionAdminClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deletionAdminClientId, true)), __LINE__);
        }
        if (is_null($deletionAdminClientId) || (is_array($deletionAdminClientId) && empty($deletionAdminClientId))) {
            unset($this->DeletionAdminClientId);
        } else {
            $this->DeletionAdminClientId = $deletionAdminClientId;
        }
        return $this;
    }
    /**
     * Get DeletionDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeletionDateTime()
    {
        return isset($this->DeletionDateTime) ? $this->DeletionDateTime : null;
    }
    /**
     * Set DeletionDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deletionDateTime
     * @return \patest\StructType\Ticketing_PartyClient
     */
    public function setDeletionDateTime($deletionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($deletionDateTime) && !is_string($deletionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deletionDateTime, true), gettype($deletionDateTime)), __LINE__);
        }
        if (is_null($deletionDateTime) || (is_array($deletionDateTime) && empty($deletionDateTime))) {
            unset($this->DeletionDateTime);
        } else {
            $this->DeletionDateTime = $deletionDateTime;
        }
        return $this;
    }
    /**
     * Get LastTicketRevokedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastTicketRevokedDateTime()
    {
        return isset($this->LastTicketRevokedDateTime) ? $this->LastTicketRevokedDateTime : null;
    }
    /**
     * Set LastTicketRevokedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastTicketRevokedDateTime
     * @return \patest\StructType\Ticketing_PartyClient
     */
    public function setLastTicketRevokedDateTime($lastTicketRevokedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastTicketRevokedDateTime) && !is_string($lastTicketRevokedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastTicketRevokedDateTime, true), gettype($lastTicketRevokedDateTime)), __LINE__);
        }
        if (is_null($lastTicketRevokedDateTime) || (is_array($lastTicketRevokedDateTime) && empty($lastTicketRevokedDateTime))) {
            unset($this->LastTicketRevokedDateTime);
        } else {
            $this->LastTicketRevokedDateTime = $lastTicketRevokedDateTime;
        }
        return $this;
    }
    /**
     * Get PartyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartyId()
    {
        return isset($this->PartyId) ? $this->PartyId : null;
    }
    /**
     * Set PartyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partyId
     * @return \patest\StructType\Ticketing_PartyClient
     */
    public function setPartyId($partyId = null)
    {
        // validation for constraint: string
        if (!is_null($partyId) && !is_string($partyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyId, true), gettype($partyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($partyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $partyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($partyId, true)), __LINE__);
        }
        if (is_null($partyId) || (is_array($partyId) && empty($partyId))) {
            unset($this->PartyId);
        } else {
            $this->PartyId = $partyId;
        }
        return $this;
    }
}
