<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.MobiliseTicketDownload StructType
 * @subpackage Structs
 */
class Ticketing_MobiliseTicketDownload extends PersistableEntity
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The FanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FanId;
    /**
     * The GenerationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GenerationId;
    /**
     * The NumberOfTimesDownloaded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfTimesDownloaded;
    /**
     * The PurchaserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserId;
    /**
     * The TicketBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketBarcode;
    /**
     * The TicketDownloadDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketDownloadDateTime;
    /**
     * The TicketDownloadStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketDownloadStatus;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * The TicketOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketOwnerId;
    /**
     * Constructor method for Ticketing.MobiliseTicketDownload
     * @uses Ticketing_MobiliseTicketDownload::setEventId()
     * @uses Ticketing_MobiliseTicketDownload::setFanId()
     * @uses Ticketing_MobiliseTicketDownload::setGenerationId()
     * @uses Ticketing_MobiliseTicketDownload::setNumberOfTimesDownloaded()
     * @uses Ticketing_MobiliseTicketDownload::setPurchaserId()
     * @uses Ticketing_MobiliseTicketDownload::setTicketBarcode()
     * @uses Ticketing_MobiliseTicketDownload::setTicketDownloadDateTime()
     * @uses Ticketing_MobiliseTicketDownload::setTicketDownloadStatus()
     * @uses Ticketing_MobiliseTicketDownload::setTicketId()
     * @uses Ticketing_MobiliseTicketDownload::setTicketOwnerId()
     * @param string $eventId
     * @param string $fanId
     * @param string $generationId
     * @param int $numberOfTimesDownloaded
     * @param string $purchaserId
     * @param string $ticketBarcode
     * @param string $ticketDownloadDateTime
     * @param string $ticketDownloadStatus
     * @param string $ticketId
     * @param string $ticketOwnerId
     */
    public function __construct($eventId = null, $fanId = null, $generationId = null, $numberOfTimesDownloaded = null, $purchaserId = null, $ticketBarcode = null, $ticketDownloadDateTime = null, $ticketDownloadStatus = null, $ticketId = null, $ticketOwnerId = null)
    {
        $this
            ->setEventId($eventId)
            ->setFanId($fanId)
            ->setGenerationId($generationId)
            ->setNumberOfTimesDownloaded($numberOfTimesDownloaded)
            ->setPurchaserId($purchaserId)
            ->setTicketBarcode($ticketBarcode)
            ->setTicketDownloadDateTime($ticketDownloadDateTime)
            ->setTicketDownloadStatus($ticketDownloadStatus)
            ->setTicketId($ticketId)
            ->setTicketOwnerId($ticketOwnerId);
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_MobiliseTicketDownload
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get FanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFanId()
    {
        return isset($this->FanId) ? $this->FanId : null;
    }
    /**
     * Set FanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fanId
     * @return \patest\StructType\Ticketing_MobiliseTicketDownload
     */
    public function setFanId($fanId = null)
    {
        // validation for constraint: string
        if (!is_null($fanId) && !is_string($fanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fanId, true), gettype($fanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fanId, true)), __LINE__);
        }
        if (is_null($fanId) || (is_array($fanId) && empty($fanId))) {
            unset($this->FanId);
        } else {
            $this->FanId = $fanId;
        }
        return $this;
    }
    /**
     * Get GenerationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGenerationId()
    {
        return isset($this->GenerationId) ? $this->GenerationId : null;
    }
    /**
     * Set GenerationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generationId
     * @return \patest\StructType\Ticketing_MobiliseTicketDownload
     */
    public function setGenerationId($generationId = null)
    {
        // validation for constraint: string
        if (!is_null($generationId) && !is_string($generationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generationId, true), gettype($generationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($generationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $generationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($generationId, true)), __LINE__);
        }
        if (is_null($generationId) || (is_array($generationId) && empty($generationId))) {
            unset($this->GenerationId);
        } else {
            $this->GenerationId = $generationId;
        }
        return $this;
    }
    /**
     * Get NumberOfTimesDownloaded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfTimesDownloaded()
    {
        return isset($this->NumberOfTimesDownloaded) ? $this->NumberOfTimesDownloaded : null;
    }
    /**
     * Set NumberOfTimesDownloaded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfTimesDownloaded
     * @return \patest\StructType\Ticketing_MobiliseTicketDownload
     */
    public function setNumberOfTimesDownloaded($numberOfTimesDownloaded = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfTimesDownloaded) && !(is_int($numberOfTimesDownloaded) || ctype_digit($numberOfTimesDownloaded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfTimesDownloaded, true), gettype($numberOfTimesDownloaded)), __LINE__);
        }
        if (is_null($numberOfTimesDownloaded) || (is_array($numberOfTimesDownloaded) && empty($numberOfTimesDownloaded))) {
            unset($this->NumberOfTimesDownloaded);
        } else {
            $this->NumberOfTimesDownloaded = $numberOfTimesDownloaded;
        }
        return $this;
    }
    /**
     * Get PurchaserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserId()
    {
        return isset($this->PurchaserId) ? $this->PurchaserId : null;
    }
    /**
     * Set PurchaserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserId
     * @return \patest\StructType\Ticketing_MobiliseTicketDownload
     */
    public function setPurchaserId($purchaserId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserId) && !is_string($purchaserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserId, true), gettype($purchaserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserId, true)), __LINE__);
        }
        if (is_null($purchaserId) || (is_array($purchaserId) && empty($purchaserId))) {
            unset($this->PurchaserId);
        } else {
            $this->PurchaserId = $purchaserId;
        }
        return $this;
    }
    /**
     * Get TicketBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketBarcode()
    {
        return isset($this->TicketBarcode) ? $this->TicketBarcode : null;
    }
    /**
     * Set TicketBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketBarcode
     * @return \patest\StructType\Ticketing_MobiliseTicketDownload
     */
    public function setTicketBarcode($ticketBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketBarcode) && !is_string($ticketBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketBarcode, true), gettype($ticketBarcode)), __LINE__);
        }
        if (is_null($ticketBarcode) || (is_array($ticketBarcode) && empty($ticketBarcode))) {
            unset($this->TicketBarcode);
        } else {
            $this->TicketBarcode = $ticketBarcode;
        }
        return $this;
    }
    /**
     * Get TicketDownloadDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketDownloadDateTime()
    {
        return isset($this->TicketDownloadDateTime) ? $this->TicketDownloadDateTime : null;
    }
    /**
     * Set TicketDownloadDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketDownloadDateTime
     * @return \patest\StructType\Ticketing_MobiliseTicketDownload
     */
    public function setTicketDownloadDateTime($ticketDownloadDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDownloadDateTime) && !is_string($ticketDownloadDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDownloadDateTime, true), gettype($ticketDownloadDateTime)), __LINE__);
        }
        if (is_null($ticketDownloadDateTime) || (is_array($ticketDownloadDateTime) && empty($ticketDownloadDateTime))) {
            unset($this->TicketDownloadDateTime);
        } else {
            $this->TicketDownloadDateTime = $ticketDownloadDateTime;
        }
        return $this;
    }
    /**
     * Get TicketDownloadStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketDownloadStatus()
    {
        return isset($this->TicketDownloadStatus) ? $this->TicketDownloadStatus : null;
    }
    /**
     * Set TicketDownloadStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketDownloadStatus::valueIsValid()
     * @uses \patest\EnumType\TicketDownloadStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketDownloadStatus
     * @return \patest\StructType\Ticketing_MobiliseTicketDownload
     */
    public function setTicketDownloadStatus($ticketDownloadStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketDownloadStatus::valueIsValid($ticketDownloadStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketDownloadStatus', is_array($ticketDownloadStatus) ? implode(', ', $ticketDownloadStatus) : var_export($ticketDownloadStatus, true), implode(', ', \patest\EnumType\TicketDownloadStatus::getValidValues())), __LINE__);
        }
        if (is_null($ticketDownloadStatus) || (is_array($ticketDownloadStatus) && empty($ticketDownloadStatus))) {
            unset($this->TicketDownloadStatus);
        } else {
            $this->TicketDownloadStatus = $ticketDownloadStatus;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\Ticketing_MobiliseTicketDownload
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
    /**
     * Get TicketOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketOwnerId()
    {
        return isset($this->TicketOwnerId) ? $this->TicketOwnerId : null;
    }
    /**
     * Set TicketOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketOwnerId
     * @return \patest\StructType\Ticketing_MobiliseTicketDownload
     */
    public function setTicketOwnerId($ticketOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketOwnerId) && !is_string($ticketOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketOwnerId, true), gettype($ticketOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketOwnerId, true)), __LINE__);
        }
        if (is_null($ticketOwnerId) || (is_array($ticketOwnerId) && empty($ticketOwnerId))) {
            unset($this->TicketOwnerId);
        } else {
            $this->TicketOwnerId = $ticketOwnerId;
        }
        return $this;
    }
}
