<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Limitation StructType
 * @subpackage Structs
 */
class Ticketing_Limitation extends PersistableEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AreaName;
    /**
     * The LimitationAppliesTo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LimitationAppliesTo;
    /**
     * The LimitationGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LimitationGroupId;
    /**
     * The LimitValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LimitValue;
    /**
     * The LimitValueType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LimitValueType;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceLevelName;
    /**
     * The PriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypes
     */
    public $PriceTypes;
    /**
     * The ScopeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScopeId;
    /**
     * The ScopeNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScopeNumber;
    /**
     * The ScopeType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScopeType;
    /**
     * Constructor method for Ticketing.Limitation
     * @uses Ticketing_Limitation::setAreaId()
     * @uses Ticketing_Limitation::setAreaName()
     * @uses Ticketing_Limitation::setLimitationAppliesTo()
     * @uses Ticketing_Limitation::setLimitationGroupId()
     * @uses Ticketing_Limitation::setLimitValue()
     * @uses Ticketing_Limitation::setLimitValueType()
     * @uses Ticketing_Limitation::setPriceLevelId()
     * @uses Ticketing_Limitation::setPriceLevelName()
     * @uses Ticketing_Limitation::setPriceTypes()
     * @uses Ticketing_Limitation::setScopeId()
     * @uses Ticketing_Limitation::setScopeNumber()
     * @uses Ticketing_Limitation::setScopeType()
     * @param string $areaId
     * @param \patest\StructType\GlobalString $areaName
     * @param string $limitationAppliesTo
     * @param string $limitationGroupId
     * @param int $limitValue
     * @param string $limitValueType
     * @param string $priceLevelId
     * @param \patest\StructType\GlobalString $priceLevelName
     * @param \patest\StructType\PriceTypes $priceTypes
     * @param string $scopeId
     * @param int $scopeNumber
     * @param string $scopeType
     */
    public function __construct($areaId = null, \patest\StructType\GlobalString $areaName = null, $limitationAppliesTo = null, $limitationGroupId = null, $limitValue = null, $limitValueType = null, $priceLevelId = null, \patest\StructType\GlobalString $priceLevelName = null, \patest\StructType\PriceTypes $priceTypes = null, $scopeId = null, $scopeNumber = null, $scopeType = null)
    {
        $this
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setLimitationAppliesTo($limitationAppliesTo)
            ->setLimitationGroupId($limitationGroupId)
            ->setLimitValue($limitValue)
            ->setLimitValueType($limitValueType)
            ->setPriceLevelId($priceLevelId)
            ->setPriceLevelName($priceLevelName)
            ->setPriceTypes($priceTypes)
            ->setScopeId($scopeId)
            ->setScopeNumber($scopeNumber)
            ->setScopeType($scopeType);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_Limitation
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $areaName
     * @return \patest\StructType\Ticketing_Limitation
     */
    public function setAreaName(\patest\StructType\GlobalString $areaName = null)
    {
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get LimitationAppliesTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLimitationAppliesTo()
    {
        return isset($this->LimitationAppliesTo) ? $this->LimitationAppliesTo : null;
    }
    /**
     * Set LimitationAppliesTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LimitationAppliesToType::valueIsValid()
     * @uses \patest\EnumType\LimitationAppliesToType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $limitationAppliesTo
     * @return \patest\StructType\Ticketing_Limitation
     */
    public function setLimitationAppliesTo($limitationAppliesTo = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LimitationAppliesToType::valueIsValid($limitationAppliesTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LimitationAppliesToType', is_array($limitationAppliesTo) ? implode(', ', $limitationAppliesTo) : var_export($limitationAppliesTo, true), implode(', ', \patest\EnumType\LimitationAppliesToType::getValidValues())), __LINE__);
        }
        if (is_null($limitationAppliesTo) || (is_array($limitationAppliesTo) && empty($limitationAppliesTo))) {
            unset($this->LimitationAppliesTo);
        } else {
            $this->LimitationAppliesTo = $limitationAppliesTo;
        }
        return $this;
    }
    /**
     * Get LimitationGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLimitationGroupId()
    {
        return isset($this->LimitationGroupId) ? $this->LimitationGroupId : null;
    }
    /**
     * Set LimitationGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $limitationGroupId
     * @return \patest\StructType\Ticketing_Limitation
     */
    public function setLimitationGroupId($limitationGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($limitationGroupId) && !is_string($limitationGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($limitationGroupId, true), gettype($limitationGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($limitationGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $limitationGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($limitationGroupId, true)), __LINE__);
        }
        if (is_null($limitationGroupId) || (is_array($limitationGroupId) && empty($limitationGroupId))) {
            unset($this->LimitationGroupId);
        } else {
            $this->LimitationGroupId = $limitationGroupId;
        }
        return $this;
    }
    /**
     * Get LimitValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLimitValue()
    {
        return isset($this->LimitValue) ? $this->LimitValue : null;
    }
    /**
     * Set LimitValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $limitValue
     * @return \patest\StructType\Ticketing_Limitation
     */
    public function setLimitValue($limitValue = null)
    {
        // validation for constraint: int
        if (!is_null($limitValue) && !(is_int($limitValue) || ctype_digit($limitValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limitValue, true), gettype($limitValue)), __LINE__);
        }
        if (is_null($limitValue) || (is_array($limitValue) && empty($limitValue))) {
            unset($this->LimitValue);
        } else {
            $this->LimitValue = $limitValue;
        }
        return $this;
    }
    /**
     * Get LimitValueType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLimitValueType()
    {
        return isset($this->LimitValueType) ? $this->LimitValueType : null;
    }
    /**
     * Set LimitValueType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LimitationValueType::valueIsValid()
     * @uses \patest\EnumType\LimitationValueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $limitValueType
     * @return \patest\StructType\Ticketing_Limitation
     */
    public function setLimitValueType($limitValueType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LimitationValueType::valueIsValid($limitValueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LimitationValueType', is_array($limitValueType) ? implode(', ', $limitValueType) : var_export($limitValueType, true), implode(', ', \patest\EnumType\LimitationValueType::getValidValues())), __LINE__);
        }
        if (is_null($limitValueType) || (is_array($limitValueType) && empty($limitValueType))) {
            unset($this->LimitValueType);
        } else {
            $this->LimitValueType = $limitValueType;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_Limitation
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceLevelName
     * @return \patest\StructType\Ticketing_Limitation
     */
    public function setPriceLevelName(\patest\StructType\GlobalString $priceLevelName = null)
    {
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get PriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypes|null
     */
    public function getPriceTypes()
    {
        return isset($this->PriceTypes) ? $this->PriceTypes : null;
    }
    /**
     * Set PriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypes $priceTypes
     * @return \patest\StructType\Ticketing_Limitation
     */
    public function setPriceTypes(\patest\StructType\PriceTypes $priceTypes = null)
    {
        if (is_null($priceTypes) || (is_array($priceTypes) && empty($priceTypes))) {
            unset($this->PriceTypes);
        } else {
            $this->PriceTypes = $priceTypes;
        }
        return $this;
    }
    /**
     * Get ScopeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScopeId()
    {
        return isset($this->ScopeId) ? $this->ScopeId : null;
    }
    /**
     * Set ScopeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scopeId
     * @return \patest\StructType\Ticketing_Limitation
     */
    public function setScopeId($scopeId = null)
    {
        // validation for constraint: string
        if (!is_null($scopeId) && !is_string($scopeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scopeId, true), gettype($scopeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scopeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scopeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scopeId, true)), __LINE__);
        }
        if (is_null($scopeId) || (is_array($scopeId) && empty($scopeId))) {
            unset($this->ScopeId);
        } else {
            $this->ScopeId = $scopeId;
        }
        return $this;
    }
    /**
     * Get ScopeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScopeNumber()
    {
        return isset($this->ScopeNumber) ? $this->ScopeNumber : null;
    }
    /**
     * Set ScopeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scopeNumber
     * @return \patest\StructType\Ticketing_Limitation
     */
    public function setScopeNumber($scopeNumber = null)
    {
        // validation for constraint: int
        if (!is_null($scopeNumber) && !(is_int($scopeNumber) || ctype_digit($scopeNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scopeNumber, true), gettype($scopeNumber)), __LINE__);
        }
        if (is_null($scopeNumber) || (is_array($scopeNumber) && empty($scopeNumber))) {
            unset($this->ScopeNumber);
        } else {
            $this->ScopeNumber = $scopeNumber;
        }
        return $this;
    }
    /**
     * Get ScopeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScopeType()
    {
        return isset($this->ScopeType) ? $this->ScopeType : null;
    }
    /**
     * Set ScopeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LimitationScopeType::valueIsValid()
     * @uses \patest\EnumType\LimitationScopeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scopeType
     * @return \patest\StructType\Ticketing_Limitation
     */
    public function setScopeType($scopeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LimitationScopeType::valueIsValid($scopeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LimitationScopeType', is_array($scopeType) ? implode(', ', $scopeType) : var_export($scopeType, true), implode(', ', \patest\EnumType\LimitationScopeType::getValidValues())), __LINE__);
        }
        if (is_null($scopeType) || (is_array($scopeType) && empty($scopeType))) {
            unset($this->ScopeType);
        } else {
            $this->ScopeType = $scopeType;
        }
        return $this;
    }
}
