<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ItemToModifyDetails StructType
 * @subpackage Structs
 */
class Ticketing_ItemToModifyDetails extends AnyEntity
{
    /**
     * The Allocations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Allocations;
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Area;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The LastTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastTransactionGuid;
    /**
     * The Lock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Lock;
    /**
     * The PriceLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevel;
    /**
     * The ProductItemReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductItemReferenceId;
    /**
     * The Row
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Row;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The SeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatId;
    /**
     * The Selected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Selected;
    /**
     * The ServiceSpecificId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceSpecificId;
    /**
     * The Show
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Show;
    /**
     * Constructor method for Ticketing.ItemToModifyDetails
     * @uses Ticketing_ItemToModifyDetails::setAllocations()
     * @uses Ticketing_ItemToModifyDetails::setArea()
     * @uses Ticketing_ItemToModifyDetails::setEventDate()
     * @uses Ticketing_ItemToModifyDetails::setItemType()
     * @uses Ticketing_ItemToModifyDetails::setLastTransactionGuid()
     * @uses Ticketing_ItemToModifyDetails::setLock()
     * @uses Ticketing_ItemToModifyDetails::setPriceLevel()
     * @uses Ticketing_ItemToModifyDetails::setProductItemReferenceId()
     * @uses Ticketing_ItemToModifyDetails::setRow()
     * @uses Ticketing_ItemToModifyDetails::setSeat()
     * @uses Ticketing_ItemToModifyDetails::setSeatId()
     * @uses Ticketing_ItemToModifyDetails::setSelected()
     * @uses Ticketing_ItemToModifyDetails::setServiceSpecificId()
     * @uses Ticketing_ItemToModifyDetails::setShow()
     * @param string $allocations
     * @param string $area
     * @param string $eventDate
     * @param int $itemType
     * @param string $lastTransactionGuid
     * @param string $lock
     * @param string $priceLevel
     * @param string $productItemReferenceId
     * @param string $row
     * @param string $seat
     * @param int $seatId
     * @param bool $selected
     * @param string $serviceSpecificId
     * @param string $show
     */
    public function __construct($allocations = null, $area = null, $eventDate = null, $itemType = null, $lastTransactionGuid = null, $lock = null, $priceLevel = null, $productItemReferenceId = null, $row = null, $seat = null, $seatId = null, $selected = null, $serviceSpecificId = null, $show = null)
    {
        $this
            ->setAllocations($allocations)
            ->setArea($area)
            ->setEventDate($eventDate)
            ->setItemType($itemType)
            ->setLastTransactionGuid($lastTransactionGuid)
            ->setLock($lock)
            ->setPriceLevel($priceLevel)
            ->setProductItemReferenceId($productItemReferenceId)
            ->setRow($row)
            ->setSeat($seat)
            ->setSeatId($seatId)
            ->setSelected($selected)
            ->setServiceSpecificId($serviceSpecificId)
            ->setShow($show);
    }
    /**
     * Get Allocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocations()
    {
        return isset($this->Allocations) ? $this->Allocations : null;
    }
    /**
     * Set Allocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocations
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setAllocations($allocations = null)
    {
        // validation for constraint: string
        if (!is_null($allocations) && !is_string($allocations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocations, true), gettype($allocations)), __LINE__);
        }
        if (is_null($allocations) || (is_array($allocations) && empty($allocations))) {
            unset($this->Allocations);
        } else {
            $this->Allocations = $allocations;
        }
        return $this;
    }
    /**
     * Get Area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArea()
    {
        return isset($this->Area) ? $this->Area : null;
    }
    /**
     * Set Area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $area
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        if (is_null($area) || (is_array($area) && empty($area))) {
            unset($this->Area);
        } else {
            $this->Area = $area;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get LastTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastTransactionGuid()
    {
        return isset($this->LastTransactionGuid) ? $this->LastTransactionGuid : null;
    }
    /**
     * Set LastTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastTransactionGuid
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setLastTransactionGuid($lastTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($lastTransactionGuid) && !is_string($lastTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastTransactionGuid, true), gettype($lastTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastTransactionGuid, true)), __LINE__);
        }
        if (is_null($lastTransactionGuid) || (is_array($lastTransactionGuid) && empty($lastTransactionGuid))) {
            unset($this->LastTransactionGuid);
        } else {
            $this->LastTransactionGuid = $lastTransactionGuid;
        }
        return $this;
    }
    /**
     * Get Lock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLock()
    {
        return isset($this->Lock) ? $this->Lock : null;
    }
    /**
     * Set Lock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lock
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setLock($lock = null)
    {
        // validation for constraint: string
        if (!is_null($lock) && !is_string($lock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lock, true), gettype($lock)), __LINE__);
        }
        if (is_null($lock) || (is_array($lock) && empty($lock))) {
            unset($this->Lock);
        } else {
            $this->Lock = $lock;
        }
        return $this;
    }
    /**
     * Get PriceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevel()
    {
        return isset($this->PriceLevel) ? $this->PriceLevel : null;
    }
    /**
     * Set PriceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevel
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setPriceLevel($priceLevel = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevel) && !is_string($priceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevel, true), gettype($priceLevel)), __LINE__);
        }
        if (is_null($priceLevel) || (is_array($priceLevel) && empty($priceLevel))) {
            unset($this->PriceLevel);
        } else {
            $this->PriceLevel = $priceLevel;
        }
        return $this;
    }
    /**
     * Get ProductItemReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductItemReferenceId()
    {
        return isset($this->ProductItemReferenceId) ? $this->ProductItemReferenceId : null;
    }
    /**
     * Set ProductItemReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productItemReferenceId
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setProductItemReferenceId($productItemReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($productItemReferenceId) && !is_string($productItemReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productItemReferenceId, true), gettype($productItemReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productItemReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productItemReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productItemReferenceId, true)), __LINE__);
        }
        if (is_null($productItemReferenceId) || (is_array($productItemReferenceId) && empty($productItemReferenceId))) {
            unset($this->ProductItemReferenceId);
        } else {
            $this->ProductItemReferenceId = $productItemReferenceId;
        }
        return $this;
    }
    /**
     * Get Row value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRow()
    {
        return isset($this->Row) ? $this->Row : null;
    }
    /**
     * Set Row value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $row
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setRow($row = null)
    {
        // validation for constraint: string
        if (!is_null($row) && !is_string($row)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($row, true), gettype($row)), __LINE__);
        }
        if (is_null($row) || (is_array($row) && empty($row))) {
            unset($this->Row);
        } else {
            $this->Row = $row;
        }
        return $this;
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seat
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get SeatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatId()
    {
        return isset($this->SeatId) ? $this->SeatId : null;
    }
    /**
     * Set SeatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatId
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setSeatId($seatId = null)
    {
        // validation for constraint: int
        if (!is_null($seatId) && !(is_int($seatId) || ctype_digit($seatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatId, true), gettype($seatId)), __LINE__);
        }
        if (is_null($seatId) || (is_array($seatId) && empty($seatId))) {
            unset($this->SeatId);
        } else {
            $this->SeatId = $seatId;
        }
        return $this;
    }
    /**
     * Get Selected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSelected()
    {
        return isset($this->Selected) ? $this->Selected : null;
    }
    /**
     * Set Selected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $selected
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setSelected($selected = null)
    {
        // validation for constraint: boolean
        if (!is_null($selected) && !is_bool($selected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($selected, true), gettype($selected)), __LINE__);
        }
        if (is_null($selected) || (is_array($selected) && empty($selected))) {
            unset($this->Selected);
        } else {
            $this->Selected = $selected;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceSpecificId()
    {
        return isset($this->ServiceSpecificId) ? $this->ServiceSpecificId : null;
    }
    /**
     * Set ServiceSpecificId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceSpecificId
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setServiceSpecificId($serviceSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificId) && !is_string($serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificId, true), gettype($serviceSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceSpecificId, true)), __LINE__);
        }
        if (is_null($serviceSpecificId) || (is_array($serviceSpecificId) && empty($serviceSpecificId))) {
            unset($this->ServiceSpecificId);
        } else {
            $this->ServiceSpecificId = $serviceSpecificId;
        }
        return $this;
    }
    /**
     * Get Show value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShow()
    {
        return isset($this->Show) ? $this->Show : null;
    }
    /**
     * Set Show value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $show
     * @return \patest\StructType\Ticketing_ItemToModifyDetails
     */
    public function setShow($show = null)
    {
        // validation for constraint: string
        if (!is_null($show) && !is_string($show)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($show, true), gettype($show)), __LINE__);
        }
        if (is_null($show) || (is_array($show) && empty($show))) {
            unset($this->Show);
        } else {
            $this->Show = $show;
        }
        return $this;
    }
}
