<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ItemLink StructType
 * @subpackage Structs
 */
class Ticketing_ItemLink extends PersistableEntity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The Extra
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Extra;
    /**
     * The LastUpdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdate;
    /**
     * The LeftItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LeftItemId;
    /**
     * The LeftItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeftItemType;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Owner;
    /**
     * The RightItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RightItemId;
    /**
     * The RightItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RightItemType;
    /**
     * Constructor method for Ticketing.ItemLink
     * @uses Ticketing_ItemLink::setActive()
     * @uses Ticketing_ItemLink::setExtra()
     * @uses Ticketing_ItemLink::setLastUpdate()
     * @uses Ticketing_ItemLink::setLeftItemId()
     * @uses Ticketing_ItemLink::setLeftItemType()
     * @uses Ticketing_ItemLink::setOwner()
     * @uses Ticketing_ItemLink::setRightItemId()
     * @uses Ticketing_ItemLink::setRightItemType()
     * @param bool $active
     * @param string $extra
     * @param string $lastUpdate
     * @param string $leftItemId
     * @param string $leftItemType
     * @param string $owner
     * @param string $rightItemId
     * @param string $rightItemType
     */
    public function __construct($active = null, $extra = null, $lastUpdate = null, $leftItemId = null, $leftItemType = null, $owner = null, $rightItemId = null, $rightItemType = null)
    {
        $this
            ->setActive($active)
            ->setExtra($extra)
            ->setLastUpdate($lastUpdate)
            ->setLeftItemId($leftItemId)
            ->setLeftItemType($leftItemType)
            ->setOwner($owner)
            ->setRightItemId($rightItemId)
            ->setRightItemType($rightItemType);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $active
     * @return \patest\StructType\Ticketing_ItemLink
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Extra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtra()
    {
        return isset($this->Extra) ? $this->Extra : null;
    }
    /**
     * Set Extra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extra
     * @return \patest\StructType\Ticketing_ItemLink
     */
    public function setExtra($extra = null)
    {
        // validation for constraint: string
        if (!is_null($extra) && !is_string($extra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extra, true), gettype($extra)), __LINE__);
        }
        if (is_null($extra) || (is_array($extra) && empty($extra))) {
            unset($this->Extra);
        } else {
            $this->Extra = $extra;
        }
        return $this;
    }
    /**
     * Get LastUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdate()
    {
        return isset($this->LastUpdate) ? $this->LastUpdate : null;
    }
    /**
     * Set LastUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdate
     * @return \patest\StructType\Ticketing_ItemLink
     */
    public function setLastUpdate($lastUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdate) && !is_string($lastUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdate, true), gettype($lastUpdate)), __LINE__);
        }
        if (is_null($lastUpdate) || (is_array($lastUpdate) && empty($lastUpdate))) {
            unset($this->LastUpdate);
        } else {
            $this->LastUpdate = $lastUpdate;
        }
        return $this;
    }
    /**
     * Get LeftItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeftItemId()
    {
        return isset($this->LeftItemId) ? $this->LeftItemId : null;
    }
    /**
     * Set LeftItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leftItemId
     * @return \patest\StructType\Ticketing_ItemLink
     */
    public function setLeftItemId($leftItemId = null)
    {
        // validation for constraint: string
        if (!is_null($leftItemId) && !is_string($leftItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leftItemId, true), gettype($leftItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($leftItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $leftItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($leftItemId, true)), __LINE__);
        }
        if (is_null($leftItemId) || (is_array($leftItemId) && empty($leftItemId))) {
            unset($this->LeftItemId);
        } else {
            $this->LeftItemId = $leftItemId;
        }
        return $this;
    }
    /**
     * Get LeftItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeftItemType()
    {
        return isset($this->LeftItemType) ? $this->LeftItemType : null;
    }
    /**
     * Set LeftItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leftItemType
     * @return \patest\StructType\Ticketing_ItemLink
     */
    public function setLeftItemType($leftItemType = null)
    {
        // validation for constraint: string
        if (!is_null($leftItemType) && !is_string($leftItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leftItemType, true), gettype($leftItemType)), __LINE__);
        }
        if (is_null($leftItemType) || (is_array($leftItemType) && empty($leftItemType))) {
            unset($this->LeftItemType);
        } else {
            $this->LeftItemType = $leftItemType;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $owner
     * @return \patest\StructType\Ticketing_ItemLink
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($owner, true), gettype($owner)), __LINE__);
        }
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get RightItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRightItemId()
    {
        return isset($this->RightItemId) ? $this->RightItemId : null;
    }
    /**
     * Set RightItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rightItemId
     * @return \patest\StructType\Ticketing_ItemLink
     */
    public function setRightItemId($rightItemId = null)
    {
        // validation for constraint: string
        if (!is_null($rightItemId) && !is_string($rightItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rightItemId, true), gettype($rightItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($rightItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $rightItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($rightItemId, true)), __LINE__);
        }
        if (is_null($rightItemId) || (is_array($rightItemId) && empty($rightItemId))) {
            unset($this->RightItemId);
        } else {
            $this->RightItemId = $rightItemId;
        }
        return $this;
    }
    /**
     * Get RightItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRightItemType()
    {
        return isset($this->RightItemType) ? $this->RightItemType : null;
    }
    /**
     * Set RightItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rightItemType
     * @return \patest\StructType\Ticketing_ItemLink
     */
    public function setRightItemType($rightItemType = null)
    {
        // validation for constraint: string
        if (!is_null($rightItemType) && !is_string($rightItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rightItemType, true), gettype($rightItemType)), __LINE__);
        }
        if (is_null($rightItemType) || (is_array($rightItemType) && empty($rightItemType))) {
            unset($this->RightItemType);
        } else {
            $this->RightItemType = $rightItemType;
        }
        return $this;
    }
}
