<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.HallOccupancyInfo StructType
 * @subpackage Structs
 */
class Ticketing_HallOccupancyInfo extends AnyEntity
{
    /**
     * The EndDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDateTime;
    /**
     * The HallCapacity
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HallCapacity;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The OccupiedByEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OccupiedByEventId;
    /**
     * The OccupiedByEventName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $OccupiedByEventName;
    /**
     * The OccupiedSeatCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OccupiedSeatCount;
    /**
     * The SeatCountInExlusiveRestrictions
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatCountInExlusiveRestrictions;
    /**
     * The StartDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDateTime;
    /**
     * Constructor method for Ticketing.HallOccupancyInfo
     * @uses Ticketing_HallOccupancyInfo::setEndDateTime()
     * @uses Ticketing_HallOccupancyInfo::setHallCapacity()
     * @uses Ticketing_HallOccupancyInfo::setHallId()
     * @uses Ticketing_HallOccupancyInfo::setHallName()
     * @uses Ticketing_HallOccupancyInfo::setHolderCompanyId()
     * @uses Ticketing_HallOccupancyInfo::setId()
     * @uses Ticketing_HallOccupancyInfo::setOccupiedByEventId()
     * @uses Ticketing_HallOccupancyInfo::setOccupiedByEventName()
     * @uses Ticketing_HallOccupancyInfo::setOccupiedSeatCount()
     * @uses Ticketing_HallOccupancyInfo::setSeatCountInExlusiveRestrictions()
     * @uses Ticketing_HallOccupancyInfo::setStartDateTime()
     * @param string $endDateTime
     * @param int $hallCapacity
     * @param string $hallId
     * @param \patest\StructType\GlobalString $hallName
     * @param int $holderCompanyId
     * @param string $id
     * @param string $occupiedByEventId
     * @param \patest\StructType\GlobalString $occupiedByEventName
     * @param int $occupiedSeatCount
     * @param int $seatCountInExlusiveRestrictions
     * @param string $startDateTime
     */
    public function __construct($endDateTime = null, $hallCapacity = null, $hallId = null, \patest\StructType\GlobalString $hallName = null, $holderCompanyId = null, $id = null, $occupiedByEventId = null, \patest\StructType\GlobalString $occupiedByEventName = null, $occupiedSeatCount = null, $seatCountInExlusiveRestrictions = null, $startDateTime = null)
    {
        $this
            ->setEndDateTime($endDateTime)
            ->setHallCapacity($hallCapacity)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setHolderCompanyId($holderCompanyId)
            ->setId($id)
            ->setOccupiedByEventId($occupiedByEventId)
            ->setOccupiedByEventName($occupiedByEventName)
            ->setOccupiedSeatCount($occupiedSeatCount)
            ->setSeatCountInExlusiveRestrictions($seatCountInExlusiveRestrictions)
            ->setStartDateTime($startDateTime);
    }
    /**
     * Get EndDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDateTime()
    {
        return isset($this->EndDateTime) ? $this->EndDateTime : null;
    }
    /**
     * Set EndDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDateTime
     * @return \patest\StructType\Ticketing_HallOccupancyInfo
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateTime, true), gettype($endDateTime)), __LINE__);
        }
        if (is_null($endDateTime) || (is_array($endDateTime) && empty($endDateTime))) {
            unset($this->EndDateTime);
        } else {
            $this->EndDateTime = $endDateTime;
        }
        return $this;
    }
    /**
     * Get HallCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHallCapacity()
    {
        return isset($this->HallCapacity) ? $this->HallCapacity : null;
    }
    /**
     * Set HallCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hallCapacity
     * @return \patest\StructType\Ticketing_HallOccupancyInfo
     */
    public function setHallCapacity($hallCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($hallCapacity) && !(is_int($hallCapacity) || ctype_digit($hallCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hallCapacity, true), gettype($hallCapacity)), __LINE__);
        }
        if (is_null($hallCapacity) || (is_array($hallCapacity) && empty($hallCapacity))) {
            unset($this->HallCapacity);
        } else {
            $this->HallCapacity = $hallCapacity;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_HallOccupancyInfo
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\Ticketing_HallOccupancyInfo
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Ticketing_HallOccupancyInfo
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Ticketing_HallOccupancyInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get OccupiedByEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOccupiedByEventId()
    {
        return isset($this->OccupiedByEventId) ? $this->OccupiedByEventId : null;
    }
    /**
     * Set OccupiedByEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $occupiedByEventId
     * @return \patest\StructType\Ticketing_HallOccupancyInfo
     */
    public function setOccupiedByEventId($occupiedByEventId = null)
    {
        // validation for constraint: string
        if (!is_null($occupiedByEventId) && !is_string($occupiedByEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($occupiedByEventId, true), gettype($occupiedByEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($occupiedByEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $occupiedByEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($occupiedByEventId, true)), __LINE__);
        }
        if (is_null($occupiedByEventId) || (is_array($occupiedByEventId) && empty($occupiedByEventId))) {
            unset($this->OccupiedByEventId);
        } else {
            $this->OccupiedByEventId = $occupiedByEventId;
        }
        return $this;
    }
    /**
     * Get OccupiedByEventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getOccupiedByEventName()
    {
        return isset($this->OccupiedByEventName) ? $this->OccupiedByEventName : null;
    }
    /**
     * Set OccupiedByEventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $occupiedByEventName
     * @return \patest\StructType\Ticketing_HallOccupancyInfo
     */
    public function setOccupiedByEventName(\patest\StructType\GlobalString $occupiedByEventName = null)
    {
        if (is_null($occupiedByEventName) || (is_array($occupiedByEventName) && empty($occupiedByEventName))) {
            unset($this->OccupiedByEventName);
        } else {
            $this->OccupiedByEventName = $occupiedByEventName;
        }
        return $this;
    }
    /**
     * Get OccupiedSeatCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOccupiedSeatCount()
    {
        return isset($this->OccupiedSeatCount) ? $this->OccupiedSeatCount : null;
    }
    /**
     * Set OccupiedSeatCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $occupiedSeatCount
     * @return \patest\StructType\Ticketing_HallOccupancyInfo
     */
    public function setOccupiedSeatCount($occupiedSeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($occupiedSeatCount) && !(is_int($occupiedSeatCount) || ctype_digit($occupiedSeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($occupiedSeatCount, true), gettype($occupiedSeatCount)), __LINE__);
        }
        if (is_null($occupiedSeatCount) || (is_array($occupiedSeatCount) && empty($occupiedSeatCount))) {
            unset($this->OccupiedSeatCount);
        } else {
            $this->OccupiedSeatCount = $occupiedSeatCount;
        }
        return $this;
    }
    /**
     * Get SeatCountInExlusiveRestrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatCountInExlusiveRestrictions()
    {
        return isset($this->SeatCountInExlusiveRestrictions) ? $this->SeatCountInExlusiveRestrictions : null;
    }
    /**
     * Set SeatCountInExlusiveRestrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatCountInExlusiveRestrictions
     * @return \patest\StructType\Ticketing_HallOccupancyInfo
     */
    public function setSeatCountInExlusiveRestrictions($seatCountInExlusiveRestrictions = null)
    {
        // validation for constraint: int
        if (!is_null($seatCountInExlusiveRestrictions) && !(is_int($seatCountInExlusiveRestrictions) || ctype_digit($seatCountInExlusiveRestrictions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatCountInExlusiveRestrictions, true), gettype($seatCountInExlusiveRestrictions)), __LINE__);
        }
        if (is_null($seatCountInExlusiveRestrictions) || (is_array($seatCountInExlusiveRestrictions) && empty($seatCountInExlusiveRestrictions))) {
            unset($this->SeatCountInExlusiveRestrictions);
        } else {
            $this->SeatCountInExlusiveRestrictions = $seatCountInExlusiveRestrictions;
        }
        return $this;
    }
    /**
     * Get StartDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDateTime()
    {
        return isset($this->StartDateTime) ? $this->StartDateTime : null;
    }
    /**
     * Set StartDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDateTime
     * @return \patest\StructType\Ticketing_HallOccupancyInfo
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateTime, true), gettype($startDateTime)), __LINE__);
        }
        if (is_null($startDateTime) || (is_array($startDateTime) && empty($startDateTime))) {
            unset($this->StartDateTime);
        } else {
            $this->StartDateTime = $startDateTime;
        }
        return $this;
    }
}
