<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.HallHistory StructType
 * @subpackage Structs
 */
class Ticketing_HallHistory extends VolatileEntity
{
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Activity;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditId;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The LayerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LayerId;
    /**
     * The LayerLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LayerLevel;
    /**
     * The NewGuidValue
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewGuidValue;
    /**
     * The NewIntValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewIntValue;
    /**
     * The OldGuidValue
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OldGuidValue;
    /**
     * The OldIntValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OldIntValue;
    /**
     * The OperationDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationDescription;
    /**
     * The OperationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OperationId;
    /**
     * Constructor method for Ticketing.HallHistory
     * @uses Ticketing_HallHistory::setActivity()
     * @uses Ticketing_HallHistory::setAreaId()
     * @uses Ticketing_HallHistory::setAuditId()
     * @uses Ticketing_HallHistory::setDate()
     * @uses Ticketing_HallHistory::setLayerId()
     * @uses Ticketing_HallHistory::setLayerLevel()
     * @uses Ticketing_HallHistory::setNewGuidValue()
     * @uses Ticketing_HallHistory::setNewIntValue()
     * @uses Ticketing_HallHistory::setOldGuidValue()
     * @uses Ticketing_HallHistory::setOldIntValue()
     * @uses Ticketing_HallHistory::setOperationDescription()
     * @uses Ticketing_HallHistory::setOperationId()
     * @param string $activity
     * @param string $areaId
     * @param int $auditId
     * @param string $date
     * @param string $layerId
     * @param string $layerLevel
     * @param string $newGuidValue
     * @param int $newIntValue
     * @param string $oldGuidValue
     * @param int $oldIntValue
     * @param string $operationDescription
     * @param string $operationId
     */
    public function __construct($activity = null, $areaId = null, $auditId = null, $date = null, $layerId = null, $layerLevel = null, $newGuidValue = null, $newIntValue = null, $oldGuidValue = null, $oldIntValue = null, $operationDescription = null, $operationId = null)
    {
        $this
            ->setActivity($activity)
            ->setAreaId($areaId)
            ->setAuditId($auditId)
            ->setDate($date)
            ->setLayerId($layerId)
            ->setLayerLevel($layerLevel)
            ->setNewGuidValue($newGuidValue)
            ->setNewIntValue($newIntValue)
            ->setOldGuidValue($oldGuidValue)
            ->setOldIntValue($oldIntValue)
            ->setOperationDescription($operationDescription)
            ->setOperationId($operationId);
    }
    /**
     * Get Activity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivity()
    {
        return isset($this->Activity) ? $this->Activity : null;
    }
    /**
     * Set Activity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HallActivity::valueIsValid()
     * @uses \patest\EnumType\HallActivity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activity
     * @return \patest\StructType\Ticketing_HallHistory
     */
    public function setActivity($activity = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HallActivity::valueIsValid($activity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HallActivity', is_array($activity) ? implode(', ', $activity) : var_export($activity, true), implode(', ', \patest\EnumType\HallActivity::getValidValues())), __LINE__);
        }
        if (is_null($activity) || (is_array($activity) && empty($activity))) {
            unset($this->Activity);
        } else {
            $this->Activity = $activity;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_HallHistory
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditId()
    {
        return isset($this->AuditId) ? $this->AuditId : null;
    }
    /**
     * Set AuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditId
     * @return \patest\StructType\Ticketing_HallHistory
     */
    public function setAuditId($auditId = null)
    {
        // validation for constraint: int
        if (!is_null($auditId) && !(is_int($auditId) || ctype_digit($auditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditId, true), gettype($auditId)), __LINE__);
        }
        if (is_null($auditId) || (is_array($auditId) && empty($auditId))) {
            unset($this->AuditId);
        } else {
            $this->AuditId = $auditId;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \patest\StructType\Ticketing_HallHistory
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get LayerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayerId()
    {
        return isset($this->LayerId) ? $this->LayerId : null;
    }
    /**
     * Set LayerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $layerId
     * @return \patest\StructType\Ticketing_HallHistory
     */
    public function setLayerId($layerId = null)
    {
        // validation for constraint: string
        if (!is_null($layerId) && !is_string($layerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($layerId, true), gettype($layerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($layerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $layerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($layerId, true)), __LINE__);
        }
        if (is_null($layerId) || (is_array($layerId) && empty($layerId))) {
            unset($this->LayerId);
        } else {
            $this->LayerId = $layerId;
        }
        return $this;
    }
    /**
     * Get LayerLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayerLevel()
    {
        return isset($this->LayerLevel) ? $this->LayerLevel : null;
    }
    /**
     * Set LayerLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LayerLevel::valueIsValid()
     * @uses \patest\EnumType\LayerLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $layerLevel
     * @return \patest\StructType\Ticketing_HallHistory
     */
    public function setLayerLevel($layerLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LayerLevel::valueIsValid($layerLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LayerLevel', is_array($layerLevel) ? implode(', ', $layerLevel) : var_export($layerLevel, true), implode(', ', \patest\EnumType\LayerLevel::getValidValues())), __LINE__);
        }
        if (is_null($layerLevel) || (is_array($layerLevel) && empty($layerLevel))) {
            unset($this->LayerLevel);
        } else {
            $this->LayerLevel = $layerLevel;
        }
        return $this;
    }
    /**
     * Get NewGuidValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewGuidValue()
    {
        return isset($this->NewGuidValue) ? $this->NewGuidValue : null;
    }
    /**
     * Set NewGuidValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newGuidValue
     * @return \patest\StructType\Ticketing_HallHistory
     */
    public function setNewGuidValue($newGuidValue = null)
    {
        // validation for constraint: string
        if (!is_null($newGuidValue) && !is_string($newGuidValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newGuidValue, true), gettype($newGuidValue)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newGuidValue) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newGuidValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newGuidValue, true)), __LINE__);
        }
        if (is_null($newGuidValue) || (is_array($newGuidValue) && empty($newGuidValue))) {
            unset($this->NewGuidValue);
        } else {
            $this->NewGuidValue = $newGuidValue;
        }
        return $this;
    }
    /**
     * Get NewIntValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewIntValue()
    {
        return isset($this->NewIntValue) ? $this->NewIntValue : null;
    }
    /**
     * Set NewIntValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newIntValue
     * @return \patest\StructType\Ticketing_HallHistory
     */
    public function setNewIntValue($newIntValue = null)
    {
        // validation for constraint: int
        if (!is_null($newIntValue) && !(is_int($newIntValue) || ctype_digit($newIntValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newIntValue, true), gettype($newIntValue)), __LINE__);
        }
        if (is_null($newIntValue) || (is_array($newIntValue) && empty($newIntValue))) {
            unset($this->NewIntValue);
        } else {
            $this->NewIntValue = $newIntValue;
        }
        return $this;
    }
    /**
     * Get OldGuidValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldGuidValue()
    {
        return isset($this->OldGuidValue) ? $this->OldGuidValue : null;
    }
    /**
     * Set OldGuidValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldGuidValue
     * @return \patest\StructType\Ticketing_HallHistory
     */
    public function setOldGuidValue($oldGuidValue = null)
    {
        // validation for constraint: string
        if (!is_null($oldGuidValue) && !is_string($oldGuidValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldGuidValue, true), gettype($oldGuidValue)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($oldGuidValue) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $oldGuidValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($oldGuidValue, true)), __LINE__);
        }
        if (is_null($oldGuidValue) || (is_array($oldGuidValue) && empty($oldGuidValue))) {
            unset($this->OldGuidValue);
        } else {
            $this->OldGuidValue = $oldGuidValue;
        }
        return $this;
    }
    /**
     * Get OldIntValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOldIntValue()
    {
        return isset($this->OldIntValue) ? $this->OldIntValue : null;
    }
    /**
     * Set OldIntValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $oldIntValue
     * @return \patest\StructType\Ticketing_HallHistory
     */
    public function setOldIntValue($oldIntValue = null)
    {
        // validation for constraint: int
        if (!is_null($oldIntValue) && !(is_int($oldIntValue) || ctype_digit($oldIntValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oldIntValue, true), gettype($oldIntValue)), __LINE__);
        }
        if (is_null($oldIntValue) || (is_array($oldIntValue) && empty($oldIntValue))) {
            unset($this->OldIntValue);
        } else {
            $this->OldIntValue = $oldIntValue;
        }
        return $this;
    }
    /**
     * Get OperationDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationDescription()
    {
        return isset($this->OperationDescription) ? $this->OperationDescription : null;
    }
    /**
     * Set OperationDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationDescription
     * @return \patest\StructType\Ticketing_HallHistory
     */
    public function setOperationDescription($operationDescription = null)
    {
        // validation for constraint: string
        if (!is_null($operationDescription) && !is_string($operationDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationDescription, true), gettype($operationDescription)), __LINE__);
        }
        if (is_null($operationDescription) || (is_array($operationDescription) && empty($operationDescription))) {
            unset($this->OperationDescription);
        } else {
            $this->OperationDescription = $operationDescription;
        }
        return $this;
    }
    /**
     * Get OperationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationId()
    {
        return isset($this->OperationId) ? $this->OperationId : null;
    }
    /**
     * Set OperationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationId
     * @return \patest\StructType\Ticketing_HallHistory
     */
    public function setOperationId($operationId = null)
    {
        // validation for constraint: string
        if (!is_null($operationId) && !is_string($operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationId, true), gettype($operationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($operationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($operationId, true)), __LINE__);
        }
        if (is_null($operationId) || (is_array($operationId) && empty($operationId))) {
            unset($this->OperationId);
        } else {
            $this->OperationId = $operationId;
        }
        return $this;
    }
}
