<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.GaInformationLayer StructType
 * @subpackage Structs
 */
class Ticketing_GaInformationLayer extends AnyEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The GuidValue
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidValue;
    /**
     * The IntValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IntValue;
    /**
     * The LayerEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LayerEntityId;
    /**
     * The LayerLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LayerLevel;
    /**
     * The LayerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LayerType;
    /**
     * Constructor method for Ticketing.GaInformationLayer
     * @uses Ticketing_GaInformationLayer::setAreaId()
     * @uses Ticketing_GaInformationLayer::setGuidValue()
     * @uses Ticketing_GaInformationLayer::setIntValue()
     * @uses Ticketing_GaInformationLayer::setLayerEntityId()
     * @uses Ticketing_GaInformationLayer::setLayerLevel()
     * @uses Ticketing_GaInformationLayer::setLayerType()
     * @param string $areaId
     * @param string $guidValue
     * @param int $intValue
     * @param string $layerEntityId
     * @param string $layerLevel
     * @param string $layerType
     */
    public function __construct($areaId = null, $guidValue = null, $intValue = null, $layerEntityId = null, $layerLevel = null, $layerType = null)
    {
        $this
            ->setAreaId($areaId)
            ->setGuidValue($guidValue)
            ->setIntValue($intValue)
            ->setLayerEntityId($layerEntityId)
            ->setLayerLevel($layerLevel)
            ->setLayerType($layerType);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_GaInformationLayer
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get GuidValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidValue()
    {
        return isset($this->GuidValue) ? $this->GuidValue : null;
    }
    /**
     * Set GuidValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidValue
     * @return \patest\StructType\Ticketing_GaInformationLayer
     */
    public function setGuidValue($guidValue = null)
    {
        // validation for constraint: string
        if (!is_null($guidValue) && !is_string($guidValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidValue, true), gettype($guidValue)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidValue) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidValue, true)), __LINE__);
        }
        if (is_null($guidValue) || (is_array($guidValue) && empty($guidValue))) {
            unset($this->GuidValue);
        } else {
            $this->GuidValue = $guidValue;
        }
        return $this;
    }
    /**
     * Get IntValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntValue()
    {
        return isset($this->IntValue) ? $this->IntValue : null;
    }
    /**
     * Set IntValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $intValue
     * @return \patest\StructType\Ticketing_GaInformationLayer
     */
    public function setIntValue($intValue = null)
    {
        // validation for constraint: int
        if (!is_null($intValue) && !(is_int($intValue) || ctype_digit($intValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intValue, true), gettype($intValue)), __LINE__);
        }
        if (is_null($intValue) || (is_array($intValue) && empty($intValue))) {
            unset($this->IntValue);
        } else {
            $this->IntValue = $intValue;
        }
        return $this;
    }
    /**
     * Get LayerEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayerEntityId()
    {
        return isset($this->LayerEntityId) ? $this->LayerEntityId : null;
    }
    /**
     * Set LayerEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $layerEntityId
     * @return \patest\StructType\Ticketing_GaInformationLayer
     */
    public function setLayerEntityId($layerEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($layerEntityId) && !is_string($layerEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($layerEntityId, true), gettype($layerEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($layerEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $layerEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($layerEntityId, true)), __LINE__);
        }
        if (is_null($layerEntityId) || (is_array($layerEntityId) && empty($layerEntityId))) {
            unset($this->LayerEntityId);
        } else {
            $this->LayerEntityId = $layerEntityId;
        }
        return $this;
    }
    /**
     * Get LayerLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayerLevel()
    {
        return isset($this->LayerLevel) ? $this->LayerLevel : null;
    }
    /**
     * Set LayerLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LayerLevel::valueIsValid()
     * @uses \patest\EnumType\LayerLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $layerLevel
     * @return \patest\StructType\Ticketing_GaInformationLayer
     */
    public function setLayerLevel($layerLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LayerLevel::valueIsValid($layerLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LayerLevel', is_array($layerLevel) ? implode(', ', $layerLevel) : var_export($layerLevel, true), implode(', ', \patest\EnumType\LayerLevel::getValidValues())), __LINE__);
        }
        if (is_null($layerLevel) || (is_array($layerLevel) && empty($layerLevel))) {
            unset($this->LayerLevel);
        } else {
            $this->LayerLevel = $layerLevel;
        }
        return $this;
    }
    /**
     * Get LayerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayerType()
    {
        return isset($this->LayerType) ? $this->LayerType : null;
    }
    /**
     * Set LayerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LayerTypes::valueIsValid()
     * @uses \patest\EnumType\LayerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $layerType
     * @return \patest\StructType\Ticketing_GaInformationLayer
     */
    public function setLayerType($layerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LayerTypes::valueIsValid($layerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LayerTypes', is_array($layerType) ? implode(', ', $layerType) : var_export($layerType, true), implode(', ', \patest\EnumType\LayerTypes::getValidValues())), __LINE__);
        }
        if (is_null($layerType) || (is_array($layerType) && empty($layerType))) {
            unset($this->LayerType);
        } else {
            $this->LayerType = $layerType;
        }
        return $this;
    }
}
