<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EventChecklist StructType
 * @subpackage Structs
 */
class Ticketing_EventChecklist extends PersistableEntity
{
    /**
     * The Checked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Checked;
    /**
     * The ChecklistTemplateItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChecklistTemplateItemId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupName;
    /**
     * The GroupOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupOrdinal;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The RelatedPropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedPropertyName;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Required;
    /**
     * Constructor method for Ticketing.EventChecklist
     * @uses Ticketing_EventChecklist::setChecked()
     * @uses Ticketing_EventChecklist::setChecklistTemplateItemId()
     * @uses Ticketing_EventChecklist::setEventId()
     * @uses Ticketing_EventChecklist::setGroupName()
     * @uses Ticketing_EventChecklist::setGroupOrdinal()
     * @uses Ticketing_EventChecklist::setName()
     * @uses Ticketing_EventChecklist::setOrdinal()
     * @uses Ticketing_EventChecklist::setRelatedPropertyName()
     * @uses Ticketing_EventChecklist::setRequired()
     * @param bool $checked
     * @param string $checklistTemplateItemId
     * @param string $eventId
     * @param string $groupName
     * @param int $groupOrdinal
     * @param string $name
     * @param int $ordinal
     * @param string $relatedPropertyName
     * @param bool $required
     */
    public function __construct($checked = null, $checklistTemplateItemId = null, $eventId = null, $groupName = null, $groupOrdinal = null, $name = null, $ordinal = null, $relatedPropertyName = null, $required = null)
    {
        $this
            ->setChecked($checked)
            ->setChecklistTemplateItemId($checklistTemplateItemId)
            ->setEventId($eventId)
            ->setGroupName($groupName)
            ->setGroupOrdinal($groupOrdinal)
            ->setName($name)
            ->setOrdinal($ordinal)
            ->setRelatedPropertyName($relatedPropertyName)
            ->setRequired($required);
    }
    /**
     * Get Checked value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getChecked()
    {
        return isset($this->Checked) ? $this->Checked : null;
    }
    /**
     * Set Checked value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $checked
     * @return \patest\StructType\Ticketing_EventChecklist
     */
    public function setChecked($checked = null)
    {
        // validation for constraint: boolean
        if (!is_null($checked) && !is_bool($checked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checked, true), gettype($checked)), __LINE__);
        }
        if (is_null($checked) || (is_array($checked) && empty($checked))) {
            unset($this->Checked);
        } else {
            $this->Checked = $checked;
        }
        return $this;
    }
    /**
     * Get ChecklistTemplateItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChecklistTemplateItemId()
    {
        return isset($this->ChecklistTemplateItemId) ? $this->ChecklistTemplateItemId : null;
    }
    /**
     * Set ChecklistTemplateItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checklistTemplateItemId
     * @return \patest\StructType\Ticketing_EventChecklist
     */
    public function setChecklistTemplateItemId($checklistTemplateItemId = null)
    {
        // validation for constraint: string
        if (!is_null($checklistTemplateItemId) && !is_string($checklistTemplateItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checklistTemplateItemId, true), gettype($checklistTemplateItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($checklistTemplateItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $checklistTemplateItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($checklistTemplateItemId, true)), __LINE__);
        }
        if (is_null($checklistTemplateItemId) || (is_array($checklistTemplateItemId) && empty($checklistTemplateItemId))) {
            unset($this->ChecklistTemplateItemId);
        } else {
            $this->ChecklistTemplateItemId = $checklistTemplateItemId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_EventChecklist
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get GroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupName()
    {
        return isset($this->GroupName) ? $this->GroupName : null;
    }
    /**
     * Set GroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupName
     * @return \patest\StructType\Ticketing_EventChecklist
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        if (is_null($groupName) || (is_array($groupName) && empty($groupName))) {
            unset($this->GroupName);
        } else {
            $this->GroupName = $groupName;
        }
        return $this;
    }
    /**
     * Get GroupOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupOrdinal()
    {
        return isset($this->GroupOrdinal) ? $this->GroupOrdinal : null;
    }
    /**
     * Set GroupOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupOrdinal
     * @return \patest\StructType\Ticketing_EventChecklist
     */
    public function setGroupOrdinal($groupOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($groupOrdinal) && !(is_int($groupOrdinal) || ctype_digit($groupOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupOrdinal, true), gettype($groupOrdinal)), __LINE__);
        }
        if (is_null($groupOrdinal) || (is_array($groupOrdinal) && empty($groupOrdinal))) {
            unset($this->GroupOrdinal);
        } else {
            $this->GroupOrdinal = $groupOrdinal;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Ticketing_EventChecklist
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Ticketing_EventChecklist
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get RelatedPropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedPropertyName()
    {
        return isset($this->RelatedPropertyName) ? $this->RelatedPropertyName : null;
    }
    /**
     * Set RelatedPropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedPropertyName
     * @return \patest\StructType\Ticketing_EventChecklist
     */
    public function setRelatedPropertyName($relatedPropertyName = null)
    {
        // validation for constraint: string
        if (!is_null($relatedPropertyName) && !is_string($relatedPropertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedPropertyName, true), gettype($relatedPropertyName)), __LINE__);
        }
        if (is_null($relatedPropertyName) || (is_array($relatedPropertyName) && empty($relatedPropertyName))) {
            unset($this->RelatedPropertyName);
        } else {
            $this->RelatedPropertyName = $relatedPropertyName;
        }
        return $this;
    }
    /**
     * Get Required value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRequired()
    {
        return isset($this->Required) ? $this->Required : null;
    }
    /**
     * Set Required value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $required
     * @return \patest\StructType\Ticketing_EventChecklist
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        if (is_null($required) || (is_array($required) && empty($required))) {
            unset($this->Required);
        } else {
            $this->Required = $required;
        }
        return $this;
    }
}
