<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EventAndName StructType
 * @subpackage Structs
 */
class Ticketing_EventAndName extends AnyEntity
{
    /**
     * The BallotEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotEventId;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The MaxTicketApplications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTicketApplications;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NameAndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameAndDate;
    /**
     * The NumberOfRequestedTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfRequestedTickets;
    /**
     * Constructor method for Ticketing.EventAndName
     * @uses Ticketing_EventAndName::setBallotEventId()
     * @uses Ticketing_EventAndName::setHolderCompanyId()
     * @uses Ticketing_EventAndName::setId()
     * @uses Ticketing_EventAndName::setMaxTicketApplications()
     * @uses Ticketing_EventAndName::setName()
     * @uses Ticketing_EventAndName::setNameAndDate()
     * @uses Ticketing_EventAndName::setNumberOfRequestedTickets()
     * @param string $ballotEventId
     * @param int $holderCompanyId
     * @param string $id
     * @param int $maxTicketApplications
     * @param string $name
     * @param string $nameAndDate
     * @param int $numberOfRequestedTickets
     */
    public function __construct($ballotEventId = null, $holderCompanyId = null, $id = null, $maxTicketApplications = null, $name = null, $nameAndDate = null, $numberOfRequestedTickets = null)
    {
        $this
            ->setBallotEventId($ballotEventId)
            ->setHolderCompanyId($holderCompanyId)
            ->setId($id)
            ->setMaxTicketApplications($maxTicketApplications)
            ->setName($name)
            ->setNameAndDate($nameAndDate)
            ->setNumberOfRequestedTickets($numberOfRequestedTickets);
    }
    /**
     * Get BallotEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotEventId()
    {
        return isset($this->BallotEventId) ? $this->BallotEventId : null;
    }
    /**
     * Set BallotEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotEventId
     * @return \patest\StructType\Ticketing_EventAndName
     */
    public function setBallotEventId($ballotEventId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotEventId) && !is_string($ballotEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotEventId, true), gettype($ballotEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotEventId, true)), __LINE__);
        }
        if (is_null($ballotEventId) || (is_array($ballotEventId) && empty($ballotEventId))) {
            unset($this->BallotEventId);
        } else {
            $this->BallotEventId = $ballotEventId;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Ticketing_EventAndName
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Ticketing_EventAndName
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get MaxTicketApplications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTicketApplications()
    {
        return isset($this->MaxTicketApplications) ? $this->MaxTicketApplications : null;
    }
    /**
     * Set MaxTicketApplications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTicketApplications
     * @return \patest\StructType\Ticketing_EventAndName
     */
    public function setMaxTicketApplications($maxTicketApplications = null)
    {
        // validation for constraint: int
        if (!is_null($maxTicketApplications) && !(is_int($maxTicketApplications) || ctype_digit($maxTicketApplications))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTicketApplications, true), gettype($maxTicketApplications)), __LINE__);
        }
        if (is_null($maxTicketApplications) || (is_array($maxTicketApplications) && empty($maxTicketApplications))) {
            unset($this->MaxTicketApplications);
        } else {
            $this->MaxTicketApplications = $maxTicketApplications;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Ticketing_EventAndName
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NameAndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameAndDate()
    {
        return isset($this->NameAndDate) ? $this->NameAndDate : null;
    }
    /**
     * Set NameAndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameAndDate
     * @return \patest\StructType\Ticketing_EventAndName
     */
    public function setNameAndDate($nameAndDate = null)
    {
        // validation for constraint: string
        if (!is_null($nameAndDate) && !is_string($nameAndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameAndDate, true), gettype($nameAndDate)), __LINE__);
        }
        if (is_null($nameAndDate) || (is_array($nameAndDate) && empty($nameAndDate))) {
            unset($this->NameAndDate);
        } else {
            $this->NameAndDate = $nameAndDate;
        }
        return $this;
    }
    /**
     * Get NumberOfRequestedTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfRequestedTickets()
    {
        return isset($this->NumberOfRequestedTickets) ? $this->NumberOfRequestedTickets : null;
    }
    /**
     * Set NumberOfRequestedTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfRequestedTickets
     * @return \patest\StructType\Ticketing_EventAndName
     */
    public function setNumberOfRequestedTickets($numberOfRequestedTickets = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfRequestedTickets) && !(is_int($numberOfRequestedTickets) || ctype_digit($numberOfRequestedTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfRequestedTickets, true), gettype($numberOfRequestedTickets)), __LINE__);
        }
        if (is_null($numberOfRequestedTickets) || (is_array($numberOfRequestedTickets) && empty($numberOfRequestedTickets))) {
            unset($this->NumberOfRequestedTickets);
        } else {
            $this->NumberOfRequestedTickets = $numberOfRequestedTickets;
        }
        return $this;
    }
}
